/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.Let;
import org.nlogo.api.LogoException;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.ConcurrentJob;
import org.nlogo.nvm.EngineException;
import org.nlogo.nvm.ExclusiveJob;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.LetBinding;
import org.nlogo.nvm.NonLocalExit$;
import org.nlogo.nvm.Reporter;
import org.nlogo.nvm.StackTraceBuilder;
import org.nlogo.util.Exceptions;
import scala.Option;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class Context {
    public final Job job;
    public Agent myself;
    public Agent agent;
    public int agentBit;
    public int ip;
    public Activation activation;
    public boolean waiting = false;
    private boolean inReporterProcedure = false;
    public List<LetBinding> letBindings = Nil$.MODULE$;
    public boolean stopping = false;
    public boolean finished = false;

    public Context(Job job, Agent agent, int n, Activation activation) {
        this.job = job;
        this.agent = agent;
        if (agent != null) {
            this.agentBit = agent.getAgentBit();
        }
        this.ip = n;
        this.activation = activation;
    }

    public Context(Context context, AgentSet agentSet) {
        this.job = context.job;
        this.activation = context.activation;
        this.letBindings = context.letBindings;
        this.myself = context.agent;
        this.agentBit = agentSet.getAgentBit();
    }

    public Context(Context context, Agent agent) {
        this.job = context.job;
        this.activation = context.activation;
        this.letBindings = context.letBindings;
        this.myself = context.agent;
        this.agentBit = agent.getAgentBit();
    }

    public boolean makeChildrenExclusive() {
        return this.inReporterProcedure || this.job.exclusive();
    }

    void stepConcurrent() throws LogoException {
        if (this.agent.id == -1L) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.getAgentClass());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!command.switches && !this.finished);
        }
        catch (LogoException logoException) {
            EngineException.rethrow(logoException, this, command);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new EngineException(this, "stack overflow (recursion too deep)");
        }
    }

    void runExclusive() throws LogoException {
        if (this.agent.id == -1L) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.getAgentClass());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!this.finished);
        }
        catch (LogoException logoException) {
            EngineException.rethrow(logoException, this, command);
        }
    }

    public Agent myself() {
        if (this.myself == null) {
            if (this.job.parentContext == null) {
                return null;
            }
            this.myself = this.job.parentContext.agent;
        }
        return this.myself;
    }

    public boolean atTopActivation() {
        return this.job.parentContext == null || this.activation != this.job.parentContext.activation;
    }

    public void runExclusiveJob(AgentSet agentSet, int n) throws LogoException {
        new ExclusiveJob(this.job.owner, agentSet, this.activation.procedure, n, this, this.job.random).run();
        if (this.agent.id == -1L) {
            this.finished = true;
        }
    }

    public Job makeConcurrentJob(AgentSet agentSet) {
        return new ConcurrentJob(this.job.owner, agentSet, null, this.ip + 1, this, this.job.random);
    }

    public void returnFromProcedure() {
        this.ip = this.activation.returnAddress;
        this.activation = this.activation.parent;
    }

    public void stop() {
        if (this.activation.procedure.isTask()) {
            throw NonLocalExit$.MODULE$;
        }
        if (this.activation.procedure.topLevel) {
            this.job.stopping = true;
            this.finished = true;
        }
        this.returnFromProcedure();
        this.stopping = true;
    }

    public Object evaluateReporter(Agent agent, Reporter reporter) throws LogoException {
        this.agent = agent;
        return reporter.report(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callReporterProcedure(Activation activation) throws LogoException {
        boolean bl = this.inReporterProcedure;
        Command command = null;
        this.inReporterProcedure = true;
        this.activation = activation;
        this.ip = 0;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.getAgentClass());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!this.finished && this.job.result == null);
        }
        catch (NonLocalExit$ nonLocalExit$) {
        }
        catch (LogoException logoException) {
            EngineException.rethrow(logoException, this, command);
        }
        finally {
            this.inReporterProcedure = bl;
        }
        this.ip = this.activation.returnAddress;
        this.activation = this.activation.parent;
        Object object = this.job.result;
        this.job.result = null;
        return object;
    }

    public void let(Let let, Object object) {
        this.letBindings = this.letBindings.$colon$colon(new LetBinding(let, object));
    }

    public Object getLet(Let let) {
        for (List list = this.letBindings; list != Nil$.MODULE$; list = list.tail()) {
            LetBinding letBinding = list.head();
            if (let != letBinding.let) continue;
            return letBinding.value;
        }
        return this.job.parentContext.getLet(let);
    }

    public void setLet(Let let, Object object) {
        for (List list = this.letBindings; list != Nil$.MODULE$; list = list.tail()) {
            LetBinding letBinding = list.head();
            if (let != letBinding.let) continue;
            letBinding.value = object;
            return;
        }
        this.job.parentContext.setLet(let, object);
    }

    public List<LetBinding> allLets() {
        if (this.job.parentContext == null) {
            return this.letBindings;
        }
        ListBuffer listBuffer = new ListBuffer();
        Context context = this;
        while (context != null && this.activation == context.activation) {
            listBuffer.$plus$plus$eq((TraversableOnce)context.letBindings);
            context = context.job.parentContext;
        }
        return listBuffer.toList();
    }

    public void runtimeError(Exception exception) {
        try {
            Instruction instruction = null;
            Context context = null;
            if (exception instanceof EngineException) {
                instruction = ((EngineException)exception).instruction;
                context = ((EngineException)exception).context;
            }
            if (instruction == null) {
                instruction = this.activation.procedure.code[this.ip];
            }
            if (context == null) {
                context = this;
            }
            this.activation.procedure.code[this.ip].workspace.runtimeError(this.job.owner, context, instruction, exception);
        }
        catch (RuntimeException runtimeException) {
            Exceptions.handle(exception);
        }
    }

    public String buildRuntimeErrorMessage(Instruction instruction, Throwable throwable) {
        if (throwable instanceof EngineException && ((EngineException)throwable).cachedRuntimeErrorMessage.isDefined()) {
            return ((EngineException)throwable).cachedRuntimeErrorMessage.get();
        }
        return StackTraceBuilder.build(this.activation, this.agent, instruction, Option.apply(throwable));
    }

    private void comeUpForAir(Command command) throws HaltException {
        if (command.switches && this.job.owner.ownsPrimaryJobs()) {
            command.workspace.breathe();
        }
        if (Thread.currentThread().isInterrupted()) {
            command.world.comeUpForAir = false;
            this.finished = true;
            throw new HaltException(true);
        }
    }
}

