/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nlogo.api.Let;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.Syntax;
import org.nlogo.api.Token;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.Workspace;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Procedure {
    public final Type tyype;
    public final Token nameToken;
    public final String fileName;
    public final String name;
    public final String displayName;
    public int pos;
    public int endPos;
    public List<String> args = new ArrayList<String>();
    public String usableBy = "OTPL";
    public int localsCount = 0;
    public boolean topLevel = false;
    private SourceOwner owner;
    public final Procedure parent;
    public final ArrayBuffer<Procedure> children = new ArrayBuffer();
    public int size;
    public final ArrayBuffer<Let> taskFormals = new ArrayBuffer();
    public final List<Let> lets = new ArrayList<Let>();
    public final HashMap<Let, Integer> alteredLets = new HashMap();
    public Command[] code = new Command[0];

    public boolean isTask() {
        return this.parent != null;
    }

    public Let getTaskFormal(int n, Token token) {
        while (this.taskFormals.size() < n) {
            this.taskFormals.$plus$eq((Object)new Let("?" + n, token.startPos(), token.endPos(), Collections.<Let>emptyList()));
        }
        return this.taskFormals.apply(n - 1);
    }

    public Procedure(Type type, Token token, String string, Option<String> option, Procedure procedure) {
        this.tyype = type;
        this.nameToken = token;
        this.name = string;
        this.fileName = token.fileName();
        this.parent = procedure;
        this.displayName = this.buildDisplayName(option);
    }

    private String buildDisplayName(Option<String> option) {
        return this.isTask() ? "(command task from: " + this.parent.displayName + ")" : (option.isDefined() ? option.get() : "procedure " + this.getNameAndFile());
    }

    private String getNameAndFile() {
        if (this.fileName == null || this.fileName.length() == 0) {
            return this.name;
        }
        return this.name + " (" + this.fileName + ")";
    }

    public Syntax syntax() {
        int[] nArray = new int[this.args.size() - this.localsCount];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Syntax.WildcardType();
        }
        switch (this.tyype) {
            case COMMAND: {
                return Syntax.commandSyntax(nArray);
            }
            case REPORTER: {
                return Syntax.reporterSyntax(nArray, Syntax.WildcardType());
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("[");
        stringBuilder.append(this.name);
        stringBuilder.append(":");
        boolean bl = true;
        for (String string : this.args) {
            stringBuilder.append(bl ? "[" : " ");
            stringBuilder.append(string);
            bl = false;
        }
        stringBuilder.append("]");
        stringBuilder.append(":");
        stringBuilder.append(this.usableBy);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.isTask();
        if (bl) {
            stringBuilder.append("   ");
        }
        stringBuilder.append(this.displayName);
        if (this.parent != null) {
            stringBuilder.append(":" + this.parent.displayName);
        }
        stringBuilder.append(":");
        boolean bl2 = true;
        stringBuilder.append("[");
        for (String object : this.args) {
            if (!bl2) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(object);
            bl2 = false;
        }
        stringBuilder.append("]{" + this.usableBy + "}:\n");
        for (int i = 0; i < this.code.length; ++i) {
            if (bl) {
                stringBuilder.append("   ");
            }
            Command command = this.code[i];
            stringBuilder.append("[" + i + "]");
            stringBuilder.append(command.dump(bl ? 6 : 3));
            stringBuilder.append("\n");
        }
        for (Procedure procedure : JavaConversions.asJavaIterable(this.children)) {
            stringBuilder.append("\n");
            stringBuilder.append(procedure.dump());
        }
        return stringBuilder.toString();
    }

    public void init(Workspace workspace) {
        this.size = this.args.size();
        for (int i = 0; i < this.code.length; ++i) {
            this.code[i].init(workspace);
        }
        for (Procedure procedure : JavaConversions.asJavaIterable(this.children)) {
            procedure.init(workspace);
        }
    }

    public SourceOwner getOwner() {
        return this.owner;
    }

    public void setOwner(SourceOwner sourceOwner) {
        this.owner = sourceOwner;
        for (Procedure procedure : JavaConversions.asJavaIterable(this.children)) {
            procedure.setOwner(sourceOwner);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum Type {
        COMMAND,
        REPORTER;

    }
}

