/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.io.PrintWriter;
import org.nlogo.api.CSV;
import org.nlogo.api.Color$;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotExporter$;
import org.nlogo.plot.PlotPen;
import org.nlogo.plot.PlotPoint;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public class PlotExporter
implements ScalaObject {
    private final Plot plot;
    private final CSV org$nlogo$plot$PlotExporter$$csv;

    private Plot plot() {
        return this.plot;
    }

    public final CSV org$nlogo$plot$PlotExporter$$csv() {
        return this.org$nlogo$plot$PlotExporter$$csv;
    }

    public void export(PrintWriter printWriter) {
        this.exportIntro(printWriter);
        this.exportPens(printWriter);
        this.exportPoints(printWriter);
    }

    private void exportIntro(PrintWriter printWriter) {
        printWriter.println(this.org$nlogo$plot$PlotExporter$$csv().data(this.plot().name()));
        printWriter.println(this.org$nlogo$plot$PlotExporter$$csv().headerRow((String[])((Object[])new String[]{"x min", "x max", "y min", "y max", "autoplot?", "current pen", "legend open?", "number of pens"})));
        printWriter.println(this.org$nlogo$plot$PlotExporter$$csv().dataRow(new Comparable[]{Predef$.MODULE$.double2Double(this.plot().xMin()), Predef$.MODULE$.double2Double(this.plot().xMax()), Predef$.MODULE$.double2Double(this.plot().yMin()), Predef$.MODULE$.double2Double(this.plot().yMax()), Predef$.MODULE$.boolean2Boolean(this.plot().autoPlotOn()), (Comparable)this.plot().currentPen().map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(PlotPen plotPen) {
                return plotPen.name();
            }
        }).getOrElse(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "";
            }
        }), Predef$.MODULE$.boolean2Boolean(this.plot().legendIsOpen()), Predef$.MODULE$.int2Integer(this.plot().pens().size())}));
        printWriter.println();
    }

    private void exportPens(PrintWriter printWriter) {
        printWriter.println(this.org$nlogo$plot$PlotExporter$$csv().headerRow((String[])((Object[])new String[]{"pen name", "pen down?", "mode", "interval", "color", "x"})));
        this.plot().pens().foreach(new Serializable(this, printWriter){
            public static final long serialVersionUID;
            private final PlotExporter $outer;
            private final PrintWriter writer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(PlotPen plotPen) {
                this.writer$1.println(this.$outer.org$nlogo$plot$PlotExporter$$csv().dataRow(new Comparable[]{plotPen.name(), Predef$.MODULE$.boolean2Boolean(plotPen.isDown()), Predef$.MODULE$.int2Integer(plotPen.mode()), Predef$.MODULE$.double2Double(plotPen.interval()), Color$.MODULE$.argbToColor(plotPen.color()), Predef$.MODULE$.double2Double(plotPen.x())}));
            }
            {
                if (plotExporter == null) {
                    throw new NullPointerException();
                }
                this.$outer = plotExporter;
                this.writer$1 = printWriter;
            }
        });
        printWriter.println();
    }

    private void exportPoints(PrintWriter printWriter) {
        IntRef intRef = new IntRef(0);
        this.plot().pens().foreach(new Serializable(this, printWriter, intRef){
            public static final long serialVersionUID;
            private final PlotExporter $outer;
            private final PrintWriter writer$2;
            private final IntRef numPens$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(PlotPen plotPen) {
                if (this.numPens$1.elem > 0) {
                    this.writer$2.print(",,,,");
                }
                this.writer$2.print(this.$outer.org$nlogo$plot$PlotExporter$$csv().data(plotPen.name()));
                ++this.numPens$1.elem;
            }
            {
                if (plotExporter == null) {
                    throw new NullPointerException();
                }
                this.$outer = plotExporter;
                this.writer$2 = printWriter;
                this.numPens$1 = intRef;
            }
        });
        printWriter.println();
        Buffer buffer = (Buffer)Buffer$.MODULE$.apply(Nil$.MODULE$);
        Predef$.MODULE$.intWrapper(0).until(intRef.elem).foreach(new Serializable(this, buffer){
            public static final long serialVersionUID;
            private final Buffer pointHeaders$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Buffer<String> apply(int n) {
                return (Buffer)this.pointHeaders$1.$plus$eq("x", "y", Predef$.MODULE$.wrapRefArray((Object[])new String[]{"color", "pen down?"}));
            }

            public final /* synthetic */ Object apply(Object object) {
                return this.apply(BoxesRunTime.unboxToInt(object));
            }
            {
                this.pointHeaders$1 = buffer;
            }
        });
        printWriter.println(this.org$nlogo$plot$PlotExporter$$csv().headerRow((String[])buffer.toArray(ClassManifest$.MODULE$.classType(String.class))));
        ObjectRef objectRef = new ObjectRef((Buffer)Buffer$.MODULE$.apply(Nil$.MODULE$));
        IntRef intRef2 = new IntRef(0);
        this.plot().pens().foreach(new Serializable(this, objectRef, intRef2){
            public static final long serialVersionUID;
            private final ObjectRef penDataListsList$1;
            private final IntRef maxPenDataListSize$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Buffer<Seq<PlotPoint>> apply(PlotPen plotPen) {
                Buffer buffer = plotPen.points();
                if (buffer == null) {
                    buffer = (Buffer)Buffer$.MODULE$.apply(Nil$.MODULE$);
                }
                this.maxPenDataListSize$1.elem = Predef$.MODULE$.intWrapper(this.maxPenDataListSize$1.elem).max(buffer.size());
                return ((Buffer)this.penDataListsList$1.elem).$plus$eq(buffer);
            }
            {
                this.penDataListsList$1 = objectRef;
                this.maxPenDataListSize$1 = intRef;
            }
        });
        PlotPoint[][] plotPointArray = (PlotPoint[][])Array$.MODULE$.ofDim(intRef2.elem, intRef.elem, ClassManifest$.MODULE$.classType(PlotPoint.class));
        Predef$.MODULE$.intWrapper(0).until(intRef.elem).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, objectRef, plotPointArray){
            public static final long serialVersionUID;
            private final ObjectRef penDataListsList$1;
            public final PlotPoint[][] outColumnsArray$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int n) {
                this.apply$mcVI$sp(n);
            }

            public void apply$mcVI$sp(int n) {
                Seq seq = (Seq)((Buffer)this.penDataListsList$1.elem).apply(n);
                int n2 = seq.size();
                Predef$.MODULE$.intWrapper(0).until(n2).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, seq, n){
                    public static final long serialVersionUID;
                    private final $anonfun$exportPoints$1 $outer;
                    private final Seq penDataList$1;
                    private final int v1$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int n) {
                        this.apply$mcVI$sp(n);
                    }

                    public void apply$mcVI$sp(int n) {
                        this.$outer.outColumnsArray$1[n][this.v1$1] = (PlotPoint)this.penDataList$1.apply(n);
                    }

                    public final /* synthetic */ Object apply(Object object) {
                        this.apply(BoxesRunTime.unboxToInt(object));
                        return BoxedUnit.UNIT;
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                        this.penDataList$1 = seq;
                        this.v1$1 = n;
                    }
                }));
            }

            public final /* synthetic */ Object apply(Object object) {
                this.apply(BoxesRunTime.unboxToInt(object));
                return BoxedUnit.UNIT;
            }
            {
                this.penDataListsList$1 = objectRef;
                this.outColumnsArray$1 = plotPointArray;
            }
        }));
        Predef$.MODULE$.intWrapper(0).until(intRef2.elem).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, printWriter, intRef, plotPointArray){
            public static final long serialVersionUID;
            private final PlotExporter $outer;
            public final PrintWriter writer$2;
            public final IntRef numPens$1;
            public final PlotPoint[][] outColumnsArray$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int n) {
                this.apply$mcVI$sp(n);
            }

            public void apply$mcVI$sp(int n) {
                Predef$.MODULE$.intWrapper(0).until(this.numPens$1.elem).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, n){
                    public static final long serialVersionUID;
                    private final $anonfun$exportPoints$2 $outer;
                    private final int v1$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int n) {
                        this.apply$mcVI$sp(n);
                    }

                    public void apply$mcVI$sp(int n) {
                        if (this.$outer.outColumnsArray$1[this.v1$2][n] == null) {
                            if (n + 1 < this.$outer.numPens$1.elem) {
                                this.$outer.writer$2.print(",,,,");
                            } else {
                                this.$outer.writer$2.print(",,,");
                            }
                        } else {
                            this.$outer.writer$2.print(this.$outer.org$nlogo$plot$PlotExporter$$anonfun$$$outer().org$nlogo$plot$PlotExporter$$csv().data(BoxesRunTime.boxToDouble(this.$outer.outColumnsArray$1[this.v1$2][n].x())));
                            this.$outer.writer$2.print(",");
                            this.$outer.writer$2.print(this.$outer.org$nlogo$plot$PlotExporter$$anonfun$$$outer().org$nlogo$plot$PlotExporter$$csv().data(BoxesRunTime.boxToDouble(this.$outer.outColumnsArray$1[this.v1$2][n].y())));
                            this.$outer.writer$2.print(",");
                            this.$outer.writer$2.print(this.$outer.org$nlogo$plot$PlotExporter$$anonfun$$$outer().org$nlogo$plot$PlotExporter$$csv().data(Color$.MODULE$.argbToColor(this.$outer.outColumnsArray$1[this.v1$2][n].color())));
                            this.$outer.writer$2.print(",");
                            this.$outer.writer$2.print(this.$outer.org$nlogo$plot$PlotExporter$$anonfun$$$outer().org$nlogo$plot$PlotExporter$$csv().data(BoxesRunTime.boxToBoolean(this.$outer.outColumnsArray$1[this.v1$2][n].isDown())));
                            if (n + 1 < this.$outer.numPens$1.elem) {
                                this.$outer.writer$2.print(",");
                            }
                        }
                    }

                    public final /* synthetic */ Object apply(Object object) {
                        this.apply(BoxesRunTime.unboxToInt(object));
                        return BoxedUnit.UNIT;
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                        this.v1$2 = n;
                    }
                }));
                this.writer$2.println();
            }

            public PlotExporter org$nlogo$plot$PlotExporter$$anonfun$$$outer() {
                return this.$outer;
            }

            public final /* synthetic */ Object apply(Object object) {
                this.apply(BoxesRunTime.unboxToInt(object));
                return BoxedUnit.UNIT;
            }
            {
                if (plotExporter == null) {
                    throw new NullPointerException();
                }
                this.$outer = plotExporter;
                this.writer$2 = printWriter;
                this.numPens$1 = intRef;
                this.outColumnsArray$1 = plotPointArray;
            }
        }));
    }

    public PlotExporter(Plot plot2, CSV cSV) {
        this.plot = plot2;
        this.org$nlogo$plot$PlotExporter$$csv = cSV;
    }
}

