/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.util.Hashtable;
import org.nlogo.api.Agent;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Perspective;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.ShapeList;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.render.BoxRenderer;
import org.nlogo.render.HorizCylinderRenderer;
import org.nlogo.render.LinkDrawer;
import org.nlogo.render.SpotlightDrawer;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.render.TorusRenderer;
import org.nlogo.render.TrailDrawer;
import org.nlogo.render.TurtleDrawer;
import org.nlogo.render.VertCylinderRenderer;

public strictfp abstract class AbstractRenderer
implements RendererInterface {
    public final World world;
    public final LinkDrawer linkDrawer;
    public final TurtleDrawer turtleDrawer;
    private final TrailDrawer _trailDrawer;
    public TopologyRenderer topology;
    public final SpotlightDrawer spotlightDrawer = new SpotlightDrawer();
    private boolean _renderLabelsAsRectangles = false;
    private static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    Agent outlineAgent;
    private int[] patchColors;
    private Image patchImage;
    private static final ColorModel COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255);

    public TrailDrawerInterface trailDrawer() {
        return this._trailDrawer;
    }

    public boolean renderLabelsAsRectangles() {
        return this._renderLabelsAsRectangles;
    }

    public void renderLabelsAsRectangles_$eq(boolean bl) {
        this._renderLabelsAsRectangles = bl;
    }

    public AbstractRenderer(World world, ShapeList shapeList, ShapeList shapeList2) {
        this.world = world;
        this.linkDrawer = new LinkDrawer(shapeList2);
        this.turtleDrawer = new TurtleDrawer(shapeList);
        this._trailDrawer = new TrailDrawer(world, this.turtleDrawer, this.linkDrawer);
        this.changeTopology(world.wrappingAllowedInX(), world.wrappingAllowedInY());
    }

    public void changeTopology(boolean bl, boolean bl2) {
        this.topology = bl ? (bl2 ? new TorusRenderer(this.world) : new VertCylinderRenderer(this.world)) : (bl2 ? new HorizCylinderRenderer(this.world) : new BoxRenderer(this.world));
        this._trailDrawer.setTopology(this.topology);
    }

    public int getWidth(double d) {
        return (int)StrictMath.round((double)this.world.worldWidth() * d);
    }

    public int getHeight(double d) {
        return (int)StrictMath.round((double)this.world.worldHeight() * d);
    }

    public void outlineAgent(Agent agent) {
        this.outlineAgent = agent;
    }

    protected abstract void paintPatchLabels(GraphicsInterface var1, double var2);

    protected abstract void paintTurtles(GraphicsInterface var1, double var2);

    protected abstract void paintLinks(GraphicsInterface var1, double var2);

    protected abstract BufferedImage getSpotlightImage(ViewSettings var1);

    protected abstract boolean anyTurtles();

    public void prepareToPaint(ViewSettings viewSettings, int n, int n2) {
        this.topology.prepareToPaint(viewSettings, n, n2);
    }

    public void paint(GraphicsInterface graphicsInterface, ViewSettings viewSettings) {
        this.topology.prepareToPaint(viewSettings, this.getWidth(viewSettings.patchSize()), this.getHeight(viewSettings.patchSize()));
        this.topology.fillBackground(graphicsInterface);
        this.paintPatches(graphicsInterface, viewSettings.patchSize());
        if (!this._trailDrawer.drawingBlank || WINDOWS && this.anyTurtles() && !viewSettings.isHeadless()) {
            this.topology.paintViewImage(graphicsInterface, this._trailDrawer.getAndCreateDrawing(false));
        }
        graphicsInterface.setStrokeControl();
        this.paintLinks(graphicsInterface, viewSettings.patchSize());
        this.paintTurtles(graphicsInterface, viewSettings.patchSize());
        if (viewSettings.drawSpotlight() && this.spotlightAgent(viewSettings.perspective())) {
            graphicsInterface.drawImage(this.getSpotlightImage(viewSettings));
        }
    }

    private void paintPatches(GraphicsInterface graphicsInterface, double d) {
        graphicsInterface.antiAliasing(false);
        if (this.world.patchesAllBlack()) {
            this.topology.paintAllPatchesBlack(graphicsInterface);
        } else {
            this.setUpPatchImage();
            this.topology.paintViewImage(graphicsInterface, this.patchImage);
        }
        graphicsInterface.antiAliasing(true);
        this.paintPatchLabels(graphicsInterface, d);
    }

    private void setUpPatchImage() {
        if (this.patchColors != this.world.patchColors()) {
            this.patchColors = this.world.patchColors();
            this.patchImage = new BufferedImage(COLOR_MODEL, Raster.createWritableRaster(COLOR_MODEL.createCompatibleSampleModel(this.world.worldWidth(), this.world.worldHeight()), new DataBufferInt(this.patchColors, this.patchColors.length), new Point(0, 0)), true, new Hashtable());
        }
    }

    public void resetCache(double d) {
        this.turtleDrawer.shapes.resetCache(d);
    }

    protected boolean darkenPeripheral(ViewSettings viewSettings) {
        return viewSettings.perspective() == PerspectiveJ.WATCH() && viewSettings.renderPerspective();
    }

    protected boolean spotlightAgent(Perspective perspective) {
        return perspective == PerspectiveJ.WATCH() || perspective == PerspectiveJ.FOLLOW() || perspective == PerspectiveJ.RIDE();
    }
}

