/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.render.Drawable;
import org.nlogo.render.TopologyRenderer;

public strictfp abstract class AbstractTopologyRenderer
implements TopologyRenderer {
    final World world;
    int width;
    int height;
    int viewWidth;
    int viewHeight;
    int worldAndViewPreMultipliedX;
    int worldAndViewPreMultipliedY;
    double viewOffsetX;
    double viewOffsetY;

    public AbstractTopologyRenderer(World world) {
        this.world = world;
    }

    public void prepareToPaint(ViewSettings viewSettings, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.viewWidth = (int)StrictMath.round(viewSettings.viewWidth() * viewSettings.patchSize());
        this.viewHeight = (int)StrictMath.round(viewSettings.viewHeight() * viewSettings.patchSize());
        if (viewSettings.renderPerspective()) {
            this.viewOffsetX = viewSettings.viewOffsetX();
            this.viewOffsetY = viewSettings.viewOffsetY();
            this.worldAndViewPreMultipliedX = -((int)StrictMath.round(viewSettings.patchSize() * this.viewOffsetX));
            this.worldAndViewPreMultipliedY = (int)StrictMath.round(viewSettings.patchSize() * this.viewOffsetY);
        } else {
            this.worldAndViewPreMultipliedX = 0;
            this.worldAndViewPreMultipliedY = 0;
            this.viewOffsetX = 0.0;
            this.viewOffsetY = 0.0;
        }
    }

    void draw(Drawable drawable, GraphicsInterface graphicsInterface, double d, double d2, double d3, double d4, double d5) {
        if (d + d5 - d3 >= 0.0 && d - d3 <= (double)this.viewWidth && d2 + d5 - d4 >= 0.0 && d2 - d4 <= (double)this.viewHeight) {
            graphicsInterface.push();
            graphicsInterface.translate(-d3, -d4);
            drawable.draw(graphicsInterface, d5);
            graphicsInterface.pop();
        }
    }

    protected void drawLabel(String string, GraphicsInterface graphicsInterface, double d, double d2, double d3, double d4, double d5) {
        graphicsInterface.push();
        graphicsInterface.drawLabel(string, d - d3, d2 - d4, d5);
        graphicsInterface.pop();
    }

    public void drawWrappedRect(GraphicsInterface graphicsInterface, Color color, final float f, double d, double d2, double d3, double d4, final boolean bl) {
        graphicsInterface.setColor(color);
        this.wrapDrawable(new Drawable(){

            public void draw(GraphicsInterface graphicsInterface, double d) {
                graphicsInterface.setStroke(f);
                Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d, d);
                if (bl) {
                    graphicsInterface.fill(double_);
                } else {
                    graphicsInterface.draw(double_);
                }
            }

            public double adjustSize(double d, double d2) {
                return d2 >= 5.0 ? -2.0 : 0.0;
            }
        }, graphicsInterface, d, d2, d3, d4);
    }

    void fillWith(GraphicsInterface graphicsInterface, Color color) {
        graphicsInterface.setColor(color);
        graphicsInterface.fillRect(0, 0, this.width, this.height);
    }

    public void paintViewImage(GraphicsInterface graphicsInterface, Image image) {
        graphicsInterface.setInterpolation();
        graphicsInterface.drawImage(image, this.worldAndViewPreMultipliedX, this.worldAndViewPreMultipliedY, this.width, this.height);
    }

    public double wrapX(double d) {
        return this.world.wrap(d, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor() + 0.5);
    }

    public double wrapY(double d) {
        return this.world.wrap(d, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    double graphicsXNoOffset(double d, double d2) {
        return d2 * (d - ((double)this.world.minPxcor() - 0.5)) - 0.5;
    }

    double graphicsYNoOffset(double d, double d2) {
        return d2 * (-d + ((double)this.world.maxPycor() + 0.5)) - 0.5;
    }

    public final double graphicsX(double d, double d2) {
        return this.graphicsX(d, d2, this.viewOffsetX);
    }

    public double graphicsX(double d, double d2, double d3) {
        return d2 * (d - (double)this.world.minPxcor() + 0.5 - d3);
    }

    public final double graphicsY(double d, double d2) {
        return this.graphicsY(d, d2, this.viewOffsetY);
    }

    public double graphicsY(double d, double d2, double d3) {
        return d2 * (-d + (double)this.world.maxPycor() + 0.5 + d3);
    }
}

