/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.awt.Image;
import org.nlogo.api.Constants;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.World;
import org.nlogo.render.AbstractTopologyRenderer;
import org.nlogo.render.Drawable;
import org.nlogo.render.LinkDrawer;

public strictfp class HorizCylinderRenderer
extends AbstractTopologyRenderer {
    public HorizCylinderRenderer(World world) {
        super(world);
    }

    public void fillBackground(GraphicsInterface graphicsInterface) {
        if (this.viewOffsetX != 0.0) {
            this.fillWith(graphicsInterface, Constants.ViewBackground());
        }
    }

    public void wrapDrawable(Drawable drawable, GraphicsInterface graphicsInterface, double d, double d2, double d3, double d4) {
        double d5 = d3 * d4 + drawable.adjustSize(d3, d4);
        double d6 = d5 / 2.0;
        double d7 = this.graphicsX(d, d4) - d6;
        double d8 = this.graphicsY(d2, d4) - d6;
        graphicsInterface.push();
        graphicsInterface.translate(d7, d8);
        this.draw(drawable, graphicsInterface, d7, d8, 0.0, 0.0, d5);
        if (d8 + d5 > (double)this.height) {
            this.draw(drawable, graphicsInterface, d7, d8, 0.0, this.height, d5);
        }
        if (d8 < 0.0) {
            this.draw(drawable, graphicsInterface, d7, d8, 0.0, -this.height, d5);
        }
        graphicsInterface.pop();
    }

    public void drawLabelHelper(GraphicsInterface graphicsInterface, double d, double d2, String string, Object object, double d3, double d4) {
        double d5 = this.graphicsX(d + 0.5 * d4, d3);
        double d6 = this.graphicsY(d2 - 0.5 * d4, d3);
        int n = graphicsInterface.getFontMetrics().getHeight();
        graphicsInterface.setColor(org.nlogo.api.Color.getColor(object));
        this.drawLabel(string, graphicsInterface, d5, d6, 0.0, 0.0, d3);
        if (d6 > (double)this.height) {
            this.drawLabel(string, graphicsInterface, d5, d6, 0.0, this.height, d3);
        }
        if (d6 - (double)n < 0.0) {
            this.drawLabel(string, graphicsInterface, d5, d6, 0.0, -this.height, d4);
        }
    }

    public void paintAllPatchesBlack(GraphicsInterface graphicsInterface) {
        graphicsInterface.setColor(Color.BLACK);
        graphicsInterface.fillRect(this.worldAndViewPreMultipliedX, 0, this.width, this.height);
    }

    public void paintViewImage(GraphicsInterface graphicsInterface, Image image) {
        super.paintViewImage(graphicsInterface, image);
        int n = this.worldAndViewPreMultipliedY;
        if (this.worldAndViewPreMultipliedY > 0) {
            n = this.worldAndViewPreMultipliedY - this.height;
        } else if (this.worldAndViewPreMultipliedY < 0) {
            n = this.worldAndViewPreMultipliedY + this.height;
        }
        if (n != 0) {
            graphicsInterface.drawImage(image, this.worldAndViewPreMultipliedX, n, this.width, this.height);
        }
    }

    public void drawLink(GraphicsInterface graphicsInterface, Link link, LinkDrawer.LinkDrawable linkDrawable, double d, Color color, double d2) {
        double d3 = this.graphicsX(link.x1(), d);
        double d4 = this.graphicsY(link.y1(), d);
        double d5 = this.graphicsX(link.x2(), d);
        double d6 = this.graphicsY(link.y2(), d);
        int n = (int)StrictMath.max(1.0, d2 * d);
        graphicsInterface.setStroke(n);
        graphicsInterface.setColor(color);
        linkDrawable.draw(graphicsInterface, link, color, d3, d4, d5, d6, d, d2);
        if (d6 + (double)n > (double)this.height) {
            linkDrawable.draw(graphicsInterface, link, color, d3, d4 - (double)this.height, d5, d6 - (double)this.height, d, d2);
        }
        if (d6 - (double)n < 0.0) {
            linkDrawable.draw(graphicsInterface, link, color, d3, d4 + (double)this.height, d5, d6 + (double)this.height, d, d2);
        }
    }

    public void drawLine(GraphicsInterface graphicsInterface, double d, double d2, double d3, double d4, double d5) {
        double d6 = this.graphicsXNoOffset(d, this.world.patchSize());
        double d7 = this.graphicsYNoOffset(d2, this.world.patchSize());
        double d8 = this.graphicsXNoOffset(d3, this.world.patchSize());
        double d9 = this.graphicsYNoOffset(d4, this.world.patchSize());
        double d10 = d5 / 2.0;
        graphicsInterface.drawLine(d6, d7, d8, d9);
        if (d5 > 1.0) {
            if (d9 + d10 > (double)this.width) {
                graphicsInterface.drawLine(d6, d7 - (double)this.height, d8, d9 - (double)this.height);
            } else if (d7 - d10 < 0.0) {
                graphicsInterface.drawLine(d6, d7 + (double)this.height, d8, d9 + (double)this.height);
            }
        }
    }

    public double graphicsY(double d, double d2, double d3) {
        return d2 * (-d + (double)this.world.maxPycor() + 0.5 + d3);
    }
}

