/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.ShapeList;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.shape.LinkShape;

public strictfp class LinkDrawer {
    final ShapeList linkShapes;

    public LinkDrawer(ShapeList shapeList) {
        this.linkShapes = shapeList;
    }

    public void drawLink(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Link link, double d, boolean bl) {
        if (!link.hidden()) {
            if (link.size() > 0.0) {
                if (bl) {
                    this.drawLinkWithOutline(graphicsInterface, topologyRenderer, link, d);
                } else {
                    this.drawLink(graphicsInterface, topologyRenderer, link, d);
                }
            }
            if (link.hasLabel()) {
                this.drawLinkLabel(graphicsInterface, topologyRenderer, link, d);
            }
        }
    }

    void drawLink(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Link link, double d) {
        topologyRenderer.drawLink(graphicsInterface, link, this.getLinkDrawable(link), d, org.nlogo.api.Color.getColor(link.color()), link.lineThickness());
    }

    private void drawLinkWithOutline(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Link link, double d) {
        LinkDrawable linkDrawable = this.getLinkDrawable(link);
        double d2 = link.lineThickness();
        Color color = org.nlogo.api.Color.getColor(link.color());
        topologyRenderer.drawLink(graphicsInterface, link, linkDrawable, d, color, d2 + 4.0 / d);
        topologyRenderer.drawLink(graphicsInterface, link, linkDrawable, d, org.nlogo.api.Color.getComplement(color), d2 + 2.0 / d);
        topologyRenderer.drawLink(graphicsInterface, link, linkDrawable, d, color, d2);
    }

    private LinkDrawable getLinkDrawable(Link link) {
        LinkShape linkShape = (LinkShape)this.linkShapes.shape(link.shape());
        if (linkShape.isTooSimpleToPaint() && !link.isDirectedLink()) {
            return new LineDrawer();
        }
        if (linkShape.isTooSimpleToPaint()) {
            return new SimpleShapeDrawer(linkShape);
        }
        return new LinkShapeDrawer(linkShape);
    }

    private void drawLinkLabel(GraphicsInterface graphicsInterface, TopologyRenderer topologyRenderer, Link link, double d) {
        double d2 = this.labelX(link, topologyRenderer);
        double d3 = this.labelY(link, topologyRenderer);
        topologyRenderer.drawLabelHelper(graphicsInterface, d2, d3, link.labelString(), link.labelColor(), d, 1.0);
    }

    private double labelX(Link link, TopologyRenderer topologyRenderer) {
        if (!link.isDirectedLink()) {
            return link.midpointX() - 0.5;
        }
        return this.pointBetweenMidpointAndEnd2X(link, topologyRenderer, 0.5) + 0.5;
    }

    private double labelY(Link link, TopologyRenderer topologyRenderer) {
        if (!link.isDirectedLink()) {
            return link.midpointY() + 0.5;
        }
        return this.pointBetweenMidpointAndEnd2Y(link, topologyRenderer, 0.5) + 0.5;
    }

    private double pointBetweenMidpointAndEnd2X(Link link, TopologyRenderer topologyRenderer, double d) {
        double d2 = (link.x1() + link.x2()) / 2.0;
        double d3 = link.x2() - StrictMath.sin(StrictMath.toRadians(link.heading())) * (link.linkDestinationSize() - 1.0);
        double d4 = d2 - d3;
        return topologyRenderer.wrapX(d2 - d4 * d);
    }

    private double pointBetweenMidpointAndEnd2Y(Link link, TopologyRenderer topologyRenderer, double d) {
        double d2 = (link.y1() + link.y2()) / 2.0;
        double d3 = link.y2() - StrictMath.cos(StrictMath.toRadians(link.heading())) * (link.linkDestinationSize() - 1.0);
        double d4 = d2 - d3;
        return topologyRenderer.wrapY(d2 - d4 * d);
    }

    private strictfp class LinkShapeDrawer
    implements LinkDrawable {
        private final LinkShape shape;

        LinkShapeDrawer(LinkShape linkShape) {
            this.shape = linkShape;
        }

        public void draw(GraphicsInterface graphicsInterface, Link link, Color color, double d, double d2, double d3, double d4, double d5, double d6) {
            this.shape.paint(graphicsInterface, color, d, d2, d3, d4, d5, link.size(), d6, link.linkDestinationSize(), link.isDirectedLink());
        }
    }

    private strictfp class SimpleShapeDrawer
    implements LinkDrawable {
        private final LinkShape shape;

        SimpleShapeDrawer(LinkShape linkShape) {
            this.shape = linkShape;
        }

        public void draw(GraphicsInterface graphicsInterface, Link link, Color color, double d, double d2, double d3, double d4, double d5, double d6) {
            graphicsInterface.drawLine(d, d2, d3, d4);
            this.shape.paintDirectionIndicator(graphicsInterface, color, d, d2, d3, d4, link.heading(), d5, d6, link.linkDestinationSize(), link.size());
        }
    }

    private strictfp class LineDrawer
    implements LinkDrawable {
        private LineDrawer() {
        }

        public void draw(GraphicsInterface graphicsInterface, Link link, Color color, double d, double d2, double d3, double d4, double d5, double d6) {
            graphicsInterface.drawLine(d, d2, d3, d4);
        }
    }

    public static interface LinkDrawable {
        public void draw(GraphicsInterface var1, Link var2, Color var3, double var4, double var6, double var8, double var10, double var12, double var14);
    }
}

