/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Color;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.Patch;
import org.nlogo.api.Turtle;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.render.AbstractRenderer;

public strictfp class Renderer
extends AbstractRenderer {
    public Renderer(World world) {
        this(world, false);
    }

    public Renderer(World world, boolean bl) {
        super(world, world.turtleShapeList(), world.linkShapeList());
        this.renderLabelsAsRectangles_$eq(bl);
    }

    public void paint(Graphics2D graphics2D, ViewSettings viewSettings) {
        this.paint(new Graphics2DWrapper(graphics2D, this.renderLabelsAsRectangles()), viewSettings);
    }

    protected void paintPatchLabels(GraphicsInterface graphicsInterface, double d) {
        if (this.world.patchesWithLabels() > 0) {
            int n = this.world.patches().count();
            for (int i = 0; i < n; ++i) {
                Patch patch = this.world.getPatch(i);
                if (!patch.hasLabel()) continue;
                this.drawPatchLabel(graphicsInterface, patch, d);
            }
        }
        if (this.outlineAgent instanceof Patch) {
            Patch patch = (Patch)this.outlineAgent;
            this.topology.drawWrappedRect(graphicsInterface, Color.getComplement(Color.getColor(patch.pcolor())), 1.0f, patch.pxcor(), patch.pycor(), 1.0, d, false);
        }
    }

    protected void paintLinks(GraphicsInterface graphicsInterface, double d) {
        Object object;
        int n = 0;
        Collection<Object> collection = this.world.program().linkBreeds().values();
        for (Object object2 : collection) {
            if (!(object2 instanceof AgentSet)) continue;
            object = (AgentSet)object2;
            for (Agent agent : object.agents()) {
                this.linkDrawer.drawLink(graphicsInterface, this.topology, (Link)agent, d, false);
                ++n;
            }
        }
        if (n < this.world.links().count()) {
            for (Agent agent : this.world.links().agents()) {
                object = (Link)agent;
                if (object.getBreed() != this.world.links()) continue;
                this.linkDrawer.drawLink(graphicsInterface, this.topology, (Link)object, d, false);
            }
        }
        if (this.outlineAgent instanceof Link) {
            this.linkDrawer.drawLink(graphicsInterface, this.topology, (Link)this.outlineAgent, d, true);
        }
    }

    protected void paintTurtles(GraphicsInterface graphicsInterface, double d) {
        Object object;
        int n = 0;
        Collection<Object> collection = this.world.program().breeds().values();
        for (Object object2 : collection) {
            if (!(object2 instanceof AgentSet) || !Turtle.class.isAssignableFrom((object = (AgentSet)object2).type())) continue;
            for (Agent agent : object.agents()) {
                this.turtleDrawer.drawTurtle(graphicsInterface, this.topology, (Turtle)agent, d);
                ++n;
            }
        }
        if (n < this.world.turtles().count()) {
            for (Agent agent : this.world.turtles().agents()) {
                object = (Turtle)agent;
                if (object.getBreed() != this.world.turtles()) continue;
                this.turtleDrawer.drawTurtle(graphicsInterface, this.topology, (Turtle)object, d);
            }
        }
        if (this.outlineAgent instanceof Turtle) {
            this.turtleDrawer.drawTurtleWithOutline(graphicsInterface, this.topology, (Turtle)this.outlineAgent, d);
        }
    }

    private void drawPatchLabel(GraphicsInterface graphicsInterface, Patch patch, double d) {
        this.topology.drawLabelHelper(graphicsInterface, patch.pxcor(), patch.pycor(), patch.labelString(), patch.labelColor(), d, 1.0);
    }

    Agent targetAgent() {
        return this.world.observer().targetAgent();
    }

    protected BufferedImage getSpotlightImage(ViewSettings viewSettings) {
        double d;
        double d2;
        double d3;
        boolean bl = false;
        Agent agent = this.targetAgent();
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            d3 = turtle2.size() * 2.0;
            d2 = turtle2.xcor();
            d = turtle2.ycor();
            bl = true;
        } else if (agent instanceof Link) {
            Link link = (Link)agent;
            d3 = link.size();
            d2 = link.midpointX();
            d = link.midpointY();
        } else {
            Patch patch = (Patch)agent;
            d3 = 2.0;
            d2 = patch.pxcor();
            d = patch.pycor();
        }
        return this.spotlightDrawer.getImage(this.topology, d2, d, this.getWidth(viewSettings.patchSize()), this.getHeight(viewSettings.patchSize()), viewSettings.patchSize(), d3, this.darkenPeripheral(viewSettings), bl);
    }

    protected boolean anyTurtles() {
        return this.world.turtles().count() > 0;
    }

    public double graphicsX(double d, double d2, double d3) {
        return this.topology.graphicsX(d, d2, d3);
    }

    public double graphicsY(double d, double d2, double d3) {
        return this.topology.graphicsY(d, d2, d3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage exportView(ViewSettings viewSettings) {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(viewSettings.patchSize()), this.getHeight(viewSettings.patchSize()), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        Font font = graphics2D.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), viewSettings.fontSize());
        graphics2D.setFont(font2);
        World world = this.world;
        synchronized (world) {
            this.paint(graphics2D, viewSettings);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportView(Graphics2D graphics2D, ViewSettings viewSettings) {
        World world = this.world;
        synchronized (world) {
            this.paint(graphics2D, viewSettings);
        }
    }
}

