/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.nlogo.api.Agent;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.File;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.Link;
import org.nlogo.api.Perspective;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.Turtle;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.render.LinkDrawer;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.render.TurtleDrawer;
import org.nlogo.util.HexString;

public strictfp class TrailDrawer
implements TrailDrawerInterface,
ViewSettings {
    private final World world;
    private BufferedImage drawingImage = null;
    private int width;
    private int height;
    int[] colors = null;
    public TopologyRenderer topology;
    private final TurtleDrawer turtleDrawer;
    private final LinkDrawer linkDrawer;
    boolean drawingDirty = false;
    boolean drawingBlank = true;
    private boolean sendPixels = false;

    public TrailDrawer(World world, TurtleDrawer turtleDrawer, LinkDrawer linkDrawer) {
        this.world = world;
        this.turtleDrawer = turtleDrawer;
        this.linkDrawer = linkDrawer;
    }

    public int[] colors() {
        if (this.drawingDirty) {
            if (this.colors == null) {
                this.colors = new int[this.width * this.height * 4];
            }
            WritableRaster writableRaster = this.drawingImage.getRaster();
            writableRaster.getDataElements(0, 0, this.width, this.height, this.colors);
        }
        return this.colors;
    }

    public void setTopology(TopologyRenderer topologyRenderer) {
        this.topology = topologyRenderer;
    }

    public boolean sendPixels() {
        return this.sendPixels;
    }

    public void sendPixels(boolean bl) {
        this.sendPixels = bl;
    }

    public boolean isDirty() {
        return this.drawingDirty;
    }

    public boolean isBlank() {
        return this.drawingBlank;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void markDirty() {
        this.drawingBlank = false;
        this.drawingDirty = true;
    }

    public void markClean() {
        this.drawingDirty = false;
    }

    private void setUpDrawingImage() {
        this.width = (int)StrictMath.round(this.world.patchSize() * (double)this.world.worldWidth());
        this.height = (int)StrictMath.round(this.world.patchSize() * (double)this.world.worldHeight());
        if (this.width > 0 && this.height > 0) {
            this.drawingImage = new BufferedImage(this.width, this.height, 2);
            this.colors = null;
        } else {
            this.drawingImage = null;
        }
        this.drawingBlank = true;
    }

    public void rescaleDrawing() {
        BufferedImage bufferedImage = this.drawingImage;
        this.setUpDrawingImage();
        if (bufferedImage != null && this.drawingImage != null) {
            Graphics2D graphics2D = this.drawingImage.createGraphics();
            graphics2D.drawImage(bufferedImage, 0, 0, this.width, this.height, null);
            this.drawingDirty = true;
        }
    }

    public BufferedImage getAndCreateDrawing(boolean bl) {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if (bl) {
            this.drawingBlank = false;
            this.drawingDirty = true;
        }
        return this.drawingImage;
    }

    public Object getDrawing() {
        return this.drawingImage;
    }

    public void readImage(InputStream inputStream) throws IOException {
        this.setUpDrawingImage();
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        Graphics2D graphics2D = this.drawingImage.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        this.drawingBlank = false;
        this.drawingDirty = true;
    }

    public void importDrawing(InputStream inputStream) throws IOException {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if (this.drawingImage != null) {
            float f;
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage == null) {
                throw new IIOException("Unsupported image format.");
            }
            float f2 = (float)this.getWidth() / (float)bufferedImage.getWidth();
            float f3 = f2 < (f = (float)this.getHeight() / (float)bufferedImage.getHeight()) ? f2 : f;
            BufferedImage bufferedImage2 = null;
            if (f3 != 1.0f) {
                AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(f3, f3), 2);
                if (bufferedImage.getColorModel().getColorSpace().getType() == 6 && !bufferedImage.getColorModel().hasAlpha()) {
                    bufferedImage2 = affineTransformOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
                    affineTransformOp.filter(bufferedImage, bufferedImage2);
                } else {
                    bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
                }
            } else {
                bufferedImage2 = bufferedImage;
            }
            int n = (this.getWidth() - bufferedImage2.getWidth()) / 2;
            int n2 = (this.getHeight() - bufferedImage2.getHeight()) / 2;
            this.drawingImage.createGraphics().drawImage((Image)bufferedImage2, n, n2, null);
            this.markDirty();
        }
        this.sendPixels = true;
    }

    public void importDrawing(File file) throws IOException {
        try {
            this.importDrawing(file.getInputStream());
        }
        catch (IIOException iIOException) {
            throw new IIOException("Unsupported image format: " + file.getPath(), iIOException);
        }
    }

    public void exportDrawingToCSV(PrintWriter printWriter) {
        if (!this.drawingBlank) {
            printWriter.println(Dump.csv().encode("DRAWING"));
            printWriter.println(Dump.csv().encode(Double.toString(this.world.patchSize())));
            String string = HexString.toHexString(this.colors());
            Dump.csv().stringToCSV(printWriter, string);
        }
        printWriter.println();
    }

    public void setColors(int[] nArray) {
        this.setUpDrawingImage();
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        bufferedImage.setRGB(0, 0, this.width, this.height, nArray, 0, this.width);
        Graphics2D graphics2D = this.drawingImage.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        this.drawingBlank = false;
        this.drawingDirty = true;
        this.sendPixels = true;
    }

    public void clearDrawing() {
        if (this.drawingImage != null) {
            this.setUpDrawingImage();
        }
    }

    public void stamp(Agent agent, boolean bl) {
        Graphics2DWrapper graphics2DWrapper = new Graphics2DWrapper(this.getAndCreateDrawing(false).createGraphics());
        graphics2DWrapper.antiAliasing(true);
        graphics2DWrapper.setComposite(bl ? AlphaComposite.Clear : AlphaComposite.SrcOver);
        this.topology.prepareToPaint(this, this.width, this.height);
        if (agent instanceof Turtle) {
            this.turtleDrawer.drawTurtleShape(graphics2DWrapper, this.topology, (Turtle)agent, this.world.patchSize());
        } else if (agent instanceof Link) {
            this.linkDrawer.drawLink(graphics2DWrapper, this.topology, (Link)agent, this.world.patchSize(), false);
        }
        graphics2DWrapper.antiAliasing(false);
        this.markDirty();
    }

    public void drawLine(double d, double d2, double d3, double d4, Object object, double d5, String string) {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if (this.drawingImage != null) {
            Graphics2DWrapper graphics2DWrapper = new Graphics2DWrapper((Graphics2D)this.drawingImage.getGraphics());
            graphics2DWrapper.setPenWidth(d5);
            if (string.equals("erase")) {
                graphics2DWrapper.setComposite(AlphaComposite.Clear);
                this.drawWrappedLine(graphics2DWrapper, d, d2, d3, d4, d5);
                graphics2DWrapper.setComposite(AlphaComposite.SrcOver);
            } else {
                graphics2DWrapper.antiAliasing(true);
                graphics2DWrapper.setColor(Color.getColor(object));
                this.drawWrappedLine(graphics2DWrapper, d, d2, d3, d4, d5);
                graphics2DWrapper.antiAliasing(false);
            }
        }
    }

    private void drawWrappedLine(Graphics2DWrapper graphics2DWrapper, double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = d;
        double d8 = d2;
        double d9 = d;
        double d10 = d2;
        if (d9 < d7) {
            d6 = d9;
            d9 = d7;
            d7 = d6;
        }
        if (d10 < d8) {
            d6 = d10;
            d10 = d8;
            d8 = d6;
        }
        double d11 = d3 - d;
        double d12 = d4 - d2;
        double d13 = d3 - d;
        double d14 = d4 - d2;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = (double)this.world.maxPycor() + 0.4999999;
        double d18 = (double)this.world.maxPxcor() + 0.4999999;
        double d19 = (double)this.world.minPycor() - 0.5;
        double d20 = (double)this.world.minPxcor() - 0.5;
        double d21 = 1.0 / this.world.patchSize();
        do {
            d9 = d7 + d13;
            d10 = d8 + d14;
            if (d10 < d19) {
                d9 = (d19 - d8) * d11 / d12 + d7;
                d10 = d19;
                d16 = d17;
                d15 = d9;
                if (d15 == d20) {
                    d15 = d18;
                } else if (d15 == d18) {
                    d15 = d20;
                }
            }
            if (d10 > d17) {
                d9 = d7 + (d17 - d8) * d11 / d12;
                d10 = d17;
                d15 = d9;
                d16 = d19;
                if (d15 == d20) {
                    d15 = d18;
                } else if (d15 == d18) {
                    d15 = d20;
                }
            }
            if (d9 < d20) {
                d9 = d20;
                d10 = d12 * (d9 - d7) / d11 + d8;
                d15 = d18;
                d16 = d10;
                if (d16 == d19) {
                    d16 = d17;
                } else if (d16 == d17) {
                    d16 = d19;
                }
            }
            if (d9 > d18) {
                d9 = d18;
                d10 = d12 * (d9 - d7) / d11 + d8;
                d15 = d20;
                d16 = d10;
                if (d16 == d19) {
                    d16 = d17;
                } else if (d16 == d17) {
                    d16 = d19;
                }
            }
            this.topology.drawLine(graphics2DWrapper, d7, d8, d9, d10, d5);
            d7 = d15;
        } while (StrictMath.abs(d14 -= d10 - (d8 = d16)) >= d21 || StrictMath.abs(d13 -= d9 - d7) >= d21);
        this.markDirty();
    }

    public int fontSize() {
        throw new UnsupportedOperationException();
    }

    public double patchSize() {
        return this.world.patchSize();
    }

    public double viewWidth() {
        return this.world.worldWidth();
    }

    public double viewHeight() {
        return this.world.worldHeight();
    }

    public Perspective perspective() {
        throw new UnsupportedOperationException();
    }

    public double viewOffsetX() {
        throw new UnsupportedOperationException();
    }

    public double viewOffsetY() {
        throw new UnsupportedOperationException();
    }

    public boolean drawSpotlight() {
        throw new UnsupportedOperationException();
    }

    public boolean renderPerspective() {
        return false;
    }

    public boolean isHeadless() {
        throw new UnsupportedOperationException();
    }
}

