/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.nlogo.api.ShapeList;
import org.nlogo.api.Turtle;
import org.nlogo.render.CacheKey;
import org.nlogo.render.CachedShape;
import org.nlogo.shape.VectorShape;

public strictfp class TurtleShapeManager {
    private final Queue<CacheKey> cacheQueue = new LinkedList<CacheKey>();
    private final Map<CacheKey, CachedShape> shapeCache = new HashMap<CacheKey, CachedShape>();
    final ShapeList shapeList;
    private int cellSize;
    private int pixelCount = 0;
    private int angleStep;
    private int numAngleSteps;

    TurtleShapeManager(ShapeList shapeList) {
        this.shapeList = shapeList;
    }

    void resetCache(double d) {
        this.shapeCache.clear();
        this.cacheQueue.clear();
        this.pixelCount = 0;
        this.cellSize = (int)StrictMath.floor(d);
        if (this.cellSize == 0) {
            this.angleStep = 1;
        } else {
            this.angleStep = 30 / this.cellSize;
            if (this.angleStep == 0) {
                this.angleStep = 1;
            }
        }
        this.numAngleSteps = 360 / this.angleStep;
    }

    boolean useCache(Turtle turtle2, double d) {
        double d2 = turtle2.size();
        return d == (double)this.cellSize && (d2 == 1.0 || d2 == 1.5 || d2 == 2.0) && turtle2.lineThickness() == 0.0;
    }

    VectorShape getShape(Turtle turtle2) {
        return (VectorShape)this.shapeList.shape(turtle2.shape());
    }

    CachedShape getCachedShape(VectorShape vectorShape, Color color, double d, double d2) {
        int n;
        if (vectorShape.isRotatable()) {
            n = (int)StrictMath.rint(d / (double)this.angleStep);
            if (n == this.numAngleSteps) {
                n = 0;
            }
            d = n * this.angleStep;
        } else {
            n = 0;
            d = 0.0;
        }
        CacheKey cacheKey = new CacheKey(color.getRGB(), n, vectorShape, d2);
        CachedShape cachedShape = this.shapeCache.get(cacheKey);
        if (cachedShape != null) {
            return cachedShape;
        }
        while (this.pixelCount >= 0x200000) {
            this.discardOldestShape();
        }
        CachedShape cachedShape2 = new CachedShape(vectorShape, this.cellSize, (int)d, d2, color);
        this.shapeCache.put(cacheKey, cachedShape2);
        this.cacheQueue.add(cacheKey);
        this.pixelCount += cachedShape2.getPixelCount();
        return cachedShape2;
    }

    private void discardOldestShape() {
        CacheKey cacheKey = this.cacheQueue.remove();
        this.pixelCount -= this.shapeCache.get(cacheKey).getPixelCount();
        this.shapeCache.remove(cacheKey);
    }
}

