/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.QuadCurve2D;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.nlogo.api.GraphicsInterface;

public strictfp class LinkLine
implements Serializable,
Cloneable {
    private float[] dashes;
    private double xcor = 0.0;
    private boolean isVisible = false;
    public static final float[][] dashChoices = new float[][]{{0.0f, 1.0f}, {1.0f, 0.0f}, {2.0f, 2.0f}, {4.0f, 4.0f}, {4.0f, 4.0f, 2.0f, 2.0f}};

    public LinkLine() {
        this.dashes = dashChoices[1];
    }

    public LinkLine(double d, boolean bl) {
        this.xcor = d;
        this.isVisible = bl;
        this.dashes = dashChoices[bl ? 1 : 0];
    }

    public boolean isStraightPlainLine() {
        return this.isVisible && this.xcor == 0.0 && this.dashes.length == 2 && this.dashes[0] == 1.0f && this.dashes[1] == 0.0f;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void paint(GraphicsInterface graphicsInterface, Color color, double d, float f, Shape shape2) {
        graphicsInterface.setColor(color);
        graphicsInterface.setStroke(f, this.dashes);
        graphicsInterface.draw(shape2);
    }

    public Shape getShape(double d, double d2, double d3, double d4, double d5, double d6, double d7, float f) {
        double d8 = (d - d3) / d6;
        double d9 = (d4 - d2) / d6;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d9 * this.xcor * (double)f, d8 * this.xcor * (double)f);
        double d10 = (d + d3) / 2.0 + d5 * d9;
        double d11 = (d2 + d4) / 2.0 + d5 * d8;
        return affineTransform.createTransformedShape(new QuadCurve2D.Double(d, d2, d10, d11, d3, d4));
    }

    public String dashinessString() {
        String string = "";
        for (int i = 0; i < this.dashes.length; ++i) {
            if (string.length() > 0) {
                string = string + " ";
            }
            string = string + this.dashes[i];
        }
        return string;
    }

    public Object clone() {
        LinkLine linkLine;
        try {
            linkLine = (LinkLine)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
        linkLine.dashes = new float[this.dashes.length];
        System.arraycopy(this.dashes, 0, linkLine.dashes, 0, this.dashes.length);
        return linkLine;
    }

    public String toString() {
        return this.xcor + " " + (this.isVisible ? "1" : "0") + " " + this.dashinessString();
    }

    private static int getDashIndex(float[] fArray) {
        boolean bl = false;
        for (int i = 0; i < dashChoices.length; ++i) {
            if (fArray.length != dashChoices[i].length) continue;
            for (int j = 0; j < fArray.length; ++j) {
                bl = fArray[j] == dashChoices[i][j];
            }
            if (!bl) continue;
            return i;
        }
        return 1;
    }

    public static int parseLine(String[] stringArray, String string, LinkLine linkLine, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n]);
        linkLine.xcor = Double.parseDouble(stringTokenizer.nextToken());
        boolean bl = linkLine.isVisible = Integer.parseInt(stringTokenizer.nextToken()) != 0;
        if (linkLine.isVisible) {
            float[] fArray = new float[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                fArray[n2] = Float.parseFloat(stringTokenizer.nextToken());
                ++n2;
            }
            linkLine.dashes = dashChoices[LinkLine.getDashIndex(fArray)];
        } else {
            linkLine.dashes = dashChoices[0];
        }
        return ++n;
    }
}

