/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.LinkLine;
import org.nlogo.shape.VectorShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class LinkShape
implements Serializable,
Cloneable,
org.nlogo.api.Shape {
    private VectorShape directionIndicator;
    private double curviness;
    private String name = "";
    private LinkLine[] lines = new LinkLine[3];

    public LinkShape() {
        this.directionIndicator = LinkShape.getDefaultLinkDirectionShape();
        this.lines[0] = new LinkLine(-0.2, false);
        this.lines[1] = new LinkLine(0.0, true);
        this.lines[2] = new LinkLine(0.2, false);
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void add(int n, LinkLine linkLine) {
        this.lines[n] = linkLine;
    }

    public boolean isTooSimpleToPaint() {
        return !this.lines[0].isVisible() && !this.lines[2].isVisible() && this.curviness == 0.0 && this.lines[1].isStraightPlainLine();
    }

    public void setDirectionIndicator(VectorShape vectorShape) {
        this.directionIndicator = vectorShape;
    }

    public void paint(GraphicsInterface graphicsInterface, Color color, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        for (int i = 0; i < this.lines.length; ++i) {
            if (!this.lines[i].isVisible()) continue;
            float f = (float)StrictMath.max(1.0, d5 * d7);
            Shape shape2 = this.lines[i].getShape(d, d2, d3, d4, this.curviness, d6, d5, f);
            this.lines[i].paint(graphicsInterface, color, d5, f, shape2);
        }
        if (bl) {
            Shape shape3 = this.lines[1].getShape(d3, d4, d, d2, -this.curviness, d6, d5, 1.0f);
            this.paintDirectionIndicator(graphicsInterface, color, shape3, d5, d7, d6, d8 + 1.0);
        }
    }

    public void paintDirectionIndicator(GraphicsInterface graphicsInterface, Color color, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = (d - d3) / d9 * d8 * 2.0 / 3.0;
        double d11 = (d4 - d2) / d9 * d8 * 2.0 / 3.0;
        double d12 = (d - d3) / 2.0;
        double d13 = (d4 - d2) / 2.0;
        if (StrictMath.abs(d12) < StrictMath.abs(d10) && StrictMath.abs(d13) < StrictMath.abs(d11)) {
            d10 = d12;
            d11 = d13;
        }
        double d14 = this.directionIndicatorScale(d7, d6);
        this.directionIndicator.paint(graphicsInterface, color, d3 + d10 - d6 * d14 / 2.0, d4 - d11 - d6 * d14 / 2.0, d14, d6, (int)d5, d7);
    }

    public int numLines() {
        int n = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            if (!this.lines[i].isVisible()) continue;
            ++n;
        }
        return n;
    }

    public void paintDirectionIndicator(GraphicsInterface graphicsInterface, Color color, Shape shape2, double d, double d2, double d3, double d4) {
        double[] dArray = this.getDirectionIndicatorTransform(shape2, this.getDestShape(shape2, d4, d));
        double d5 = this.directionIndicatorScale(d2, d);
        this.directionIndicator.paint(graphicsInterface, color, dArray[1] - d * d5 / 2.0, dArray[2] - d * d5 / 2.0, d5, d, (int)dArray[0], d2);
    }

    private double directionIndicatorScale(double d, double d2) {
        return (d * StrictMath.sqrt(d2 / 2.0) + 2.0) * StrictMath.max(1.0, (double)this.numLines() / 1.5);
    }

    public Shape getDestShape(Shape shape2, double d, double d2) {
        PathIterator pathIterator = shape2.getPathIterator(null, 1.0);
        double[] dArray = new double[6];
        pathIterator.currentSegment(dArray);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(dArray[0], dArray[1]);
        affineTransform.scale(d2, d2);
        affineTransform.scale(d, d);
        return affineTransform.createTransformedShape(new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0));
    }

    public double[] getDirectionIndicatorTransform(Shape shape2, Shape shape3) {
        double[] dArray = new double[6];
        Point2D.Double double_ = null;
        Point2D.Double double_2 = null;
        double[] dArray2 = new double[3];
        PathIterator pathIterator = shape2.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                double_2 = new Point2D.Double(dArray[0], dArray[1]);
            } else if (n == 1) {
                double_ = double_2;
                double_2 = new Point2D.Double(dArray[0], dArray[1]);
                if (shape3.contains(double_) && !shape3.contains(double_2)) {
                    dArray2 = this.getDirectionIndicatorTransform(new Line2D.Double(double_, double_2), shape3);
                    break;
                }
            }
            pathIterator.next();
        }
        return dArray2;
    }

    public double[] getDirectionIndicatorTransform(Line2D line2D, Shape shape2) {
        double d = line2D.getX1() - line2D.getX2();
        double d2 = line2D.getY1() - line2D.getY2();
        while (d * d + d2 * d2 > 1.0) {
            line2D = this.getLastOutsideSegment(line2D, shape2);
            d = line2D.getX1() - line2D.getX2();
            d2 = line2D.getY1() - line2D.getY2();
        }
        double d3 = (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(d2, d))) % 360.0;
        return new double[]{d3, line2D.getX1(), line2D.getY1()};
    }

    protected Line2D getLastOutsideSegment(Line2D line2D, Shape shape2) {
        Line2D.Double double_ = new Line2D.Double();
        Line2D.Double double_2 = new Line2D.Double();
        do {
            this.split(line2D, double_, double_2);
        } while (!shape2.contains((line2D = double_).getP2()));
        return double_2;
    }

    protected void split(Line2D line2D, Line2D line2D2, Line2D line2D3) {
        double d = line2D.getX1();
        double d2 = line2D.getY1();
        double d3 = line2D.getX2();
        double d4 = line2D.getY2();
        double d5 = d + (d3 - d) / 2.0;
        double d6 = d2 + (d4 - d2) / 2.0;
        line2D2.setLine(d, d2, d5, d6);
        line2D3.setLine(d5, d6, d3, d4);
    }

    public Object clone() {
        LinkShape linkShape;
        try {
            linkShape = (LinkShape)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
        linkShape.directionIndicator = (VectorShape)this.directionIndicator.clone();
        linkShape.lines = new LinkLine[this.lines.length];
        for (int i = 0; i < this.lines.length; ++i) {
            linkShape.lines[i] = (LinkLine)this.lines[i].clone();
        }
        return linkShape;
    }

    public String toString() {
        String string = this.name + "\n" + this.curviness + "\n";
        for (int i = 0; i < this.lines.length; ++i) {
            string = string + this.lines[i].toString() + "\n";
        }
        string = string + this.directionIndicator.toString();
        return string;
    }

    public static List<org.nlogo.api.Shape> parseShapes(String[] stringArray, String string) {
        int n;
        ArrayList<org.nlogo.api.Shape> arrayList = new ArrayList<org.nlogo.api.Shape>();
        for (n = 0; stringArray.length > n && 0 == VectorShape.getString(stringArray, n).length(); ++n) {
        }
        while (stringArray.length > n) {
            LinkShape linkShape = new LinkShape();
            n = LinkShape.parseShape(stringArray, string, linkShape, n);
            arrayList.add(linkShape);
            ++n;
        }
        return arrayList;
    }

    public static int parseShape(String[] stringArray, String string, LinkShape linkShape, int n) {
        linkShape.setName(VectorShape.getString(stringArray, n++));
        linkShape.curviness = Double.parseDouble(VectorShape.getString(stringArray, n++));
        for (int i = 0; i < 3; ++i) {
            LinkLine linkLine = new LinkLine();
            n = LinkLine.parseLine(stringArray, string, linkLine, n);
            linkShape.add(i, linkLine);
        }
        VectorShape vectorShape = new VectorShape();
        n = VectorShape.parseShape(stringArray, string, vectorShape, n);
        linkShape.setDirectionIndicator(vectorShape);
        return n;
    }

    public static VectorShape getDefaultLinkDirectionShape() {
        VectorShape vectorShape = new VectorShape();
        vectorShape.setName("link direction");
        vectorShape.setRotatable(true);
        vectorShape.setEditableColorIndex(0);
        vectorShape.addElement("Line -7500403 true 150 150 90 180");
        vectorShape.addElement("Line -7500403 true 150 150 210 180");
        return vectorShape;
    }
}

