/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.util.StringTokenizer;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.shape.Element;

public strictfp class Rectangle
extends Element
implements Cloneable {
    protected Point upperLeft;
    protected Point upperRight;
    protected Point lowerRight;
    protected Point lowerLeft;
    protected int xmin;
    protected int xmax;
    protected int ymin;
    protected int ymax;

    public Rectangle(Point point, Point point2, Color color) {
        super(color);
        this.upperLeft = new Point(point);
        this.upperRight = new Point(point2.x, point.y);
        this.lowerLeft = new Point(point.x, point2.y);
        this.lowerRight = new Point(point2);
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public Object clone() {
        Rectangle rectangle = (Rectangle)super.clone();
        rectangle.upperLeft = (Point)rectangle.upperLeft.clone();
        rectangle.upperRight = (Point)rectangle.upperRight.clone();
        rectangle.lowerLeft = (Point)rectangle.lowerLeft.clone();
        rectangle.lowerRight = (Point)rectangle.lowerRight.clone();
        return rectangle;
    }

    public void setMaxsAndMins() {
        int[] nArray = new int[]{this.upperLeft.x, this.upperRight.x, this.lowerRight.x, this.lowerLeft.x};
        int[] nArray2 = new int[]{this.upperLeft.y, this.upperRight.y, this.lowerRight.y, this.lowerLeft.y};
        this.xmin = this.min(nArray);
        this.xmax = this.max(nArray);
        this.ymin = this.min(nArray2);
        this.ymax = this.max(nArray2);
    }

    public void draw(GraphicsInterface graphicsInterface, Color color, double d, double d2) {
        graphicsInterface.setColor(this.getColor(color));
        if (this.filled) {
            graphicsInterface.fillRect(this.upperLeft.x, this.upperLeft.y, this.upperRight.x - this.upperLeft.x, this.lowerLeft.y - this.upperLeft.y, d, d2);
        } else {
            graphicsInterface.drawRect(this.upperLeft.x, this.upperLeft.y, this.upperRight.x - this.upperLeft.x, this.lowerLeft.y - this.upperLeft.y, d, d2);
        }
    }

    public String toString() {
        return "Rectangle " + this.c.getRGB() + " " + this.filled + " " + this.marked + " " + this.upperLeft.x + " " + this.upperLeft.y + " " + this.lowerRight.x + " " + this.lowerRight.y;
    }

    public static Rectangle parseRectangle(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        boolean bl = stringTokenizer.nextToken().equals("true");
        boolean bl2 = stringTokenizer.nextToken().equals("true");
        int n = Integer.valueOf(stringTokenizer.nextToken());
        int n2 = Integer.valueOf(stringTokenizer.nextToken());
        int n3 = Integer.valueOf(stringTokenizer.nextToken());
        int n4 = Integer.valueOf(stringTokenizer.nextToken());
        if (n == n3 && n2 == n4) {
            return null;
        }
        Rectangle rectangle = new Rectangle(new Point(n, n2), new Point(n3, n4), Color.decode(string2));
        rectangle.setFilled(bl);
        rectangle.setMarked(bl2);
        return rectangle;
    }
}

