/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.agent.ChooserConstraint;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Dump;
import org.nlogo.awt.Fonts;
import org.nlogo.swing.WrappingPopupMenu;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.SingleErrorWidget;

public strictfp abstract class Chooser
extends SingleErrorWidget
implements MouseWheelListener {
    protected final CompilerServices compiler;
    ChooserConstraint constraint = new ChooserConstraint(ChooserConstraint.init$default$1(), ChooserConstraint.init$default$2());
    private final ChooserClickControl control = new ChooserClickControl();
    private String name = "";

    public Chooser(CompilerServices compilerServices) {
        this.compiler = compilerServices;
        this.setOpaque(true);
        this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
        this.setLayout(null);
        this.add(this.control);
        this.doLayout();
        Fonts.adjustDefaultFont(this);
        this.addMouseWheelListener(this);
    }

    public String name() {
        return this.name;
    }

    public void name(String string) {
        this.name = string;
        this.repaint();
    }

    protected int index() {
        return this.constraint.defaultIndex();
    }

    protected void index(int n) {
        this.constraint.defaultIndex_$eq(n);
        this.updateConstraints();
        this.repaint();
    }

    public Object value() {
        return this.constraint.defaultValue();
    }

    public void updateConstraints() {
        if (this.name().length() > 0) {
            new Events.AddChooserConstraintEvent(this.name, this.constraint).raise(this);
        }
    }

    public void doLayout() {
        int n = this.getHeight() / 2;
        this.control.setBounds(4, this.getHeight() - 4 - n, this.getWidth() - 8, n);
    }

    public Dimension getMinimumSize() {
        return new Dimension(92, 45);
    }

    public Dimension getMaximumSize() {
        return new Dimension(10000, 45);
    }

    public Dimension getPreferredSize(Font font) {
        int n = 120;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        n = StrictMath.max(n, fontMetrics.stringWidth(this.name) + 8 + 14);
        n = StrictMath.max(n, this.longestChoiceWidth(fontMetrics) + this.triangleSize() + 20 + 14 + 2);
        return new Dimension(n, 45);
    }

    private int longestChoiceWidth(FontMetrics fontMetrics) {
        int n = 0;
        for (int i = 0; i < this.constraint.acceptedValues().size(); ++i) {
            int n2 = fontMetrics.stringWidth(Dump.logoObject(this.constraint.acceptedValues().get(i)));
            n = StrictMath.max(n, n2);
        }
        return n;
    }

    private int triangleSize() {
        return this.control.getBounds().height / 2 - 4;
    }

    public void popup() {
        WrappingPopupMenu wrappingPopupMenu = new WrappingPopupMenu();
        this.populate(wrappingPopupMenu);
        wrappingPopupMenu.show(this, this.control.getBounds().x + 3, this.control.getBounds().y + this.control.getBounds().height);
    }

    public void populate(JPopupMenu jPopupMenu) {
        if (this.constraint.acceptedValues().isEmpty()) {
            JMenuItem jMenuItem = new JMenuItem("<No Choices>");
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
        } else {
            int n = 0;
            while (n < this.constraint.acceptedValues().size()) {
                JMenuItem jMenuItem = new JMenuItem(Dump.logoObject(this.constraint.acceptedValues().get(n)));
                final int n2 = n++;
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Chooser.this.index(n2);
                    }
                });
                jPopupMenu.add(jMenuItem);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Rectangle rectangle = this.control.getBounds();
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getMaxAscent();
        int n2 = n + fontMetrics.getMaxDescent();
        String string = Fonts.shortenStringToFit(this.name, dimension.width - 8, fontMetrics);
        graphics.drawString(string, 4, 4 + (rectangle.y - 4 - n2) / 2 + n);
        String string2 = Fonts.shortenStringToFit(Dump.logoObject(this.value()), rectangle.width - 12 - this.triangleSize() - 2, fontMetrics);
        graphics.drawString(string2, rectangle.x + 4, rectangle.y + (rectangle.height - n2) / 2 + n);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Chooser.filledDownTriangle(graphics, rectangle.x + rectangle.width - 4 - this.triangleSize() - 2, rectangle.y + (rectangle.height - this.triangleSize()) / 2 + 1, this.triangleSize());
    }

    private static void filledDownTriangle(Graphics graphics, int n, int n2, int n3) {
        Polygon polygon = new Polygon();
        polygon.addPoint(n + n3 / 2, n2 + n3 + 2);
        polygon.addPoint(n - 1, n2 - 1);
        polygon.addPoint(n + n3 + 2, n2 - 1);
        graphics.setColor(Color.DARK_GRAY);
        graphics.fillPolygon(polygon);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(n + n3 / 2, n2 + n3);
        polygon2.addPoint(n, n2);
        polygon2.addPoint(n + n3, n2);
        graphics.setColor(InterfaceColors.SLIDER_HANDLE);
        graphics.fillPolygon(polygon2);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWheelRotation() >= 1) {
            int n = this.constraint.acceptedValues().size() - 1;
            this.index(StrictMath.min(n, this.index() + 1));
        } else {
            this.index(StrictMath.max(0, this.index() - 1));
        }
    }

    private strictfp class ChooserClickControl
    extends JComponent {
        ChooserClickControl() {
            this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
            this.setBorder(Chooser.this.widgetBorder());
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    Chooser.this.popup();
                }
            });
        }
    }
}

