/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.nlogo.awt.EventQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class Event {
    private Thread raisingThread = null;
    public static boolean logEvents = false;
    private static Map<Object, Map<Class<?>, List<Handler>>> handlers = new HashMap();
    private static List<Object[]> recentEvents = new ArrayList<Object[]>();
    private static int nestingDepth = 0;
    private static Map<Class<?>, Set<Class<? extends Event>>> eventsHandledMap = new HashMap();

    public abstract void beHandledBy(Handler var1);

    public static String recentEventTrace() {
        EventQueue.mustBeEventDispatchThread();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object[] objectArray : recentEvents) {
            Event event = (Event)objectArray[0];
            Object object = objectArray[1];
            Thread thread = (Thread)objectArray[2];
            Date date = (Date)objectArray[3];
            String string = new SimpleDateFormat("hh:mm:ss.SSS").format(date);
            stringBuilder.append(string + " " + Event.eventName(event) + " (" + Event.readableName(object) + ") " + thread.getName() + "\n");
        }
        return stringBuilder.toString();
    }

    public static void rehash() {
        handlers.clear();
    }

    private static String eventName(Object object) {
        String string = object.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        return string2.substring(string2.lastIndexOf(36) + 1);
    }

    private static String readableName(Object object) {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        while (clazz.getName().indexOf(36) != -1) {
            clazz = clazz.getSuperclass();
        }
        if (clazz == object.getClass()) {
            return string;
        }
        return string + " (" + clazz.getName() + ")";
    }

    public void raiseLater(final Object object) {
        this.raisingThread = Thread.currentThread();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Event.this.doRaise(object);
            }
        });
    }

    public void raise(Object object) {
        this.raisingThread = Thread.currentThread();
        this.doRaise(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRaise(Object object) {
        EventQueue.mustBeEventDispatchThread();
        int n = nestingDepth++;
        try {
            List<Handler> list;
            recentEvents.add(0, new Object[]{this, object, this.raisingThread, new Date()});
            if (recentEvents.size() > 10) {
                recentEvents.remove(recentEvents.size() - 1);
            }
            Class<?> clazz = this.getClass();
            String string = Event.eventName(this);
            if (logEvents && !string.equals("PeriodicUpdateEvent") && !string.equals("InterfaceGlobalEvent")) {
                for (int i = 0; i < n; ++i) {
                    System.out.print(' ');
                }
                System.out.println("raising " + string + ": " + Event.readableName(object));
            }
            if (object == null) {
                throw new IllegalStateException("event raised with null raiser");
            }
            Map<Class<?>, List<Handler>> map2 = handlers.get(object);
            if (null == map2) {
                map2 = new HashMap();
                handlers.put(object, map2);
            }
            if (null == (list = map2.get(clazz))) {
                list = this.findHandlers(this.findTop(object), clazz);
                map2.put(clazz, list);
            }
            for (Handler handler : list) {
                if (logEvents && !string.equals("PeriodicUpdateEvent") && !string.equals("InterfaceGlobalEvent")) {
                    for (int i = 0; i < nestingDepth; ++i) {
                        System.out.print(' ');
                    }
                    System.out.println("handling " + Event.eventName(this) + ": " + Event.readableName(handler));
                }
                this.beHandledBy(handler);
            }
            --nestingDepth;
        }
        finally {
            nestingDepth = n;
        }
    }

    private Component findTop(Object object) {
        while (object != null) {
            Component component = null;
            if (object instanceof LinkChild) {
                Object object2 = ((LinkChild)object).getLinkParent();
                while (object2 != null && !(object2 instanceof Component)) {
                    object2 = ((LinkChild)object2).getLinkParent();
                }
                component = (Component)object2;
            } else if (object instanceof Component && !(object instanceof Window)) {
                component = ((Component)object).getParent();
            }
            if (null == component) break;
            object = component;
        }
        return (Component)object;
    }

    private List<Handler> findHandlers(Object object, Class<? extends Event> clazz) {
        int n;
        Object[] objectArray;
        ArrayList<Handler> arrayList = new ArrayList<Handler>();
        if (object instanceof Container) {
            objectArray = ((Container)object).getComponents();
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.addAll(this.findHandlers(objectArray[n], clazz));
            }
        }
        if (object instanceof LinkParent) {
            objectArray = ((LinkParent)object).getLinkChildren();
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.addAll(this.findHandlers(objectArray[n], clazz));
            }
        }
        if (this.isHandler(object, clazz)) {
            arrayList.add((Handler)object);
        }
        return arrayList;
    }

    private boolean isHandler(Object object, Class<? extends Event> clazz) {
        if (!(object instanceof Handler)) {
            return false;
        }
        Handler handler = (Handler)object;
        Set<Class<? extends Event>> set = eventsHandledMap.get(object.getClass());
        if (set == null) {
            set = new HashSet<Class<? extends Event>>();
            eventsHandledMap.put(object.getClass(), set);
            for (Class<?> clazz2 = handler.getClass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                Class<?>[] classArray = Event.getAllInterfaces(clazz2);
                for (int i = 0; i < classArray.length; ++i) {
                    String string = classArray[i].getName();
                    if (!string.endsWith("$Handler")) continue;
                    set.add(this.eventClassForHandlerClassName(string.substring(0, string.length() - 8)));
                }
            }
        }
        return set.contains(clazz);
    }

    private Class<? extends Event> eventClassForHandlerClassName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Stack stack = new Stack();
        stack.addElement(clazz);
        while (!stack.empty()) {
            clazz = (Class)stack.pop();
            if (clazz.isInterface()) {
                arrayList.add(clazz);
            } else if (clazz.getSuperclass() != null) {
                stack.push(clazz.getSuperclass());
            }
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                stack.push(classArray[i]);
            }
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public static interface LinkParent {
        public Object[] getLinkChildren();
    }

    public static interface LinkChild {
        public Object getLinkParent();
    }

    public static interface Handler {
    }
}

