/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.BooleanConstraint;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Observer;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.CommandRunnable;
import org.nlogo.api.CompilerException;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.File;
import org.nlogo.api.I18N;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.ModelSectionJ;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.ReporterRunnable;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.awt.MovieEncoder;
import org.nlogo.awt.UserCancelException;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;
import org.nlogo.plot.Plot;
import org.nlogo.shape.InvalidShapeDescriptionException;
import org.nlogo.shape.LinkShape;
import org.nlogo.shape.VectorShape;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.swing.Utils;
import org.nlogo.util.Exceptions;
import org.nlogo.window.AppEventType;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.ExternalFileManager;
import org.nlogo.window.GLViewManagerInterface;
import org.nlogo.window.JOGLLoadingException;
import org.nlogo.window.JobWidget;
import org.nlogo.window.LocalViewInterface;
import org.nlogo.window.MonitorWidget;
import org.nlogo.window.NetLogoListenerManager;
import org.nlogo.window.PeriodicUpdater;
import org.nlogo.window.PlotWidgetExportType;
import org.nlogo.window.RuntimeErrorDialog;
import org.nlogo.window.ThreadUtils;
import org.nlogo.window.UpdateManagerInterface;
import org.nlogo.window.View;
import org.nlogo.window.ViewManager;
import org.nlogo.window.ViewWidget;
import org.nlogo.window.WidgetContainer;
import org.nlogo.workspace.AbstractWorkspace;
import org.nlogo.workspace.AbstractWorkspaceScala;
import scala.collection.JavaConversions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class GUIWorkspace
extends AbstractWorkspaceScala
implements DrawingInterface,
TrailDrawerInterface,
Event.LinkChild,
Events.AboutToQuitEvent.Handler,
Events.AddBooleanConstraintEvent.Handler,
Events.AddChooserConstraintEvent.Handler,
Events.AddInputBoxConstraintEvent.Handler,
Events.AddJobEvent.Handler,
Events.AddSliderConstraintEvent.Handler,
Events.AfterLoadEvent.Handler,
Events.BeforeLoadEvent.Handler,
Events.CompiledEvent.Handler,
Events.ExportPlotEvent.Handler,
Events.JobStoppingEvent.Handler,
Events.LoadSectionEvent.Handler,
Events.RemoveAllJobsEvent.Handler,
Events.RemoveConstraintEvent.Handler,
Events.RemoveJobEvent.Handler {
    public final KioskLevel kioskLevel;
    private final Frame frame;
    private final Component linkParent;
    public final ViewWidget viewWidget;
    public final View view;
    private WidgetContainer widgetContainer = null;
    public GLViewManagerInterface glView = null;
    public ViewManager viewManager = new ViewManager();
    private final ExternalFileManager externalFileManager;
    public MovieEncoder movieEncoder = null;
    public final NetLogoListenerManager listenerManager;
    private boolean snapOn = false;
    private double _frameRate = 30.0;
    private boolean dualView;
    private final Runnable updateRunner = new Runnable(){

        public void run() {
            new Events.PeriodicUpdateEvent().raise(GUIWorkspace.this);
        }
    };
    private boolean periodicUpdatesEnabled = false;
    private double lastTicksListenersHeard = -1.0;
    public final Action hubNetControlCenterAction = new AbstractAction(I18N.guiJ().get("menu.tools.hubNetControlCenter")){

        public void actionPerformed(ActionEvent actionEvent) {
            GUIWorkspace.this.hubNetManager.showControlCenter();
        }
    };
    public final Action switchTo3DViewAction = new AbstractAction("3D View"){

        public void actionPerformed(ActionEvent actionEvent) {
            GUIWorkspace.this.open3DView();
        }
    };

    public GUIWorkspace(final World world, KioskLevel kioskLevel, Frame frame, Component component, AbstractWorkspace.HubNetManagerFactory hubNetManagerFactory, ExternalFileManager externalFileManager, NetLogoListenerManager netLogoListenerManager) {
        super(world, hubNetManagerFactory);
        this.kioskLevel = kioskLevel;
        this.frame = frame;
        this.linkParent = component;
        this.externalFileManager = externalFileManager;
        this.listenerManager = netLogoListenerManager;
        this.hubNetControlCenterAction.setEnabled(false);
        this.viewWidget = new ViewWidget(this);
        this.view = this.viewWidget.view;
        this.viewManager.setPrimary(this.view);
        PeriodicUpdater periodicUpdater = new PeriodicUpdater(this.jobManager);
        periodicUpdater.start();
        world.trailDrawer(this);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (world.displayOn() && GUIWorkspace.this.displaySwitchOn() && !GUIWorkspace.this.jobManager.anyPrimaryJobs()) {
                    GUIWorkspace.this.viewManager.paintImmediately(world.observer().updatePosition());
                }
            }
        };
        new Timer(100, abstractAction).start();
        new Lifeguard().start();
    }

    public double frameRate() {
        return this._frameRate;
    }

    public void frameRate(double d) {
        this._frameRate = d;
        this.updateManager().recompute();
    }

    public abstract UpdateManagerInterface updateManager();

    public abstract RendererInterface newRenderer();

    @Override
    public void stamp(Agent agent, boolean bl) {
        this.view.renderer.prepareToPaint(this.view, this.view.renderer.trailDrawer().getWidth(), this.view.renderer.trailDrawer().getHeight());
        this.view.renderer.trailDrawer().stamp(agent, bl);
        if (this.hubNetManager != null) {
            this.hubNetManager.sendStamp(agent, bl);
        }
    }

    @Override
    public void importWorld(String string) throws IOException {
        super.importWorld(string);
        new Events.TickStateChangeEvent(true).raiseLater(this);
    }

    @Override
    public void importWorld(Reader reader) throws IOException {
        super.importWorld(reader);
        new Events.TickStateChangeEvent(true).raiseLater(this);
    }

    @Override
    public void importDrawing(InputStream inputStream) throws IOException {
        this.view.renderer.trailDrawer().importDrawing(inputStream);
    }

    @Override
    public void importDrawing(File file) throws IOException {
        this.view.renderer.trailDrawer().importDrawing(file);
    }

    @Override
    public void exportDrawing(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new java.io.File(string));
        ImageIO.write((RenderedImage)this.view.renderer.trailDrawer().getAndCreateDrawing(true), string2, fileOutputStream);
        fileOutputStream.close();
    }

    @Override
    public BufferedImage getAndCreateDrawing() {
        return this.getAndCreateDrawing(true);
    }

    @Override
    public BufferedImage getAndCreateDrawing(boolean bl) {
        return this.view.renderer.trailDrawer().getAndCreateDrawing(bl);
    }

    @Override
    public void clearDrawing() {
        this.world.clearDrawing();
        this.view.renderer.trailDrawer().clearDrawing();
        if (this.hubNetManager != null) {
            this.hubNetManager.sendClear();
        }
    }

    @Override
    public void resetTicks(Context context) {
        super.resetTicks(context);
        new Events.TickStateChangeEvent(true).raiseLater(this);
    }

    @Override
    public void clearTicks() {
        super.clearTicks();
        new Events.TickStateChangeEvent(false).raiseLater(this);
    }

    @Override
    public void clearAll() {
        super.clearAll();
        new Events.TickStateChangeEvent(false).raiseLater(this);
    }

    @Override
    public boolean sendPixels() {
        return this.view.renderer.trailDrawer().sendPixels();
    }

    @Override
    public void sendPixels(boolean bl) {
        this.view.renderer.trailDrawer().sendPixels(bl);
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public WidgetContainer getWidgetContainer() {
        return this.widgetContainer;
    }

    public void setWidgetContainer(WidgetContainer widgetContainer) {
        this.widgetContainer = widgetContainer;
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    public void waitFor(Runnable runnable) {
        ThreadUtils.waitFor(this, runnable);
    }

    @Override
    public void waitFor(CommandRunnable commandRunnable) throws LogoException {
        ThreadUtils.waitFor(this, commandRunnable);
    }

    @Override
    public <T> T waitForResult(ReporterRunnable<T> reporterRunnable) throws LogoException {
        return ThreadUtils.waitForResult(this, reporterRunnable);
    }

    @Override
    public void waitForQueuedEvents() throws LogoException {
        ThreadUtils.waitForQueuedEvents(this);
    }

    @Override
    public Object getLinkParent() {
        return this.linkParent;
    }

    @Override
    public boolean warningMessage(String string) {
        Object[] objectArray = new String[]{I18N.guiJ().get("common.buttons.continue"), I18N.guiJ().get("common.buttons.cancel")};
        return 0 == OptionDialog.show(this.getFrame(), I18N.guiJ().get("common.messages.warning"), "Warning: " + string, objectArray);
    }

    @Override
    public void resizeView() {
        org.nlogo.awt.EventQueue.mustBeEventDispatchThread();
        this.viewWidget.settings().resizeWithProgress(true);
    }

    @Override
    public void patchSize(double d) {
        this.viewWidget.settings().patchSize(d);
    }

    @Override
    public double patchSize() {
        return this.world.patchSize();
    }

    @Override
    public void setDimensions(final WorldDimensions worldDimensions) {
        Runnable runnable = new Runnable(){

            public void run() {
                GUIWorkspace.this.viewWidget.settings().setDimensions(worldDimensions);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                org.nlogo.awt.EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.handle(interruptedException);
            }
        }
    }

    @Override
    public void setDimensions(final WorldDimensions worldDimensions, final double d) {
        Runnable runnable = new Runnable(){

            public void run() {
                GUIWorkspace.this.viewWidget.settings().setDimensions(worldDimensions, d);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                org.nlogo.awt.EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.handle(interruptedException);
            }
        }
    }

    public void patchesCreatedNotify() {
        new Events.PatchesCreatedEvent().raise(this);
    }

    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public boolean compilerTestingMode() {
        return false;
    }

    @Override
    public WorldPropertiesInterface getPropertiesInterface() {
        return this.viewWidget.settings();
    }

    @Override
    public void changeTopology(boolean bl, boolean bl2) {
        this.world.changeTopology(bl, bl2);
        this.viewWidget.view.renderer.changeTopology(bl, bl2);
    }

    @Override
    public void open(final String string) {
        try {
            org.nlogo.awt.EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    new Events.OpenModelEvent(string).raise(GUIWorkspace.this);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    @Override
    public void openString(String string) {
        throw new UnsupportedOperationException();
    }

    public void reload() {
        new Events.AppEvent(AppEventType.RELOAD, new Object[0]).raiseLater(this);
    }

    @Override
    public void magicOpen(String string) {
        new Events.AppEvent(AppEventType.MAGIC_OPEN, new Object[]{string}).raiseLater(this);
    }

    @Override
    public void changeLanguage() {
        new Events.AppEvent(AppEventType.CHANGE_LANGUAGE, new Object[0]).raiseLater(this);
    }

    @Override
    public void startLogging(String string) {
        try {
            new Events.AppEvent(AppEventType.START_LOGGING, new Object[]{this.fileManager.attachPrefix(string)}).raiseLater(this);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
    }

    @Override
    public void zipLogFiles(String string) {
        try {
            new Events.AppEvent(AppEventType.ZIP_LOG_FILES, new Object[]{this.fileManager.attachPrefix(string)}).raiseLater(this);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
    }

    @Override
    public void deleteLogFiles() {
        new Events.AppEvent(AppEventType.DELETE_LOG_FILES, new Object[0]).raiseLater(this);
    }

    public boolean displaySwitchOn() {
        return this.viewManager.getPrimary().displaySwitch();
    }

    public void displaySwitchOn(boolean bl) {
        this.viewManager.getPrimary().displaySwitch(bl);
    }

    public void set2DViewEnabled(boolean bl) {
        if (bl) {
            this.displaySwitchOn(this.glView.displayOn());
            this.viewManager.setPrimary(this.view);
            this.viewManager.remove(this.glView);
            this.view.dirty();
            if (this.glView.displayOn()) {
                this.view.thaw();
            }
            if (this.world.observer().perspective() != PerspectiveJ.FOLLOW() && this.world.observer().perspective() != PerspectiveJ.RIDE()) {
                this.world.observer().home();
            }
            this.viewWidget.setVisible(true);
            try {
                this.viewWidget.displaySwitch.setOn(this.glView.displaySwitch());
            }
            catch (IllegalStateException illegalStateException) {
                Exceptions.ignore(illegalStateException);
            }
        } else {
            this.viewManager.setPrimary(this.glView);
            if (!this.dualView) {
                this.viewManager.remove(this.view);
                this.view.freeze();
            }
            this.glView.displaySwitch(this.viewWidget.displaySwitch.isSelected());
            this.viewWidget.setVisible(this.dualView);
        }
        this.view.renderPerspective = bl;
        this.viewWidget.settings().refreshViewProperties(!bl);
        new Events.Enable2DEvent(bl).raise(this);
    }

    public boolean mouseDown() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseDown();
    }

    public boolean mouseInside() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseInside();
    }

    public double mouseXCor() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseXCor();
    }

    public double mouseYCor() throws LogoException {
        this.waitForQueuedEvents();
        return this.viewManager.mouseYCor();
    }

    @Override
    public void updateMode(Workspace.UpdateMode updateMode) {
        super.updateMode(updateMode);
        this.updateManager().recompute();
    }

    public double speedSliderPosition() {
        double d = this.updateManager().speed() * 2.0;
        if (d > 0.0) {
            d += 10.0;
        } else if (d < 0.0) {
            d -= 10.0;
        }
        return d;
    }

    public void speedSliderPosition(double d) {
        this.updateManager().speed_$eq(d);
    }

    @Override
    public void updateDisplay(boolean bl) {
        this.view.dirty();
        if (!this.world.displayOn()) {
            return;
        }
        if (!this.updateManager().shouldUpdateNow()) {
            this.viewManager.framesSkipped();
            return;
        }
        if (!this.displaySwitchOn()) {
            return;
        }
        if (bl) {
            try {
                this.waitFor(new CommandRunnable(){

                    public void run() {
                        GUIWorkspace.this.viewManager.incrementalUpdateFromEventThread();
                    }
                });
                while (!this.updateManager().isDoneSmoothing()) {
                    ThreadUtils.waitForQueuedEvents(this);
                }
            }
            catch (HaltException haltException) {
                Exceptions.ignore(haltException);
            }
            catch (LogoException logoException) {
                throw new IllegalStateException(logoException);
            }
        } else {
            this.viewManager.incrementalUpdateFromJobThread();
        }
        this.updateManager().pause();
    }

    public void setPeriodicUpdatesEnabled(boolean bl) {
        this.periodicUpdatesEnabled = bl;
    }

    @Override
    public void periodicUpdate() {
        if (this.periodicUpdatesEnabled) {
            ThreadUtils.waitFor(this, this.updateRunner);
        }
    }

    @Override
    public void breathe() {
        this.jobManager.maybeRunSecondaryJobs();
        if (this.updateMode() == Workspace.UpdateMode.CONTINUOUS) {
            this.updateManager().pseudoTick();
            this.updateDisplay(true);
        }
        this.world.comeUpForAir = this.updateManager().shouldComeUpForAirAgain();
        this.notifyListeners();
    }

    public void updateUI() {
        ThreadUtils.waitFor(this, this.updateRunner);
        this.updateManager().reset();
        this.requestDisplayUpdate(true);
    }

    @Override
    public void requestDisplayUpdate(boolean bl) {
        if (bl) {
            this.updateManager().pseudoTick();
        }
        this.updateDisplay(true);
        this.notifyListeners();
    }

    private void notifyListeners() {
        double d = this.world.tickCounter.ticks();
        if (d != this.lastTicksListenersHeard) {
            this.lastTicksListenersHeard = d;
            this.listenerManager.tickCounterChanged(d);
        }
        this.listenerManager.possibleViewUpdate();
    }

    @Override
    public void halt() {
        this.jobManager.interrupt();
        ModalProgressTask.apply(this.getFrame(), "Halting...", new Runnable(){

            public void run() {
                GUIWorkspace.super.halt();
                GUIWorkspace.this.view.dirty();
                GUIWorkspace.this.view.repaint();
            }
        });
    }

    @Override
    public void handle(Events.AfterLoadEvent afterLoadEvent) {
        this.setPeriodicUpdatesEnabled(true);
        this.world.observer().resetPerspective();
        this.updateManager().reset();
        this.updateManager().speed_$eq(0.0);
        if (this.glView != null) {
            this.glView.close();
        }
        if (this.world.program().is3D()) {
            this.open3DView();
        }
        try {
            this.evaluateCommands(new SimpleJobOwner("startup", this.world.mainRNG, Observer.class), "without-interruption [ startup ]", false);
        }
        catch (CompilerException compilerException) {
            Exceptions.ignore(compilerException);
        }
    }

    private void open3DView() {
        try {
            this.glView.open();
            this.set2DViewEnabled(false);
        }
        catch (JOGLLoadingException jOGLLoadingException) {
            String string = jOGLLoadingException.getMessage();
            Utils.alert("3D View", string, "" + jOGLLoadingException.getCause(), I18N.guiJ().get("common.buttons.continue"));
            this.switchTo3DViewAction.setEnabled(false);
        }
    }

    public void addCustomShapes(String string) throws IOException, InvalidShapeDescriptionException {
        try {
            this.glView.addCustomShapes(this.fileManager.attachPrefix(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
    }

    @Override
    public int[] colors() {
        return this.view.renderer.trailDrawer().colors();
    }

    @Override
    public boolean isDirty() {
        return this.view.renderer.trailDrawer().isDirty();
    }

    @Override
    public boolean isBlank() {
        return this.view.renderer.trailDrawer().isBlank();
    }

    @Override
    public void markClean() {
        this.view.renderer.trailDrawer().markClean();
    }

    @Override
    public void markDirty() {
        this.view.renderer.trailDrawer().markDirty();
    }

    @Override
    public int getWidth() {
        return this.view.renderer.trailDrawer().getWidth();
    }

    @Override
    public int getHeight() {
        return this.view.renderer.trailDrawer().getHeight();
    }

    @Override
    public void readImage(InputStream inputStream) throws IOException {
        this.view.renderer.trailDrawer().readImage(inputStream);
    }

    @Override
    public void rescaleDrawing() {
        this.view.renderer.trailDrawer().rescaleDrawing();
    }

    @Override
    public void drawLine(double d, double d2, double d3, double d4, Object object, double d5, String string) {
        this.view.renderer.trailDrawer().drawLine(d, d2, d3, d4, object, d5, string);
        if (this.hubNetManager != null) {
            this.hubNetManager.sendLine(d, d2, d3, d4, object, d5, string);
        }
    }

    @Override
    public void setColors(int[] nArray) {
        this.view.renderer.trailDrawer().setColors(nArray);
    }

    @Override
    public Object getDrawing() {
        return this.view.renderer.trailDrawer().getDrawing();
    }

    @Override
    public void ownerFinished(JobOwner jobOwner) {
        new Events.JobRemovedEvent(jobOwner).raiseLater(this);
        if (jobOwner.ownsPrimaryJobs()) {
            this.updateManager().reset();
            this.updateDisplay(false);
        }
    }

    @Override
    public void handle(Events.AddJobEvent addJobEvent) {
        JobWidget jobWidget;
        JobOwner jobOwner = addJobEvent.owner;
        AgentSet agentSet = addJobEvent.agents;
        if (jobOwner instanceof JobWidget && agentSet == null && (jobWidget = (JobWidget)jobOwner).useAgentClass()) {
            agentSet = this.world.agentClassToAgentSet(jobWidget.agentClass());
        }
        if (jobOwner.ownsPrimaryJobs()) {
            if (addJobEvent.procedure != null) {
                this.jobManager.addJob(jobOwner, agentSet, addJobEvent.procedure);
            } else {
                new Events.JobRemovedEvent(jobOwner).raiseLater(this);
            }
        } else {
            this.jobManager.addSecondaryJob(jobOwner, agentSet, addJobEvent.procedure);
        }
    }

    @Override
    public void handle(Events.RemoveJobEvent removeJobEvent) {
        JobOwner jobOwner = removeJobEvent.owner;
        if (jobOwner.ownsPrimaryJobs()) {
            this.jobManager.finishJobs(jobOwner);
        } else {
            this.jobManager.finishSecondaryJobs(jobOwner);
        }
    }

    @Override
    public void handle(Events.JobStoppingEvent jobStoppingEvent) {
        this.jobManager.stoppingJobs(jobStoppingEvent.owner);
    }

    @Override
    public void handle(Events.RemoveAllJobsEvent removeAllJobsEvent) {
        this.jobManager.haltSecondary();
        this.jobManager.haltPrimary();
    }

    @Override
    public void handle(Events.AddBooleanConstraintEvent addBooleanConstraintEvent) {
        BooleanConstraint booleanConstraint = new BooleanConstraint(addBooleanConstraintEvent.defaultValue);
        int n = this.world.observerOwnsIndexOf(addBooleanConstraintEvent.varname.toUpperCase());
        if (n != -1) {
            this.world.observer().variableConstraint(n, booleanConstraint);
        }
    }

    @Override
    public void handle(Events.AddInputBoxConstraintEvent addInputBoxConstraintEvent) {
        int n = this.world.observerOwnsIndexOf(addInputBoxConstraintEvent.varname.toUpperCase());
        if (n != -1) {
            this.world.observer().variableConstraint(n, addInputBoxConstraintEvent.constraint);
        }
    }

    @Override
    public void handle(Events.AddChooserConstraintEvent addChooserConstraintEvent) {
        int n = this.world.observerOwnsIndexOf(addChooserConstraintEvent.varname.toUpperCase());
        if (n != -1) {
            this.world.observer().variableConstraint(n, addChooserConstraintEvent.constraint);
        }
    }

    @Override
    public void handle(Events.AddSliderConstraintEvent addSliderConstraintEvent) {
        block3: {
            try {
                SliderConstraint sliderConstraint = SliderConstraint.makeSliderConstraint(this.world.observer(), addSliderConstraintEvent.minSpec, addSliderConstraintEvent.maxSpec, addSliderConstraintEvent.incSpec, addSliderConstraintEvent.value, addSliderConstraintEvent.slider.name(), this);
                addSliderConstraintEvent.slider.removeAllErrors();
                addSliderConstraintEvent.slider.setSliderConstraint(sliderConstraint);
                int n = this.world.observerOwnsIndexOf(addSliderConstraintEvent.varname.toUpperCase());
                if (n == -1) break block3;
                this.world.observer().variableConstraint(n, sliderConstraint);
            }
            catch (SliderConstraint.ConstraintExceptionHolder constraintExceptionHolder) {
                for (SliderConstraint.SliderConstraintException sliderConstraintException : JavaConversions.asJavaIterable(constraintExceptionHolder.getErrors())) {
                    addSliderConstraintEvent.slider.setConstraintError(sliderConstraintException.spec().fieldName(), sliderConstraintException);
                }
            }
        }
    }

    @Override
    public void handle(Events.RemoveConstraintEvent removeConstraintEvent) {
        int n = this.world.observerOwnsIndexOf(removeConstraintEvent.varname.toUpperCase());
        if (n != -1) {
            this.world.observer().variableConstraint(n, null);
        }
    }

    @Override
    public void handle(Events.CompiledEvent compiledEvent) {
        this.codeBits.clear();
    }

    @Override
    public abstract void inspectAgent(Class<? extends org.nlogo.agent.Agent> var1, org.nlogo.agent.Agent var2, double var3);

    @Override
    public void clearOutput() {
        final Events.OutputEvent outputEvent = new Events.OutputEvent(true, null, false, false);
        if (!EventQueue.isDispatchThread()) {
            ThreadUtils.waitFor(this, new Runnable(){

                public void run() {
                    outputEvent.raise(GUIWorkspace.this);
                }
            });
        } else {
            outputEvent.raise(this);
        }
    }

    @Override
    protected void sendOutput(OutputObject outputObject, boolean bl) {
        final Events.OutputEvent outputEvent = new Events.OutputEvent(false, outputObject, false, !bl);
        if (!EventQueue.isDispatchThread()) {
            ThreadUtils.waitFor(this, new Runnable(){

                public void run() {
                    outputEvent.raise(GUIWorkspace.this);
                }
            });
        } else {
            outputEvent.raise(this);
        }
    }

    @Override
    protected Importer.ErrorHandler importerErrorHandler() {
        return new Importer.ErrorHandler(){

            public boolean showError(String string, String string2, boolean bl) {
                Object[] objectArray;
                org.nlogo.awt.EventQueue.mustBeEventDispatchThread();
                if (bl) {
                    Object[] objectArray2 = new String[1];
                    objectArray = objectArray2;
                    objectArray2[0] = I18N.guiJ().get("common.buttons.ok");
                } else {
                    String[] stringArray = new String[2];
                    stringArray[0] = I18N.guiJ().get("common.buttons.continue");
                    objectArray = stringArray;
                    stringArray[1] = I18N.guiJ().get("common.buttons.cancel");
                }
                Object[] objectArray3 = objectArray;
                return OptionDialog.show(GUIWorkspace.this.getFrame(), string, string2, objectArray3) == 0;
            }
        };
    }

    public Component getExportWindowFrame() {
        return this.viewManager.getPrimary().getExportWindowFrame();
    }

    @Override
    public BufferedImage exportView() {
        return this.viewManager.getPrimary().exportView();
    }

    @Override
    public void exportView(String string, String string2) throws IOException {
        this.exportView(this.viewManager.getPrimary(), string, string2);
    }

    public void exportView(LocalViewInterface localViewInterface, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new java.io.File(string));
        ImageIO.write((RenderedImage)localViewInterface.exportView(), string2, fileOutputStream);
        fileOutputStream.close();
    }

    public void doExportView(final LocalViewInterface localViewInterface) {
        try {
            final String string = FileDialog.show(this.getExportWindowFrame(), "Export View", 1, this.guessExportName("view.png"));
            final IOException[] iOExceptionArray = new IOException[]{null};
            ModalProgressTask.apply(this.getFrame(), "Exporting...", new Runnable(){

                public void run() {
                    try {
                        GUIWorkspace.this.exportView(localViewInterface, string, "png");
                    }
                    catch (IOException iOException) {
                        iOExceptionArray[0] = iOException;
                    }
                }
            });
            if (iOExceptionArray[0] != null) {
                throw iOExceptionArray[0];
            }
        }
        catch (UserCancelException userCancelException) {
            Exceptions.ignore(userCancelException);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getExportWindowFrame(), iOException.getMessage(), I18N.guiJ().get("common.messages.error"), 0);
        }
    }

    @Override
    public void exportInterface(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new java.io.File(string));
        IOException[] iOExceptionArray = new IOException[1];
        new Events.ExportInterfaceEvent(fileOutputStream, iOExceptionArray).raise(this);
        fileOutputStream.close();
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
    }

    @Override
    public void exportOutput(String string) {
        new Events.ExportOutputEvent(string).raise(this);
    }

    @Override
    public void exportDrawingToCSV(PrintWriter printWriter) {
        this.view.renderer.trailDrawer().exportDrawingToCSV(printWriter);
    }

    @Override
    public void exportOutputAreaToCSV(PrintWriter printWriter) {
        new Events.ExportWorldEvent(printWriter).raise(this);
    }

    @Override
    public void handle(Events.ExportPlotEvent exportPlotEvent) {
        if (exportPlotEvent.whichPlots == PlotWidgetExportType.ALL) {
            if (this.plotManager().getPlotNames().length == 0) {
                OptionDialog.show(this.getFrame(), "Export Plot", "There are no plots to export.", new String[]{I18N.guiJ().get("common.buttons.ok")});
                return;
            }
            try {
                super.exportAllPlots(exportPlotEvent.filename);
            }
            catch (IOException iOException) {
                String string = "Export of all plots to" + exportPlotEvent.filename + " failed: " + iOException.getMessage();
                Object[] objectArray = new String[]{I18N.guiJ().get("common.buttons.ok")};
                OptionDialog.show(this.getFrame(), "Export Plot Failed", string, objectArray);
            }
        } else {
            Plot plot2 = exportPlotEvent.plot;
            if (plot2 == null) {
                plot2 = this.choosePlot(this.getFrame());
            }
            if (plot2 != null) {
                try {
                    super.exportPlot(plot2.name(), exportPlotEvent.filename);
                }
                catch (IOException iOException) {
                    String string = "Export of " + plot2.name() + " plot to " + exportPlotEvent.filename + " failed: " + iOException.getMessage();
                    Object[] objectArray = new String[]{I18N.guiJ().get("common.buttons.ok")};
                    OptionDialog.show(this.getFrame(), "Export Plot Failed", string, objectArray);
                }
            }
        }
    }

    Plot choosePlot(Frame frame) {
        Object[] objectArray = this.plotManager().getPlotNames();
        if (objectArray.length == 0) {
            String string = "There are no plots to export.";
            Object[] objectArray2 = new String[]{I18N.guiJ().get("common.buttons.ok")};
            OptionDialog.show(frame, "Export Plot", string, objectArray2);
            return null;
        }
        String string = "Which plot would you like to export?";
        int n = OptionDialog.showAsList(frame, "Export Plot", string, objectArray);
        if (n < 0) {
            return null;
        }
        return this.plotManager().getPlot((String)objectArray[n]);
    }

    @Override
    public void runtimeError(final JobOwner jobOwner, final Context context, final Instruction instruction, final Exception exception) {
        final Thread thread = Thread.currentThread();
        org.nlogo.awt.EventQueue.invokeLater(new Runnable(){

            public void run() {
                GUIWorkspace.this.runtimeErrorPrivate(jobOwner, context, instruction, thread, exception);
            }
        });
    }

    private void runtimeErrorPrivate(JobOwner jobOwner, final Context context, final Instruction instruction, final Thread thread, final Exception exception) {
        if (exception instanceof HaltException && ((HaltException)exception).haltAll()) {
            this.halt();
        } else if (!(jobOwner instanceof MonitorWidget)) {
            this.world.displayOn(true);
        }
        if (!(exception instanceof HaltException)) {
            SourceOwner sourceOwner = context.activation.procedure.getOwner();
            int[] nArray = instruction.token() == null ? new int[]{-1, 0} : instruction.getPositionAndLength();
            new Events.RuntimeErrorEvent(jobOwner, sourceOwner, nArray[0], nArray[1]).raiseLater(this);
        }
        if (!(jobOwner instanceof MonitorWidget) && !(exception instanceof HaltException)) {
            org.nlogo.awt.EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RuntimeErrorDialog.show("Runtime Error", context, instruction, thread, exception);
                }
            });
        }
    }

    @Override
    public void handle(Events.BeforeLoadEvent beforeLoadEvent) {
        this.setPeriodicUpdatesEnabled(false);
        if (!GUIWorkspace.isApplet()) {
            this.setModelPath(beforeLoadEvent.modelPath);
            this.setModelType(beforeLoadEvent.modelType);
        }
        if (this.hubNetManager != null) {
            this.hubNetManager.disconnect();
        }
        this.jobManager.haltSecondary();
        this.jobManager.haltPrimary();
        this.getExtensionManager().reset();
        this.fileManager.handleModelChange();
        this.previewCommands_$eq(GUIWorkspace.DefaultPreviewCommands());
        this.clearDrawing();
        this.viewManager.resetMouseCors();
        this.displaySwitchOn(true);
        this.setProcedures(new HashMap<String, Procedure>());
        this.lastTicksListenersHeard = -1.0;
        this.plotManager().forgetAll();
    }

    @Override
    public void handle(Events.AboutToQuitEvent aboutToQuitEvent) {
        if (this.hubNetManager != null) {
            this.hubNetManager.disconnect();
        }
    }

    @Override
    public void hubNetRunning(boolean bl) {
        if (this.hubNetRunning != bl) {
            if (bl) {
                this.viewManager.add(this.hubNetManager);
            } else {
                this.viewManager.remove(this.hubNetManager);
            }
        }
        this.hubNetRunning = bl;
        this.hubNetControlCenterAction.setEnabled(bl);
    }

    @Override
    public void handle(Events.LoadSectionEvent loadSectionEvent) {
        if (loadSectionEvent.section == ModelSectionJ.PREVIEW_COMMANDS() && loadSectionEvent.text.trim().length() > 0) {
            this.previewCommands_$eq(loadSectionEvent.text);
        }
        if (loadSectionEvent.section == ModelSectionJ.CLIENT() && loadSectionEvent.lines.length > 0 && !GUIWorkspace.isApplet()) {
            this.getHubNetManager().load(loadSectionEvent.lines, loadSectionEvent.version);
        }
        if (loadSectionEvent.section == ModelSectionJ.SHAPES()) {
            this.world.turtleShapeList().replaceShapes(VectorShape.parseShapes(loadSectionEvent.lines, loadSectionEvent.version));
        }
        if (loadSectionEvent.section == ModelSectionJ.LINK_SHAPES()) {
            this.world.linkShapeList().replaceShapes(LinkShape.parseShapes(loadSectionEvent.lines, loadSectionEvent.version));
        }
    }

    @Override
    public String getSource(String string) throws IOException {
        String string2 = null;
        if (this.externalFileManager != null) {
            string2 = this.externalFileManager.getSource(string);
        }
        if (string2 == null) {
            string2 = super.getSource(string);
        }
        return string2;
    }

    private strictfp class Lifeguard
    extends Thread {
        Lifeguard() {
            super("Lifeguard");
        }

        public void run() {
            try {
                while (true) {
                    if (GUIWorkspace.this.jobManager.anyPrimaryJobs()) {
                        GUIWorkspace.this.world.comeUpForAir = true;
                    }
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                Exceptions.ignore(interruptedException);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum KioskLevel {
        NONE,
        MODERATE;

    }
}

