/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import org.nlogo.agent.Observer;
import org.nlogo.api.Dump;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.ModelReader;
import org.nlogo.api.Property;
import org.nlogo.awt.Fonts;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.MersenneTwisterFast;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.JobWidget;
import org.nlogo.window.Properties;
import org.nlogo.window.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class MonitorWidget
extends JobWidget
implements MouseListener,
Editable,
Events.JobRemovedEvent.Handler,
Events.PeriodicUpdateEvent.Handler,
Events.RuntimeErrorEvent.Handler {
    private boolean jobRunning = false;
    private boolean hasError = false;
    private String name = "";
    private int fontSize = 11;
    private Object value = null;
    private String valueString = "";
    private int decimalPlaces = 17;
    private boolean lastMousePressedWasPopupTrigger = false;

    public MonitorWidget(MersenneTwisterFast mersenneTwisterFast) {
        super(mersenneTwisterFast);
        this.setOpaque(true);
        this.addMouseListener(this);
        this.setBackground(InterfaceColors.MONITOR_BACKGROUND);
        this.setBorder(this.widgetBorder());
        Fonts.adjustDefaultFont(this);
        this.fontSize = this.getFont().getSize();
    }

    public void name(String string) {
        this.name = string;
        this.chooseDisplayName();
    }

    public String name() {
        return this.name;
    }

    public void fontSize(int n) {
        this.fontSize = n;
        if (this.originalFont() != null) {
            int n2 = this.getFont().getSize() - this.originalFont().getSize();
            this.setFont(this.getFont().deriveFont(Float.valueOf(n + n2).floatValue()));
        } else {
            this.setFont(this.getFont().deriveFont(Float.valueOf(n).floatValue()));
        }
        if (this.originalFont() != null) {
            this.originalFont_$eq(this.originalFont().deriveFont(Float.valueOf(n).floatValue()));
        }
        this.resetZoomInfo();
        this.resetSizeInfo();
    }

    @Override
    public void setFont(Font font) {
        if (this.isZoomed() || this.getFont() == null) {
            super.setFont(font);
        } else {
            super.setFont(this.getFont().deriveFont(Float.valueOf(this.fontSize).floatValue()));
        }
    }

    @Override
    public String classDisplayName() {
        return I18N.guiJ().get("tabs.run.widgets.monitor");
    }

    public Class<Observer> agentClass() {
        return Observer.class;
    }

    @Override
    public boolean ownsPrimaryJobs() {
        return false;
    }

    @Override
    public void procedure(Procedure procedure) {
        super.procedure(procedure);
        this.setForeground(procedure == null ? Color.RED : null);
        this.halt();
        if (procedure != null) {
            this.hasError = false;
            new Events.AddJobEvent(this, this.agents(), this.procedure()).raise(this);
            this.jobRunning = true;
        }
        this.repaint();
    }

    public void value(Object object) {
        this.value = object;
        String string = Dump.logoObject(object);
        if (!string.equals(this.valueString)) {
            this.valueString = string;
            this.repaint();
        }
    }

    @Override
    public List<Property> propertySet() {
        return Properties.monitor();
    }

    private void chooseDisplayName() {
        if (this.name() == null || this.name().equals("")) {
            this.displayName(this.getSourceName());
        } else {
            this.displayName(this.name());
        }
    }

    private String getSourceName() {
        return this.innerSource.trim().replaceAll("\\s+", " ");
    }

    @Override
    public void removeNotify() {
        if (EventQueue.isDispatchThread()) {
            this.halt();
        }
        super.removeNotify();
    }

    @Override
    public Dimension getMinimumSize() {
        int n = this.fontSize * 4 + 1;
        return new Dimension(50, n);
    }

    @Override
    public Dimension getMaximumSize() {
        int n = this.fontSize * 4 + 1;
        return new Dimension(10000, n);
    }

    @Override
    public Dimension getPreferredSize(Font font) {
        Dimension dimension = this.getMinimumSize();
        int n = 12;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        dimension.width = StrictMath.max(dimension.width, fontMetrics.stringWidth(this.displayName()) + n);
        return dimension;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        Dimension dimension = this.getSize();
        graphics.setColor(this.getForeground());
        String string = this.displayName();
        int n2 = (int)StrictMath.ceil((double)n * 1.4);
        graphics.drawString(string, 5, dimension.height - 6 - n2 - fontMetrics.getMaxDescent() - 1);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(5, dimension.height - 6 - n2, dimension.width - 5 - 6 - 1, n2);
        graphics.setColor(Color.BLACK);
        if (!this.valueString.equals("")) {
            graphics.drawString(this.valueString, 10, dimension.height - 6 - 3 - fontMetrics.getMaxDescent());
        }
    }

    public int decimalPlaces() {
        return this.decimalPlaces;
    }

    @Override
    public void innerSource(String string) {
        super.innerSource(string);
        this.chooseDisplayName();
    }

    public void wrapSource(String string) {
        if (string.trim().equals("")) {
            this.source(null, "", null);
            this.halt();
        } else {
            this.source("to __monitor [] __observercode loop [ __updatemonitor __monitorprecision (", string, "\n) " + this.decimalPlaces() + " ] end");
        }
        this.chooseDisplayName();
    }

    @Override
    public void handle(Events.RuntimeErrorEvent runtimeErrorEvent) {
        if (this == runtimeErrorEvent.jobOwner) {
            this.hasError = true;
            this.halt();
        }
    }

    @Override
    public void handle(Events.PeriodicUpdateEvent periodicUpdateEvent) {
        if (!this.jobRunning && this.procedure() != null) {
            this.hasError = false;
            this.jobRunning = true;
            new Events.AddJobEvent(this, this.agents(), this.procedure()).raise(this);
        }
    }

    @Override
    public void handle(Events.JobRemovedEvent jobRemovedEvent) {
        if (jobRemovedEvent.owner == this) {
            this.jobRunning = false;
            this.value(this.hasError ? "N/A" : "");
        }
    }

    private void halt() {
        new Events.RemoveJobEvent(this).raise(this);
    }

    @Override
    public String save() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MONITOR\n");
        stringBuilder.append(this.getBoundsString());
        if (null != this.name() && !this.name().trim().equals("")) {
            stringBuilder.append(this.name() + "\n");
        } else {
            stringBuilder.append("NIL\n");
        }
        if (!this.innerSource.trim().equals("")) {
            stringBuilder.append(ModelReader.stripLines(this.innerSource()) + "\n");
        } else {
            stringBuilder.append("NIL\n");
        }
        stringBuilder.append(this.decimalPlaces + "\n");
        stringBuilder.append("1\n");
        stringBuilder.append(this.fontSize + "\n");
        return stringBuilder.toString();
    }

    @Override
    public Object load(String[] stringArray, Widget.LoadHelper loadHelper2) {
        String string = stringArray[5];
        String string2 = ModelReader.restoreLines(stringArray[6]);
        if (string.equals("NIL")) {
            this.name("");
        } else {
            this.name(string);
        }
        if (stringArray.length > 7) {
            this.decimalPlaces = Integer.parseInt(stringArray[7]);
        }
        if (stringArray.length > 9) {
            this.fontSize(Integer.parseInt(stringArray[9]));
        }
        if (!string2.equals("NIL")) {
            this.wrapSource(loadHelper2.convert(string2, true));
        }
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        int n3 = Integer.parseInt(stringArray[3]);
        int n4 = Integer.parseInt(stringArray[4]);
        this.setSize(n3 - n, n4 - n2);
        this.chooseDisplayName();
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && this.error() != null && !this.lastMousePressedWasPopupTrigger) {
            new Events.EditWidgetEvent(this).raise(this);
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.lastMousePressedWasPopupTrigger = mouseEvent.isPopupTrigger();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

