/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.agent.Link;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.JobOwner;
import org.nlogo.api.NetLogoListener;
import org.nlogo.window.ButtonWidget;
import org.nlogo.window.ChooserWidget;
import org.nlogo.window.Events;
import org.nlogo.window.InputBoxWidget;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.SliderWidget;

public strictfp class NetLogoListenerManager
implements Events.AddJobEvent.Handler,
Events.BeforeLoadEvent.Handler,
Events.CompiledEvent.Handler,
Events.InterfaceGlobalEvent.Handler,
Events.JobRemovedEvent.Handler {
    private final List<NetLogoListener> listeners = new ArrayList<NetLogoListener>();

    public void handle(Events.BeforeLoadEvent beforeLoadEvent) {
        for (NetLogoListener netLogoListener : this.listeners) {
            netLogoListener.modelOpened(beforeLoadEvent.modelPath);
        }
    }

    public void handle(Events.AddJobEvent addJobEvent) {
        if (addJobEvent.owner instanceof ButtonWidget) {
            for (NetLogoListener netLogoListener : this.listeners) {
                netLogoListener.buttonPressed(((ButtonWidget)addJobEvent.owner).displayName());
            }
        }
    }

    public void handle(Events.InterfaceGlobalEvent interfaceGlobalEvent) {
        if (!interfaceGlobalEvent.updating) {
            for (NetLogoListener netLogoListener : this.listeners) {
                if (interfaceGlobalEvent.widget instanceof SliderWidget) {
                    SliderWidget sliderWidget = (SliderWidget)interfaceGlobalEvent.widget;
                    netLogoListener.sliderChanged(interfaceGlobalEvent.widget.name(), sliderWidget.value(), sliderWidget.minimum(), sliderWidget.increment(), sliderWidget.maximum(), interfaceGlobalEvent.valueChanged, interfaceGlobalEvent.buttonReleased);
                    continue;
                }
                if (interfaceGlobalEvent.widget.classDisplayName().equals("Switch")) {
                    netLogoListener.switchChanged(interfaceGlobalEvent.widget.name(), (Boolean)interfaceGlobalEvent.widget.valueObject(), interfaceGlobalEvent.valueChanged);
                    continue;
                }
                if (interfaceGlobalEvent.widget instanceof ChooserWidget) {
                    netLogoListener.chooserChanged(interfaceGlobalEvent.widget.name(), interfaceGlobalEvent.widget.valueObject(), interfaceGlobalEvent.valueChanged);
                    continue;
                }
                if (interfaceGlobalEvent.widget instanceof InputBoxWidget) {
                    netLogoListener.inputBoxChanged(interfaceGlobalEvent.widget.name(), interfaceGlobalEvent.widget.valueObject(), interfaceGlobalEvent.valueChanged);
                    continue;
                }
                throw new IllegalStateException("unknown widget type: " + interfaceGlobalEvent.widget);
            }
        }
    }

    public void handle(Events.JobRemovedEvent jobRemovedEvent) {
        if (jobRemovedEvent.owner instanceof ButtonWidget) {
            for (NetLogoListener netLogoListener : this.listeners) {
                netLogoListener.buttonStopped(((ButtonWidget)jobRemovedEvent.owner).displayName());
            }
        }
    }

    public void handle(Events.CompiledEvent compiledEvent) {
        block10: {
            block9: {
                if (!(compiledEvent.sourceOwner instanceof JobOwner)) break block9;
                char c = 'O';
                if (compiledEvent.sourceOwner.agentClass() == Turtle.class) {
                    c = 'T';
                } else if (compiledEvent.sourceOwner.agentClass() == Patch.class) {
                    c = 'P';
                } else if (compiledEvent.sourceOwner.agentClass() == Link.class) {
                    c = 'L';
                } else if (compiledEvent.sourceOwner.agentClass() != Observer.class) {
                    throw new IllegalStateException("unexpected agent class: " + compiledEvent.sourceOwner.agentClass());
                }
                for (NetLogoListener netLogoListener : this.listeners) {
                    if (!((JobOwner)compiledEvent.sourceOwner).isCommandCenter()) continue;
                    netLogoListener.commandEntered(compiledEvent.sourceOwner.classDisplayName(), compiledEvent.sourceOwner.innerSource(), c, compiledEvent.error);
                }
                break block10;
            }
            if (!(compiledEvent.sourceOwner instanceof ProceduresInterface)) break block10;
            for (NetLogoListener netLogoListener : this.listeners) {
                netLogoListener.codeTabCompiled(compiledEvent.sourceOwner.innerSource(), compiledEvent.error);
            }
        }
    }

    public void tickCounterChanged(double d) {
        for (NetLogoListener netLogoListener : this.listeners) {
            netLogoListener.tickCounterChanged(d);
        }
    }

    public void possibleViewUpdate() {
        for (NetLogoListener netLogoListener : this.listeners) {
            netLogoListener.possibleViewUpdate();
        }
    }

    public void addListener(NetLogoListener netLogoListener) {
        this.listeners.add(netLogoListener);
    }

    public void removeListener(NetLogoListener netLogoListener) {
        this.listeners.remove(netLogoListener);
    }

    public void clearListeners(NetLogoListener netLogoListener) {
        this.listeners.clear();
    }
}

