/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.nlogo.agent.OutputObject;
import org.nlogo.api.File;
import org.nlogo.api.FileModeJ;
import org.nlogo.api.LocalFile;
import org.nlogo.awt.EventQueue;
import org.nlogo.awt.Fonts;
import org.nlogo.awt.LineBreaker;
import org.nlogo.util.Exceptions;

public strictfp class OutputArea
extends JPanel {
    private boolean addCarriageReturn = false;
    private String lastTemporaryAddition;
    String help = null;
    public final JTextArea text;
    private final JScrollPane scrollPane;

    public OutputArea() {
        this(new JTextArea(){

            public Dimension getMinimumSize() {
                return new Dimension(50, (int)((double)this.getRowHeight() * 1.25));
            }
        });
    }

    public OutputArea(JTextArea jTextArea) {
        this.text = jTextArea;
        this.text.setEditable(false);
        this.text.setDragEnabled(false);
        this.text.setFont(new Font(Fonts.platformMonospacedFont(), 0, 12));
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.text, 22, 30);
        this.add((Component)this.scrollPane, "Center");
    }

    public int fontSize() {
        return this.text.getFont().getSize();
    }

    public void fontSize(int n) {
        this.text.setFont(new Font(Fonts.platformMonospacedFont(), 0, n));
    }

    public void clear() {
        this.text.setText("");
        this.addCarriageReturn = false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, this.text.getMinimumSize().height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 45);
    }

    public boolean isFocusable() {
        return false;
    }

    public void append(OutputObject outputObject, boolean bl) {
        Object object;
        String string = outputObject.get();
        if (this.lastTemporaryAddition != null) {
            object = this.text.getText();
            if (((String)object).length() >= this.lastTemporaryAddition.length() && ((String)object).substring(((String)object).length() - this.lastTemporaryAddition.length()).equals(this.lastTemporaryAddition)) {
                this.text.replaceRange("", ((String)object).length() - this.lastTemporaryAddition.length(), ((String)object).length());
            }
            this.lastTemporaryAddition = null;
        }
        if (bl) {
            object = this.getFontMetrics(this.text.getFont());
            List<String> list = LineBreaker.breakLines(string, (FontMetrics)object, this.text.getWidth() - 24);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                stringBuilder.append(list.get(i));
                stringBuilder.append("\n");
            }
            string = stringBuilder.toString();
        }
        object = new StringBuilder();
        if (this.addCarriageReturn) {
            ((StringBuilder)object).append('\n');
            this.addCarriageReturn = false;
        }
        ((StringBuilder)object).append(string);
        if (((StringBuilder)object).length() > 0 && ((StringBuilder)object).charAt(((StringBuilder)object).length() - 1) == '\n') {
            ((StringBuilder)object).setLength(((StringBuilder)object).length() - 1);
            this.addCarriageReturn = true;
        }
        this.text.append(((StringBuilder)object).toString());
        this.lastTemporaryAddition = null;
        if (outputObject.isTemporary()) {
            this.text.select(this.text.getText().length() - ((StringBuilder)object).length(), this.text.getText().length());
            this.lastTemporaryAddition = this.text.getSelectedText();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                OutputArea.this.scrollPane.getVerticalScrollBar().setValue(OutputArea.this.scrollPane.getVerticalScrollBar().getMaximum());
                OutputArea.this.scrollPane.getHorizontalScrollBar().setValue(0);
            }
        });
    }

    public void export(String string) {
        LocalFile localFile = new LocalFile(string);
        try {
            ((File)localFile).open(FileModeJ.WRITE());
            StringTokenizer stringTokenizer = new StringTokenizer(this.text.getText(), "\n");
            while (stringTokenizer.hasMoreTokens()) {
                ((File)localFile).println(stringTokenizer.nextToken());
            }
            ((File)localFile).close(true);
        }
        catch (IOException iOException) {
            try {
                ((File)localFile).close(false);
            }
            catch (IOException iOException2) {
                Exceptions.ignore(iOException2);
            }
        }
    }
}

