/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.nlogo.api.LogoException;
import org.nlogo.api.Version;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Instruction;
import org.nlogo.swing.MessageDialog;
import org.nlogo.util.SysInfo;
import org.nlogo.util.Utils;
import org.nlogo.window.Event;
import org.nlogo.workspace.AbstractWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class RuntimeErrorDialog
extends MessageDialog {
    private String title;
    private boolean ordinaryError;
    private boolean askForBugReport;
    private String errorMessage;
    private String javaStackTrace;
    private String eventTrace;
    private final String className;
    private String threadName;
    private String textWithoutDetails;
    private String textWithDetails;
    private boolean suppressJavaExceptionDialogs = false;
    private String modelName;
    private static final JButton SUPPRESS_BUTTON = new JButton("Don't show again");
    private static final JCheckBox CHECKBOX = new JCheckBox("Show internal details");

    public static MessageDialog init(Component component) {
        dialog = new RuntimeErrorDialog(component);
        return dialog;
    }

    public static void deactivate() {
        dialog = null;
    }

    public static void show(String string, Context context, Instruction instruction, Thread thread, Throwable throwable) {
        if (dialog != null) {
            ((RuntimeErrorDialog)dialog).doShow(string, context, instruction, thread, throwable);
        }
    }

    public static void setModelName(String string) {
        ((RuntimeErrorDialog)RuntimeErrorDialog.dialog).modelName = string;
    }

    private void doShow(String string, Context context, Instruction instruction, Thread thread, Throwable throwable) {
        this.title = string;
        this.threadName = thread.getName();
        this.ordinaryError = throwable instanceof LogoException;
        this.askForBugReport = !this.ordinaryError && !this.hasKnownAncestorCause(throwable);
        SUPPRESS_BUTTON.setVisible(!this.ordinaryError && context == null);
        this.javaStackTrace = Utils.getStackTrace(throwable);
        this.eventTrace = Event.recentEventTrace();
        this.errorMessage = context != null ? context.buildRuntimeErrorMessage(instruction, throwable) : (this.ordinaryError ? throwable.getMessage() : null);
        this.buildTexts();
        if (this.textWithDetails.indexOf("sun.font.FontDesignMetrics.charsWidth") == -1) {
            this.showJavaDetails(CHECKBOX.isSelected());
        }
    }

    private boolean hasKnownAncestorCause(Throwable throwable) {
        return throwable instanceof OutOfMemoryError || throwable.getCause() != null && this.hasKnownAncestorCause(throwable.getCause());
    }

    protected RuntimeErrorDialog(Component component) {
        super(component);
        this.className = component.getClass().getName();
    }

    @Override
    protected List<JComponent> makeButtons() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.addAll(super.makeButtons());
        if (!AbstractWorkspace.isApplet()) {
            JButton jButton = new JButton("Copy");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RuntimeErrorDialog.this.textArea.selectAll();
                    RuntimeErrorDialog.this.textArea.copy();
                    RuntimeErrorDialog.this.textArea.setCaretPosition(0);
                }
            });
            arrayList.add(jButton);
        }
        CHECKBOX.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RuntimeErrorDialog.this.showJavaDetails(CHECKBOX.isSelected());
            }
        });
        arrayList.add(CHECKBOX);
        SUPPRESS_BUTTON.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RuntimeErrorDialog.this.suppressJavaExceptionDialogs = true;
                RuntimeErrorDialog.this.setVisible(false);
            }
        });
        arrayList.add(SUPPRESS_BUTTON);
        return arrayList;
    }

    private void buildTexts() {
        String string = "";
        if (this.askForBugReport) {
            string = "NetLogo is unable to supply you with more details about this error.  Please report the problem\nat https://github.com/NetLogo/NetLogo/issues, or to bugs@ccl.northwestern.edu, and paste the\ncontents of this window into your report.\n\n";
        }
        this.textWithoutDetails = "";
        if (this.errorMessage != null) {
            this.textWithoutDetails = this.errorMessage;
        }
        this.textWithDetails = this.textWithoutDetails;
        if (!this.textWithDetails.equals("")) {
            this.textWithDetails = this.textWithDetails + "\n\n";
        }
        this.textWithDetails = this.textWithDetails + string + this.javaStackTrace + "\n" + Version.version() + "\n" + "main: " + this.className + "\n" + "thread: " + this.threadName + "\n" + SysInfo.getVMInfoString() + "\n" + SysInfo.getOSInfoString() + "\n" + SysInfo.getScalaVersionString() + "\n" + SysInfo.getJOGLInfoString() + "\n" + SysInfo.getGLInfoString() + "\n" + "model: " + this.modelName + "\n\n" + this.eventTrace;
        if (!AbstractWorkspace.isApp()) {
            String string2 = SysInfo.getBrowserInfoString();
            this.textWithDetails = this.textWithDetails + "\n";
            this.textWithDetails = this.textWithDetails + (string2 == null ? "running as applet in unknown browser" : "browser info: " + string2);
        }
    }

    private void showJavaDetails(boolean bl) {
        if (this.ordinaryError) {
            CHECKBOX.setVisible(true);
        } else {
            CHECKBOX.setVisible(false);
            bl = true;
        }
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        String string = bl ? this.textWithDetails : this.textWithoutDetails;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\n' && c != '\r') continue;
            ++n;
            if (i - n2 > n3) {
                n3 = i - n2;
            }
            n2 = i;
        }
        n3 += 2;
        if (n < 5) {
            n = 5;
        }
        if (n > 15) {
            n = 15;
        }
        if (n3 > 70) {
            n3 = 70;
        }
        ((RuntimeErrorDialog)dialog).doShow(this.title, string, n, n3);
    }
}

