/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import org.nlogo.api.AgentException;
import org.nlogo.api.Approximate;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.awt.Mouse;
import org.nlogo.util.Exceptions;

public strictfp class ViewMouseHandler
implements MouseListener,
MouseMotionListener {
    private final World world;
    private final ViewSettings settings;
    private final JComponent parent;
    boolean mouseDown = false;
    protected double mouseXCor = 0.0;
    protected double mouseYCor = 0.0;
    private boolean mouseInside = false;
    private Point pt = null;

    public ViewMouseHandler(JComponent jComponent, World world, ViewSettings viewSettings) {
        this.world = world;
        this.settings = viewSettings;
        this.parent = jComponent;
    }

    public void mouseDown(boolean bl) {
        this.mouseDown = bl;
    }

    public boolean mouseDown() {
        return this.mouseDown;
    }

    public double mouseXCor() {
        return this.mouseXCor;
    }

    public void mouseXCor(double d) {
        this.mouseXCor = d;
    }

    public double mouseYCor() {
        return this.mouseYCor;
    }

    public void mouseYCor(double d) {
        this.mouseYCor = d;
    }

    public boolean mouseInside() {
        return this.mouseInside;
    }

    public void resetMouseCors() {
        this.mouseXCor = 0.0;
        this.mouseYCor = 0.0;
    }

    public void updateMouseCors() {
        if (this.mouseInside() && this.pt != null) {
            this.translatePointToXCorYCor(this.pt);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && Mouse.hasButton1(mouseEvent)) {
            this.mouseDown(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() && Mouse.hasButton1(mouseEvent)) {
            this.mouseDown(false);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseInside = this.parent.contains(mouseEvent.getPoint());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDown(true);
        if (this.parent.contains(mouseEvent.getPoint())) {
            this.updateMouseInside(mouseEvent.getPoint());
            this.translatePointToXCorYCor(mouseEvent.getPoint());
            this.pt = mouseEvent.getPoint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateMouseInside(mouseEvent.getPoint());
        this.translatePointToXCorYCor(mouseEvent.getPoint());
        this.pt = mouseEvent.getPoint();
    }

    private void updateMouseInside(Point point) {
        double d = this.translatePointToUnboundedX(point.x);
        double d2 = this.translatePointToUnboundedY(point.y);
        try {
            this.mouseInside = this.world.wrapX(d) == d && this.world.wrapY(d2) == d2;
        }
        catch (AgentException agentException) {
            this.mouseInside = false;
        }
    }

    double translatePointToUnboundedX(int n) {
        Rectangle rectangle = this.parent.getBounds();
        double d = this.settings.viewOffsetX();
        double d2 = (double)n / (double)rectangle.width;
        double d3 = d2 * this.settings.viewWidth() + ((double)this.world.minPxcor() - 0.5);
        d3 += d;
        try {
            d3 = this.world.wrapX(d3);
        }
        catch (AgentException agentException) {
            Exceptions.ignore(agentException);
        }
        if (this.settings.patchSize() <= 1.0) {
            d3 = Approximate.approximate(d3, 0);
        }
        return d3;
    }

    double translatePointToUnboundedY(int n) {
        Rectangle rectangle = this.parent.getBounds();
        double d = this.settings.viewOffsetY();
        double d2 = (double)n / (double)rectangle.height;
        double d3 = (double)this.world.maxPycor() + 0.4999999 - this.settings.viewHeight() * d2;
        d3 += d;
        try {
            d3 = this.world.wrapY(d3);
        }
        catch (AgentException agentException) {
            Exceptions.ignore(agentException);
        }
        if (this.settings.patchSize() <= 1.0) {
            d3 = Approximate.approximate(d3, 0);
        }
        return d3;
    }

    void translatePointToXCorYCor(Point point) {
        Rectangle rectangle = this.parent.getBounds();
        int n = this.world.minPxcor();
        int n2 = this.world.maxPxcor();
        int n3 = this.world.minPycor();
        int n4 = this.world.maxPycor();
        double d = this.settings.viewOffsetX();
        double d2 = this.settings.viewOffsetY();
        double d3 = (double)point.x / (double)rectangle.width;
        double d4 = d3 * this.settings.viewWidth() + ((double)n - 0.5);
        d4 += d;
        try {
            d4 = this.world.wrapX(d4);
        }
        catch (AgentException agentException) {
            return;
        }
        if (d4 < (double)n - 0.5) {
            d4 = (double)n - 0.5;
        } else if (d4 >= (double)n2 + 0.5) {
            d4 = (double)n2 + 0.4999999;
        }
        if (this.settings.patchSize() <= 1.0) {
            d4 = Approximate.approximate(d4, 0);
        }
        double d5 = (double)point.y / (double)rectangle.height;
        double d6 = (double)n4 + 0.4999999 - this.settings.viewHeight() * d5;
        d6 += d2;
        try {
            d6 = this.world.wrapY(d6);
        }
        catch (AgentException agentException) {
            return;
        }
        if (d6 < (double)n3 - 0.5) {
            d6 = (double)n3 - 0.5;
        } else if (d6 >= (double)n4 + 0.5) {
            d6 = (double)n4 + 0.4999999;
        }
        if (this.settings.patchSize() <= 1.0) {
            d6 = Approximate.approximate(d6, 0);
        }
        this.mouseXCor(d4);
        this.mouseYCor(d6);
    }
}

