/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Editable;
import org.nlogo.api.I18N;
import org.nlogo.api.Property;
import org.nlogo.api.WorldDimensions;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.nvm.Workspace;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.OriginConfiguration;
import org.nlogo.window.Properties;
import org.nlogo.window.ViewWidget;
import org.nlogo.workspace.WorldLoaderInterface;
import scala.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class WorldViewSettings
implements Editable,
WorldPropertiesInterface,
WorldLoaderInterface {
    protected final GUIWorkspace workspace;
    protected final ViewWidget gWidget;
    protected List<Property> dimensionProperties;
    protected List<Property> wrappingProperties;
    protected List<Property> viewProperties;
    protected List<Property> modelProperties;
    protected List<OriginConfiguration> cornerChoices;
    protected List<OriginConfiguration> edgeChoices;
    protected List<OriginConfiguration> originConfigurations;
    protected List<Property> propertySet = null;
    protected boolean wrappingChanged = false;
    protected boolean edgesChanged = false;
    protected boolean patchSizeChanged = false;
    protected boolean fontSizeChanged = false;
    protected double newPatchSize;
    protected int newMinX;
    protected int newMaxX;
    protected int newMinY;
    protected int newMaxY;
    protected boolean newWrapX;
    protected boolean newWrapY;
    protected int newFontSize;
    protected CompilerException error = null;

    @Override
    public String classDisplayName() {
        return "Model Settings";
    }

    WorldViewSettings(GUIWorkspace gUIWorkspace, ViewWidget viewWidget) {
        this.workspace = gUIWorkspace;
        this.gWidget = viewWidget;
        this.addProperties();
    }

    public abstract void resizeWithProgress(boolean var1);

    public abstract String save();

    public abstract void addWrappingProperties();

    public abstract void addDimensionProperties();

    protected void addProperties() {
        this.propertySet(new ArrayList<Property>());
        this.dimensionProperties = new ArrayList<Property>();
        this.addDimensionProperties();
        this.wrappingProperties = new ArrayList<Property>();
        this.addWrappingProperties();
        this.viewProperties = new ArrayList<Property>();
        this.addViewProperties();
        this.modelProperties = new ArrayList<Property>();
        this.addModelProperties();
        this.cornerChoices = new ArrayList<OriginConfiguration>();
        this.addCornerChoices();
        this.edgeChoices = new ArrayList<OriginConfiguration>();
        this.addEdgeChoices();
        this.originConfigurations = new ArrayList<OriginConfiguration>();
        this.addOriginConfigurations();
    }

    public void addViewProperties() {
        this.viewProperties.addAll(Properties.view2D());
    }

    public void addModelProperties() {
        this.modelProperties.addAll(Properties.model());
    }

    public void refreshViewProperties(boolean bl) {
        this.viewProperties.clear();
        this.addViewProperties();
        if (bl) {
            this.viewProperties.addAll(Properties.view3D());
        }
    }

    public void addCornerChoices() {
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner.bottomLeft"), new boolean[]{false, true, false, true}, new boolean[]{true, false, true, false}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner.topLeft"), new boolean[]{false, true, true, false}, new boolean[]{true, false, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner.topRight"), new boolean[]{true, false, true, false}, new boolean[]{false, true, false, true}));
        this.cornerChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner.bottomRight"), new boolean[]{true, false, false, true}, new boolean[]{false, true, true, false}));
    }

    public void addEdgeChoices() {
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge.bottom"), new boolean[]{true, true, false, true}, new boolean[]{false, false, true, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge.top"), new boolean[]{true, true, true, false}, new boolean[]{false, false, false, true}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge.right"), new boolean[]{true, false, true, true}, new boolean[]{false, true, false, false}));
        this.edgeChoices.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge.left"), new boolean[]{false, true, true, true}, new boolean[]{true, false, false, false}));
    }

    public void addOriginConfigurations() {
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.center"), new boolean[]{false, true, false, true}, new boolean[]{false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.corner"), new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.edge"), new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}));
        this.originConfigurations.add(new OriginConfiguration(I18N.guiJ().get("edit.viewSettings.origin.location.custom"), new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}));
    }

    public Object load(String[] stringArray, String string) {
        this.workspace.loadWorld(stringArray, string, this);
        this.workspace.world.tickCounter.clear();
        this.workspace.world.clearPatches();
        this.workspace.world.displayOn(true);
        return this;
    }

    @Override
    public Option<String> helpLink() {
        return Option.apply(null);
    }

    @Override
    public List<Property> propertySet() {
        return this.propertySet;
    }

    public void propertySet(List<Property> list) {
        this.propertySet = list;
    }

    public void patchSize(double d) {
        this.newPatchSize = d;
        this.patchSizeChanged = this.patchSizeChanged || d != this.patchSize();
    }

    public double patchSize() {
        return this.workspace.world.patchSize();
    }

    @Override
    public void updateMode(Workspace.UpdateMode updateMode) {
        this.workspace.updateMode(updateMode);
    }

    @Override
    public int fontSize() {
        return this.gWidget.view.fontSize();
    }

    @Override
    public void fontSize(int n) {
        this.newFontSize = n;
        if (n != this.fontSize()) {
            this.fontSizeChanged = true;
        }
        this.workspace.viewManager.applyNewFontSize(n);
    }

    public double frameRate() {
        return this.workspace.frameRate();
    }

    @Override
    public void frameRate(double d) {
        this.workspace.frameRate(d);
    }

    @Override
    public void showTickCounter(boolean bl) {
        this.workspace.viewWidget.showTickCounter(bl);
    }

    public boolean showTickCounter() {
        return this.workspace.viewWidget.showTickCounter();
    }

    public String tickCounterLabel() {
        return this.workspace.viewWidget.tickCounterLabel();
    }

    @Override
    public void tickCounterLabel(String string) {
        this.workspace.viewWidget.tickCounterLabel(string);
    }

    @Override
    public void changeTopology(boolean bl, boolean bl2) {
        this.workspace.changeTopology(bl, bl2);
    }

    @Override
    public void clearTurtles() {
        this.workspace.world.clearTurtles();
    }

    @Override
    public boolean anyErrors() {
        return this.error != null;
    }

    public void error(Exception exception) {
        if (!(exception instanceof CompilerException)) {
            throw new IllegalStateException(exception);
        }
        this.error = (CompilerException)exception;
    }

    @Override
    public void error(Object object, Exception exception) {
        this.error(exception);
    }

    @Override
    public Exception error(Object object) {
        return this.error;
    }

    @Override
    public void setSize(int n, int n2) {
        this.gWidget.setSize(n, n2);
    }

    @Override
    public int getMinimumWidth() {
        return this.gWidget.getMinimumWidth();
    }

    @Override
    public int insetWidth() {
        return this.gWidget.insetWidth();
    }

    @Override
    public double computePatchSize(int n, int n2) {
        return this.gWidget.computePatchSize(n, n2);
    }

    @Override
    public int calculateHeight(int n, double d) {
        return this.gWidget.calculateHeight(n, d);
    }

    @Override
    public int calculateWidth(int n, double d) {
        return this.gWidget.calculateWidth(n, d);
    }

    @Override
    public void setDimensions(WorldDimensions worldDimensions, double d) {
        this.workspace.world.patchSize(d);
        this.setDimensions(worldDimensions);
        this.patchSize(d);
        this.gWidget.resetSize();
    }

    public void setDimensions(WorldDimensions worldDimensions) {
        this.setDimensions(worldDimensions.minPxcor(), worldDimensions.maxPxcor(), worldDimensions.minPycor(), worldDimensions.maxPycor());
    }

    public void setDimensions(int n, int n2, int n3, int n4) {
        this.newMinX = n;
        this.newMaxX = n2;
        this.newMinY = n3;
        this.newMaxY = n4;
        if (n != this.workspace.world.minPxcor() || n2 != this.workspace.world.maxPxcor() || n3 != this.workspace.world.minPycor() || n4 != this.workspace.world.maxPycor()) {
            this.prepareForWorldResize();
            this.workspace.world.createPatches(n, n2, n3, n4);
            this.finishWorldResize();
        }
    }

    void prepareForWorldResize() {
        this.workspace.jobManager.haltNonObserverJobs();
        this.workspace.world.clearTurtles();
        this.workspace.world.clearLinks();
    }

    void finishWorldResize() {
        this.workspace.patchesCreatedNotify();
        this.gWidget.resetSize();
        this.workspace.clearDrawing();
    }

    @Override
    public int sourceOffset() {
        throw new IllegalStateException();
    }
}

