/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.World;
import org.nlogo.api.CompilerException;
import org.nlogo.api.FileMode;
import org.nlogo.api.FileModeJ;
import org.nlogo.api.I18N;
import org.nlogo.api.LocalFile;
import org.nlogo.api.RemoteFile;
import org.nlogo.nvm.FileManager;
import org.nlogo.workspace.AbstractWorkspace;

public strictfp final class DefaultFileManager
implements FileManager {
    private final List<org.nlogo.api.File> openFiles = new ArrayList<org.nlogo.api.File>();
    private org.nlogo.api.File currentFile;
    private String prefix;
    private final AbstractWorkspace workspace;

    public DefaultFileManager(AbstractWorkspace abstractWorkspace) {
        this.workspace = abstractWorkspace;
        if (AbstractWorkspace.isApp()) {
            this.setPrefix(System.getProperty("user.home"));
        }
    }

    public String getErrorInfo() throws IOException {
        long l = this.currentFile.pos();
        this.currentFile.close(true);
        this.currentFile.open(FileModeJ.READ());
        int n = 1;
        long l2 = 0L;
        String string = this.readLine();
        while (this.currentFile.pos() < l) {
            ++n;
            l2 = this.currentFile.pos();
            string = this.readLine();
        }
        int n2 = (int)(l - l2);
        if (n2 >= string.length() && !this.eof()) {
            string = this.readLine();
            n2 = 0;
            ++n;
        }
        this.closeCurrentFile();
        return " (line number " + n + ", character " + (n2 + 1) + ")";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public org.nlogo.api.File getFile(String string) {
        if (AbstractWorkspace.isApplet()) {
            return new RemoteFile(string);
        }
        return new LocalFile(string);
    }

    public void setPrefix(String string) {
        if (AbstractWorkspace.isApplet()) {
            return;
        }
        if (string.charAt(string.length() - 1) != File.separatorChar) {
            string = string + File.separatorChar;
        }
        if (new File(string).isAbsolute()) {
            this.prefix = string;
        } else {
            this.prefix = this.relativeToAbsolute(string);
            if (this.prefix.charAt(this.prefix.length() - 1) != File.separatorChar) {
                this.prefix = this.prefix + File.separatorChar;
            }
        }
    }

    public void setPrefix(URL uRL) {
        this.prefix = uRL.toString();
    }

    public String attachPrefix(String string) throws MalformedURLException {
        if (AbstractWorkspace.isApplet()) {
            try {
                return new URL(new URL(this.prefix), string).toString();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalStateException(malformedURLException);
            }
        }
        File file = new File(string);
        if (file.isAbsolute() || this.prefix == null) {
            return string;
        }
        return this.relativeToAbsolute(string);
    }

    private String relativeToAbsolute(String string) {
        try {
            return new File(this.prefix + File.separatorChar + string).getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public boolean hasCurrentFile() {
        return this.currentFile != null && this.isFileOpen(this.currentFile.getAbsolutePath());
    }

    private boolean isFileOpen(String string) {
        return this.findOpenFile(string) != null;
    }

    public org.nlogo.api.File findOpenFile(String string) {
        if (AbstractWorkspace.isApplet()) {
            for (org.nlogo.api.File file : this.openFiles) {
                if (!string.equals(file.getPath())) continue;
                return file;
            }
        } else {
            File file = new File(string);
            for (org.nlogo.api.File file2 : this.openFiles) {
                if (!file.getAbsolutePath().equals(file2.getAbsolutePath())) continue;
                return file2;
            }
        }
        return null;
    }

    private boolean isFileCurrent(org.nlogo.api.File file) {
        return this.currentFile == file;
    }

    public void setCurrentFile(org.nlogo.api.File file) {
        if (!this.isFileCurrent(file)) {
            this.currentFile = file;
        }
    }

    public void ensureMode(FileMode fileMode) throws IOException {
        if (!this.hasCurrentFile()) {
            throw new IOException(I18N.errorsJ().get("org.nlogo.workspace.DefaultFileManager.noOpenFile"));
        }
        if (this.currentFile.mode() == FileModeJ.NONE()) {
            try {
                this.currentFile.open(fileMode);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException("The file " + this.currentFile.getAbsolutePath() + " cannot be found");
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
        } else if (this.currentFile.mode() != fileMode) {
            String string = this.currentFile.mode() == FileModeJ.READ() ? "READING" : "WRITING";
            throw new IOException("You can only use " + string + " primitives with this file");
        }
    }

    public boolean fileExists(String string) {
        if (AbstractWorkspace.isApplet()) {
            try {
                return RemoteFile.exists(this.attachPrefix(string));
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return new File(string).exists();
    }

    public void deleteFile(String string) throws IOException {
        org.nlogo.api.File file = this.findOpenFile(string);
        if (file != null) {
            throw new IOException("You need to close the file before deletion");
        }
        File file2 = new File(string);
        if (!file2.exists()) {
            throw new IOException(I18N.errorsJ().get("org.nlogo.workspace.DefaultFileManager.cannotDeleteNonExistantFile"));
        }
        if (!file2.canWrite()) {
            throw new IOException("Modification to this file is denied.");
        }
        if (!file2.isFile()) {
            throw new IOException(I18N.errorsJ().get("org.nlogo.workspace.DefaultFileManager.canOnlyDeleteFiles"));
        }
        if (!file2.delete()) {
            throw new IOException("Deletion failed.");
        }
    }

    public void openFile(String string) throws IOException {
        String string2 = this.attachPrefix(string);
        if (string2 == null) {
            throw new IOException("This filename is illegal, " + string);
        }
        org.nlogo.api.File file = this.findOpenFile(string2);
        if (file == null) {
            file = AbstractWorkspace.isApplet() ? new RemoteFile(string2) : new LocalFile(string2);
            this.openFiles.add(file);
        }
        this.setCurrentFile(file);
    }

    public void flushCurrentFile() throws IOException {
        if (!this.hasCurrentFile()) {
            throw new IOException("There is no file to file");
        }
        this.flushFile(this.currentFile.getAbsolutePath());
    }

    public void flushFile(String string) {
        org.nlogo.api.File file = this.findOpenFile(string);
        file.flush();
    }

    public void closeCurrentFile() throws IOException {
        if (!this.hasCurrentFile()) {
            this.closeAllFiles();
            throw new IOException("There is no file to close");
        }
        this.closeFile(this.currentFile.getAbsolutePath());
        this.setCurrentFile(null);
    }

    private void closeFile(String string) throws IOException {
        org.nlogo.api.File file = this.findOpenFile(string);
        file.close(true);
        this.openFiles.remove(file);
    }

    public String readLine() throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        BufferedReader bufferedReader = this.currentFile.reader();
        String string = "";
        char[] cArray = new char[80];
        int n = 80;
        int n2 = 1;
        while (n == 80) {
            bufferedReader.mark(82);
            n = bufferedReader.read(cArray, 0, 80);
            for (int i = 0; i < n; ++i) {
                if (cArray[i] == '\r') {
                    if (i < 79 && cArray[i + 1] == '\n' || i == 79 && bufferedReader.read() == 10) {
                        n2 = 2;
                    }
                    n = i;
                    continue;
                }
                if (cArray[i] != '\n') continue;
                n = i;
            }
            this.currentFile.pos_$eq(this.currentFile.pos() + (long)n);
            string = string + new String(cArray, 0, n);
        }
        bufferedReader.reset();
        this.currentFile.pos_$eq(this.currentFile.pos() + bufferedReader.skip(n + n2) - (long)n);
        return string;
    }

    public String readChars(int n) throws IOException {
        if (this.eof()) {
            throw new EOFException();
        }
        char[] cArray = new char[n];
        BufferedReader bufferedReader = this.currentFile.reader();
        this.currentFile.pos_$eq(this.currentFile.pos() + (long)bufferedReader.read(cArray, 0, n));
        return String.valueOf(cArray);
    }

    public Object read(World world) throws IOException, CompilerException {
        if (this.eof()) {
            throw new EOFException();
        }
        return this.workspace.compiler().readFromFile(this.currentFile, world, this.workspace.getExtensionManager());
    }

    public boolean eof() throws IOException {
        this.ensureMode(FileModeJ.READ());
        if (!this.currentFile.eof()) {
            BufferedReader bufferedReader = this.currentFile.reader();
            bufferedReader.mark(2);
            this.currentFile.eof_$eq(bufferedReader.read() == -1);
            bufferedReader.reset();
        }
        return this.currentFile.eof();
    }

    public void closeAllFiles() throws IOException {
        Iterator<org.nlogo.api.File> iterator2 = this.openFiles.iterator();
        while (iterator2.hasNext()) {
            org.nlogo.api.File file = iterator2.next();
            this.closeFile(file.getAbsolutePath());
            iterator2 = this.openFiles.iterator();
        }
        this.setCurrentFile(null);
    }

    public void writeOutputObject(OutputObject outputObject) {
        PrintWriter printWriter = this.currentFile.getPrintWriter();
        printWriter.print(outputObject.get());
    }

    public void handleModelChange() {
        if (this.workspace.getModelDir() != null) {
            this.setPrefix(this.workspace.getModelDir());
        } else if (AbstractWorkspace.isApp()) {
            this.setPrefix(System.getProperty("user.home"));
        }
        try {
            this.closeAllFiles();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }
}

