/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.nlogo.api.APIVersion;
import org.nlogo.api.ClassManager;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Dump;
import org.nlogo.api.ErrorSource;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionObject;
import org.nlogo.api.File;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.JavaLibraryPath;
import org.nlogo.api.Primitive;
import org.nlogo.api.RemoteFile;
import org.nlogo.api.Reporter;
import org.nlogo.nvm.FileManager;
import org.nlogo.util.Exceptions;
import org.nlogo.workspace.AbstractWorkspace;
import org.nlogo.workspace.ExtensionPrimitiveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class ExtensionManager
implements org.nlogo.api.ExtensionManager {
    private final Map<String, JarContainer> jars = new HashMap<String, JarContainer>();
    private final AbstractWorkspace workspace;
    private int jarsLoaded = 0;
    private Object obj = null;

    public AbstractWorkspace workspace() {
        return this.workspace;
    }

    @Override
    public boolean profilingEnabled() {
        return this.workspace.profilingEnabled();
    }

    public ExtensionManager(AbstractWorkspace abstractWorkspace) {
        this.workspace = abstractWorkspace;
    }

    @Override
    public boolean anyExtensionsLoaded() {
        return this.jarsLoaded > 0;
    }

    @Override
    public Iterable<ClassManager> loadedExtensions() {
        ArrayList<ClassManager> arrayList = new ArrayList<ClassManager>();
        for (JarContainer jarContainer : this.jars.values()) {
            arrayList.add(jarContainer.classManager);
        }
        return arrayList;
    }

    @Override
    public String getSource(String string) throws IOException {
        return this.workspace.getSource(string);
    }

    @Override
    public File getFile(String string) throws ExtensionException {
        FileManager fileManager = this.workspace().fileManager();
        return fileManager.getFile(this.getFullPath(string));
    }

    @Override
    public void storeObject(Object object) {
        this.obj = object;
    }

    @Override
    public Object retrieveObject() {
        return this.obj;
    }

    private String identifierToJar(String string) {
        if (!string.endsWith(".jar")) {
            if (AbstractWorkspace.isApplet()) {
                return string + "/" + string + ".jar";
            }
            return string + java.io.File.separator + string + ".jar";
        }
        return string;
    }

    @Override
    public void importExtension(String string, ErrorSource errorSource) throws CompilerException {
        Object object;
        String string2 = this.identifierToJar(string);
        try {
            string2 = this.resolvePathAsURL(string2);
            if (AbstractWorkspace.isApplet()) {
                object = new URL(string2);
                ((URL)object).openConnection().setUseCaches(false);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            errorSource.signalError("Can't find extension: " + string);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            object = this.getClassLoader(string2, errorSource, this.getClass().getClassLoader());
            if (object == null) {
                return;
            }
            ClassManager classManager = this.getClassManager(string2, (URLClassLoader)object, errorSource);
            if (classManager == null) {
                return;
            }
            JarContainer jarContainer = this.jars.get(string2);
            long l = this.getModified(string2, errorSource);
            if (jarContainer == null || jarContainer.modified != l) {
                if (jarContainer != null) {
                    jarContainer.classManager.unload(this);
                }
                jarContainer = new JarContainer(string, string2, (URLClassLoader)object, l);
                try {
                    if (!this.workspace.compilerTestingMode()) {
                        classManager.runOnce(this);
                    }
                }
                catch (ExtensionException extensionException) {
                    System.err.println("Error while initializing extension.");
                    System.err.println("Error is: " + extensionException);
                    throw extensionException;
                }
                this.jars.put(string2, jarContainer);
            }
            if (!jarContainer.loaded) {
                ++this.jarsLoaded;
                jarContainer.loaded = true;
                jarContainer.classManager = classManager;
                jarContainer.primManager = new ExtensionPrimitiveManager(string);
                classManager.load(jarContainer.primManager);
            }
            jarContainer.live = true;
            jarContainer.prefix = this.getExtensionName(string2, errorSource);
        }
        catch (ExtensionException extensionException) {
            errorSource.signalError(extensionException.getMessage());
            return;
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            errorSource.signalError("This extension doesn't work with this version of NetLogo");
            System.err.println(incompatibleClassChangeError);
        }
    }

    @Override
    public void addToLibraryPath(Object object, String string) {
        JavaLibraryPath.setLibraryPath(object.getClass(), string);
    }

    @Override
    public String resolvePath(String string) {
        try {
            java.io.File file = new java.io.File(this.workspace.attachModelDir(string));
            if (AbstractWorkspace.isApplet()) {
                return file.getPath();
            }
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return file.getPath();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(string + " is not a valid pathname: " + malformedURLException);
        }
    }

    @Override
    public String resolvePathAsURL(String string) {
        if (AbstractWorkspace.isApplet()) {
            try {
                String string2 = this.workspace.fileManager().attachPrefix(string);
                if (RemoteFile.exists(string2)) {
                    return string2;
                }
                throw new IllegalStateException("Can't find extension: " + string + " using URL " + string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalStateException(string + " is not a valid pathname: " + malformedURLException);
            }
        }
        try {
            URL uRL = new URL(string);
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            java.io.File file;
            Exceptions.ignore(malformedURLException);
            if (string.contains(java.io.File.separator)) {
                try {
                    file = new java.io.File(this.workspace.attachModelDir(string));
                    if (file.exists()) {
                        return ExtensionManager.toURL(file).toString();
                    }
                }
                catch (MalformedURLException malformedURLException2) {
                    Exceptions.ignore(malformedURLException2);
                }
            }
            try {
                file = new java.io.File(this.workspace.attachModelDir(string));
                if (file.exists()) {
                    return ExtensionManager.toURL(file).toString();
                }
            }
            catch (MalformedURLException malformedURLException3) {
                Exceptions.ignore(malformedURLException3);
            }
            try {
                file = new java.io.File("extensions" + java.io.File.separator + string);
                if (file.exists()) {
                    return ExtensionManager.toURL(file).toString();
                }
            }
            catch (MalformedURLException malformedURLException4) {
                Exceptions.ignore(malformedURLException4);
            }
            throw new IllegalStateException("Can't find extension: " + string);
        }
    }

    public String getFullPath(String string) throws ExtensionException {
        Object object;
        if (AbstractWorkspace.isApplet()) {
            try {
                String string2 = this.workspace.fileManager().attachPrefix(string);
                if (RemoteFile.exists(string2)) {
                    return string2;
                }
                throw new ExtensionException("Can't find file " + string + " using " + string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ExtensionException(string + " is not a valid pathname: " + malformedURLException);
            }
        }
        try {
            object = this.workspace.attachModelDir(string);
            java.io.File file = new java.io.File((String)object);
            if (file.exists()) {
                return object;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.ignore(malformedURLException);
        }
        object = new java.io.File("extensions" + java.io.File.separator + string);
        if (((java.io.File)object).exists()) {
            return ((java.io.File)object).getPath();
        }
        throw new ExtensionException("Can't find file " + string);
    }

    private URLClassLoader getClassLoader(String string, ErrorSource errorSource, ClassLoader classLoader) throws CompilerException {
        JarContainer jarContainer = this.jars.get(string);
        if (jarContainer != null) {
            return jarContainer.jarClassLoader;
        }
        try {
            URL uRL = new URL(string);
            ArrayList<URL> arrayList = new ArrayList<URL>();
            arrayList.add(uRL);
            java.io.File file = new java.io.File(new java.io.File(uRL.getFile()).getParent());
            arrayList.addAll(this.getAdditionalJars(file));
            file = new java.io.File("extensions");
            arrayList.addAll(this.getAdditionalJars(file));
            return URLClassLoader.newInstance(arrayList.toArray(new URL[arrayList.size()]), classLoader);
        }
        catch (MalformedURLException malformedURLException) {
            errorSource.signalError("Invalid URL: " + string);
            return null;
        }
    }

    private ClassManager getClassManager(String string, URLClassLoader uRLClassLoader, ErrorSource errorSource) throws CompilerException {
        JarContainer jarContainer = this.jars.get(string);
        if (jarContainer != null && jarContainer.loaded) {
            return jarContainer.classManager;
        }
        String string2 = null;
        try {
            string2 = this.getClassManagerName(string, errorSource);
            if (string2 == null) {
                errorSource.signalError("Bad extension: Couldn't locate Class-Manager tag in Manifest File");
            }
            Object obj = uRLClassLoader.loadClass(string2).newInstance();
            try {
                return (ClassManager)obj;
            }
            catch (ClassCastException classCastException) {
                errorSource.signalError("Bad extension: The ClassManager doesn't implement org.nlogo.api.ClassManager");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            errorSource.signalError("Can't find extension: " + string);
        }
        catch (IOException iOException) {
            errorSource.signalError("Can't open extension " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            errorSource.signalError("Can't find class " + string2 + " in extension");
        }
        return null;
    }

    private String getClassManagerName(String string, ErrorSource errorSource) throws IOException, CompilerException {
        URL uRL = new URL("jar", "", string + "!/");
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        String string2 = null;
        if (jarURLConnection.getManifest() == null) {
            errorSource.signalError("Bad extension: Can't find a Manifest file in extension");
        }
        Attributes attributes = jarURLConnection.getManifest().getMainAttributes();
        string2 = attributes.getValue("Class-Manager");
        if (!this.checkVersion(attributes)) {
            errorSource.signalError("User halted compilation");
        }
        return string2;
    }

    private String getExtensionName(String string, ErrorSource errorSource) throws CompilerException {
        try {
            Attributes attributes;
            URL uRL = new URL("jar", "", string + "!/");
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            String string2 = null;
            if (jarURLConnection.getManifest() == null) {
                errorSource.signalError("Bad extension: Can't find Manifest file in extension");
            }
            if ((string2 = (attributes = jarURLConnection.getManifest().getMainAttributes()).getValue("Extension-Name")) == null) {
                errorSource.signalError("Bad extension: Can't find extension name in Manifest.");
            }
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            errorSource.signalError("Can't find extension: " + string);
        }
        catch (IOException iOException) {
            errorSource.signalError("Can't find extension: " + string);
        }
        return null;
    }

    @Override
    public Object readFromString(String string) throws CompilerException {
        return this.workspace.readFromString(string);
    }

    public void clearAll() {
        for (JarContainer jarContainer : this.jars.values()) {
            jarContainer.classManager.clearAll();
        }
    }

    @Override
    public ExtensionObject readExtensionObject(String string, String string2, String string3) throws CompilerException {
        JarContainer jarContainer = null;
        string = string.toUpperCase();
        for (Map.Entry<String, JarContainer> entry : this.jars.entrySet()) {
            jarContainer = entry.getValue();
            String string4 = jarContainer.primManager.name().toUpperCase();
            if (!jarContainer.loaded || string4 == null || !string4.equals(string)) continue;
            try {
                return jarContainer.classManager.readExtensionObject(this, string2, string3);
            }
            catch (ExtensionException extensionException) {
                System.err.println(extensionException);
                throw new IllegalStateException("Error reading extension object " + string + ":" + string2 + " " + string3 + " ==> " + extensionException.getMessage());
            }
        }
        return null;
    }

    @Override
    public Primitive replaceIdentifier(String string) {
        Primitive primitive = null;
        boolean bl = string.indexOf(58) != -1;
        Iterator<Map.Entry<String, JarContainer>> iterator2 = this.jars.entrySet().iterator();
        while (iterator2.hasNext() && primitive == null) {
            Map.Entry<String, JarContainer> entry = iterator2.next();
            JarContainer jarContainer = entry.getValue();
            String string2 = jarContainer.primManager.name().toUpperCase();
            if (!jarContainer.live) continue;
            if (bl) {
                String string3 = string.substring(0, string.indexOf(58));
                String string4 = string.substring(string.indexOf(58) + 1);
                if (!string3.equals(string2)) continue;
                primitive = jarContainer.primManager.getPrimitive(string4);
                continue;
            }
            if (!jarContainer.primManager.autoImportPrimitives()) continue;
            primitive = jarContainer.primManager.getPrimitive(string);
        }
        return primitive;
    }

    @Override
    public String dumpExtensions() {
        String string = "EXTENSION\tLOADED\tMODIFIED\tJARPATH\n";
        string = string + "---------\t------\t---------\t---\n";
        JarContainer jarContainer2 = null;
        for (JarContainer jarContainer2 : this.jars.values()) {
            string = string + jarContainer2.prefix + "\t" + jarContainer2.loaded + "\t" + jarContainer2.modified + "\t" + jarContainer2.jarName + "\n";
        }
        return string;
    }

    @Override
    public List<String> getJarPaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (JarContainer jarContainer : this.jars.values()) {
            arrayList.add(jarContainer.extensionName + '/' + jarContainer.extensionName + ".jar");
            for (String string : jarContainer.classManager.additionalJars()) {
                arrayList.add(jarContainer.extensionName + '/' + string);
            }
        }
        return arrayList;
    }

    @Override
    public List<String> getExtensionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (JarContainer jarContainer : this.jars.values()) {
            arrayList.add(jarContainer.extensionName);
        }
        return arrayList;
    }

    @Override
    public String dumpExtensionPrimitives() {
        String string = "\n\nEXTENSION\tPRIMITIVE\tTYPE\n";
        string = string + "----------\t---------\t----\n";
        JarContainer jarContainer2 = null;
        for (JarContainer jarContainer2 : this.jars.values()) {
            Iterator<String> iterator2 = jarContainer2.primManager.getPrimitiveNames();
            while (iterator2.hasNext()) {
                String string2 = iterator2.next();
                Primitive primitive = jarContainer2.primManager.getPrimitive(string2);
                String string3 = primitive instanceof Reporter ? "Reporter" : "Command";
                string = string + jarContainer2.prefix + "\t" + string2 + "\t" + string3 + "\n";
            }
        }
        return string;
    }

    @Override
    public void reset() {
        for (JarContainer jarContainer : this.jars.values()) {
            try {
                jarContainer.classManager.unload(this);
            }
            catch (ExtensionException extensionException) {
                System.err.println(extensionException);
                extensionException.printStackTrace();
            }
            jarContainer.loaded = false;
            jarContainer.live = false;
            jarContainer.jarClassLoader = null;
        }
        this.jars.clear();
        this.jarsLoaded = 0;
    }

    List<URL> getAdditionalJars(java.io.File file) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (!AbstractWorkspace.isApplet() && file.exists() && file.isDirectory()) {
            java.io.File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile() || !fileArray[i].getName().toUpperCase().endsWith(".JAR")) continue;
                try {
                    arrayList.add(ExtensionManager.toURL(fileArray[i]));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalStateException(malformedURLException);
                }
            }
        }
        return arrayList;
    }

    @Override
    public void startFullCompilation() {
        for (JarContainer jarContainer : this.jars.values()) {
            jarContainer.live = false;
        }
    }

    @Override
    public void finishFullCompilation() {
        for (JarContainer jarContainer : this.jars.values()) {
            try {
                if (!jarContainer.loaded || jarContainer.live) continue;
                --this.jarsLoaded;
                this.jars.remove(jarContainer.prefix);
                jarContainer.loaded = false;
                jarContainer.classManager.unload(this);
            }
            catch (ExtensionException extensionException) {
                System.err.println("Error unloading extension: " + extensionException);
            }
        }
    }

    private boolean checkVersion(Attributes attributes) {
        String string = APIVersion.version();
        String string2 = attributes.getValue("NetLogo-Extension-API-Version");
        if (string2 == null) {
            return this.workspace.warningMessage("Could not determine version of NetLogo extension.  NetLogo can try to load the extension, but it might not work.");
        }
        if (!string.equals(string2)) {
            return this.workspace.warningMessage("You are attempting to open a NetLogo extension file that was created for a different version of the NetLogo Extension API.  (This NetLogo uses Extension API " + string + "; the extension uses NetLogo Extension API " + string2 + ".)  NetLogo can try to load the extension, " + "but it might not work.");
        }
        return true;
    }

    private long getModified(String string, ErrorSource errorSource) throws CompilerException {
        try {
            return new URL(string).openConnection().getLastModified();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            errorSource.signalError("Can't open extension");
            throw new IllegalStateException("this code is unreachable");
        }
    }

    public void exportWorld(PrintWriter printWriter) {
        printWriter.println(Dump.csv().encode("EXTENSIONS"));
        printWriter.println();
        for (JarContainer jarContainer : this.jars.values()) {
            StringBuilder stringBuilder = jarContainer.classManager.exportWorld();
            if (stringBuilder.length() <= 0) continue;
            printWriter.println(Dump.csv().encode(jarContainer.extensionName));
            printWriter.print(stringBuilder);
            printWriter.println();
        }
    }

    public void importExtensionData(String string, List<String[]> list, ImportErrorHandler importErrorHandler) throws ExtensionException {
        JarContainer jarContainer = this.getJarContainerByIdentifier(string);
        if (jarContainer == null) {
            throw new ExtensionException("there is no extension named " + string + "in this model");
        }
        jarContainer.classManager.importWorld(list, this, importErrorHandler);
    }

    public boolean isExtensionName(String string) {
        return this.getJarContainerByIdentifier(string) != null;
    }

    private JarContainer getJarContainerByIdentifier(String string) {
        for (JarContainer jarContainer : this.jars.values()) {
            if (!jarContainer.extensionName.equalsIgnoreCase(string)) continue;
            return jarContainer;
        }
        return null;
    }

    private static URL toURL(java.io.File file) throws MalformedURLException {
        return file.toURL();
    }

    private strictfp class JarContainer {
        public final String extensionName;
        public final String jarName;
        public URLClassLoader jarClassLoader;
        public final long modified;
        public ExtensionPrimitiveManager primManager;
        public ClassManager classManager;
        public boolean loaded;
        public boolean live;
        public String prefix;

        JarContainer(String string, String string2, URLClassLoader uRLClassLoader, long l) {
            this.extensionName = string;
            this.jarName = string2;
            this.jarClassLoader = uRLClassLoader;
            this.loaded = false;
            this.live = false;
            this.prefix = null;
            this.modified = l;
        }
    }
}

