/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.GenTraversableOnce$class;
import scala.collection.Iterable;
import scala.collection.Iterator$class;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassManifest;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.VolatileIntRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Iterator<A>
extends TraversableOnce<A>,
ScalaObject {
    @Override
    public Iterator<A> seq();

    public boolean hasNext();

    public A next();

    @Override
    public boolean isEmpty();

    public Iterator<A> take(int var1);

    public Iterator<A> drop(int var1);

    public Iterator<A> slice(int var1, int var2);

    public <B> Iterator<B> map(Function1<A, B> var1);

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> var1);

    public <B> Iterator<B> flatMap(Function1<A, GenTraversableOnce<B>> var1);

    public Iterator<A> filter(Function1<A, Object> var1);

    public Iterator<A> withFilter(Function1<A, Object> var1);

    public <B> Iterator<B> collect(PartialFunction<A, B> var1);

    public Iterator<A> takeWhile(Function1<A, Object> var1);

    public Iterator<A> dropWhile(Function1<A, Object> var1);

    public <B> Object zip(Iterator<B> var1);

    @Override
    public <U> void foreach(Function1<A, U> var1);

    @Override
    public boolean forall(Function1<A, Object> var1);

    public boolean exists(Function1<A, Object> var1);

    public Option<A> find(Function1<A, Object> var1);

    public int indexWhere(Function1<A, Object> var1);

    public BufferedIterator buffered();

    public <B> Object patch(int var1, Iterator<B> var2, int var3);

    @Override
    public Traversable<A> toTraversable();

    @Override
    public Stream<A> toStream();

    public <B> void readInto(Object var1, int var2, int var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GroupedIterator<B>
    implements Iterator<Seq<B>>,
    ScalaObject {
        private final Iterator<A> self;
        public final int scala$collection$Iterator$GroupedIterator$$size;
        public final int scala$collection$Iterator$GroupedIterator$$step;
        private ArrayBuffer<B> buffer;
        private boolean filled;
        private boolean _partial;
        public Option<Function0<B>> scala$collection$Iterator$GroupedIterator$$pad;
        public final Iterator $outer;

        @Override
        public Iterator<Seq<B>> seq() {
            return Iterator$class.seq(this);
        }

        @Override
        public boolean isEmpty() {
            return Iterator$class.isEmpty(this);
        }

        @Override
        public boolean isTraversableAgain() {
            return Iterator$class.isTraversableAgain(this);
        }

        @Override
        public boolean hasDefiniteSize() {
            return Iterator$class.hasDefiniteSize(this);
        }

        @Override
        public Iterator<Seq<B>> take(int n) {
            return Iterator$class.take(this, n);
        }

        @Override
        public Iterator<Seq<B>> drop(int n) {
            return Iterator$class.drop(this, n);
        }

        @Override
        public Iterator<Seq<B>> slice(int n, int n2) {
            return Iterator$class.slice(this, n, n2);
        }

        @Override
        public <B> Iterator<B> map(Function1<Seq<B>, B> function1) {
            return Iterator$class.map(this, function1);
        }

        @Override
        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> function0) {
            return Iterator$class.$plus$plus(this, function0);
        }

        @Override
        public <B> Iterator<B> flatMap(Function1<Seq<B>, GenTraversableOnce<B>> function1) {
            return Iterator$class.flatMap(this, function1);
        }

        @Override
        public Iterator<Seq<B>> filter(Function1<Seq<B>, Object> function1) {
            return Iterator$class.filter(this, function1);
        }

        @Override
        public Iterator<Seq<B>> withFilter(Function1<Seq<B>, Object> function1) {
            return Iterator$class.withFilter(this, function1);
        }

        @Override
        public <B> Iterator<B> collect(PartialFunction<Seq<B>, B> partialFunction) {
            return Iterator$class.collect(this, partialFunction);
        }

        @Override
        public Iterator<Seq<B>> takeWhile(Function1<Seq<B>, Object> function1) {
            return Iterator$class.takeWhile(this, function1);
        }

        @Override
        public Iterator<Seq<B>> dropWhile(Function1<Seq<B>, Object> function1) {
            return Iterator$class.dropWhile(this, function1);
        }

        @Override
        public <B> Object zip(Iterator<B> iterator2) {
            return Iterator$class.zip(this, iterator2);
        }

        @Override
        public <U> void foreach(Function1<Seq<B>, U> function1) {
            Iterator$class.foreach(this, function1);
        }

        @Override
        public boolean forall(Function1<Seq<B>, Object> function1) {
            return Iterator$class.forall(this, function1);
        }

        @Override
        public boolean exists(Function1<Seq<B>, Object> function1) {
            return Iterator$class.exists(this, function1);
        }

        @Override
        public Option<Seq<B>> find(Function1<Seq<B>, Object> function1) {
            return Iterator$class.find(this, function1);
        }

        @Override
        public int indexWhere(Function1<Seq<B>, Object> function1) {
            return Iterator$class.indexWhere(this, function1);
        }

        @Override
        public BufferedIterator buffered() {
            return Iterator$class.buffered(this);
        }

        @Override
        public <B> Object patch(int n, Iterator<B> iterator2, int n2) {
            return Iterator$class.patch(this, n, iterator2, n2);
        }

        @Override
        public <B> void copyToArray(Object object, int n, int n2) {
            Iterator$class.copyToArray(this, object, n, n2);
        }

        @Override
        public Traversable<Seq<B>> toTraversable() {
            return Iterator$class.toTraversable(this);
        }

        @Override
        public Iterator<Seq<B>> toIterator() {
            return Iterator$class.toIterator(this);
        }

        @Override
        public Stream<Seq<B>> toStream() {
            return Iterator$class.toStream(this);
        }

        public String toString() {
            return Iterator$class.toString(this);
        }

        @Override
        public <B> void readInto(Object object, int n, int n2) {
            Iterator$class.readInto(this, object, n, n2);
        }

        @Override
        public List<Seq<B>> reversed() {
            return TraversableOnce$class.reversed(this);
        }

        @Override
        public int size() {
            return TraversableOnce$class.size(this);
        }

        @Override
        public boolean nonEmpty() {
            return TraversableOnce$class.nonEmpty(this);
        }

        @Override
        public <B> Option<B> collectFirst(PartialFunction<Seq<B>, B> partialFunction) {
            return TraversableOnce$class.collectFirst(this, partialFunction);
        }

        @Override
        public <B> B $div$colon(B b, Function2<B, Seq<B>, B> function2) {
            return (B)TraversableOnce$class.$div$colon(this, b, function2);
        }

        @Override
        public <B> B foldLeft(B b, Function2<B, Seq<B>, B> function2) {
            return (B)TraversableOnce$class.foldLeft(this, b, function2);
        }

        @Override
        public <B> B foldRight(B b, Function2<Seq<B>, B, B> function2) {
            return (B)TraversableOnce$class.foldRight(this, b, function2);
        }

        @Override
        public <B> B reduceLeft(Function2<B, Seq<B>, B> function2) {
            return (B)TraversableOnce$class.reduceLeft(this, function2);
        }

        @Override
        public <B> B reduceRight(Function2<Seq<B>, B, B> function2) {
            return (B)TraversableOnce$class.reduceRight(this, function2);
        }

        @Override
        public <B> Option<B> reduceLeftOption(Function2<B, Seq<B>, B> function2) {
            return TraversableOnce$class.reduceLeftOption(this, function2);
        }

        @Override
        public <A1> A1 fold(A1 A1, Function2<A1, A1, A1> function2) {
            return (A1)TraversableOnce$class.fold(this, A1, function2);
        }

        @Override
        public <B> B sum(Numeric<B> numeric) {
            return (B)TraversableOnce$class.sum(this, numeric);
        }

        @Override
        public <B> void copyToBuffer(Buffer<B> buffer) {
            TraversableOnce$class.copyToBuffer(this, buffer);
        }

        @Override
        public <B> void copyToArray(Object object, int n) {
            TraversableOnce$class.copyToArray(this, object, n);
        }

        @Override
        public <B> void copyToArray(Object object) {
            TraversableOnce$class.copyToArray(this, object);
        }

        @Override
        public <B> Object toArray(ClassManifest<B> classManifest) {
            return TraversableOnce$class.toArray(this, classManifest);
        }

        @Override
        public List<Seq<B>> toList() {
            return TraversableOnce$class.toList(this);
        }

        @Override
        public Iterable<Seq<B>> toIterable() {
            return TraversableOnce$class.toIterable(this);
        }

        @Override
        public Seq<Seq<B>> toSeq() {
            return TraversableOnce$class.toSeq(this);
        }

        @Override
        public <B> IndexedSeq<B> toIndexedSeq() {
            return TraversableOnce$class.toIndexedSeq(this);
        }

        @Override
        public <B> Buffer<B> toBuffer() {
            return TraversableOnce$class.toBuffer(this);
        }

        @Override
        public <B> Set<B> toSet() {
            return TraversableOnce$class.toSet(this);
        }

        @Override
        public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Seq<B>, Tuple2<T, U>> less2) {
            return TraversableOnce$class.toMap(this, less2);
        }

        @Override
        public String mkString(String string, String string2, String string3) {
            return TraversableOnce$class.mkString(this, string, string2, string3);
        }

        @Override
        public String mkString(String string) {
            return TraversableOnce$class.mkString(this, string);
        }

        @Override
        public String mkString() {
            return TraversableOnce$class.mkString(this);
        }

        @Override
        public StringBuilder addString(StringBuilder stringBuilder, String string, String string2, String string3) {
            return TraversableOnce$class.addString(this, stringBuilder, string, string2, string3);
        }

        @Override
        public StringBuilder addString(StringBuilder stringBuilder, String string) {
            return TraversableOnce$class.addString(this, stringBuilder, string);
        }

        private Seq<A> takeDestructively(int n) {
            ArrayBuffer arrayBuffer = new ArrayBuffer();
            for (int i = 0; this.self.hasNext() && i < n; ++i) {
                arrayBuffer.$plus$eq(this.self.next());
            }
            return arrayBuffer;
        }

        private List<B> padding(int n) {
            return (List)List$.MODULE$.fill(n, new Serializable(this){
                public static final long serialVersionUID;
                private final GroupedIterator $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final B apply() {
                    return this.$outer.scala$collection$Iterator$GroupedIterator$$pad.get().apply();
                }
                {
                    if (groupedIterator == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = groupedIterator;
                }
            });
        }

        private int gap() {
            return Predef$.MODULE$.intWrapper(this.scala$collection$Iterator$GroupedIterator$$step - this.scala$collection$Iterator$GroupedIterator$$size).max(0);
        }

        private boolean go(int n) {
            Seq seq;
            int n2;
            IntRef intRef = new IntRef(0);
            BooleanRef booleanRef = new BooleanRef(false);
            VolatileIntRef volatileIntRef = new VolatileIntRef(0);
            int n3 = this.buffer.size();
            Seq seq2 = this.takeDestructively(n);
            Seq seq3 = this.scala$collection$Iterator$GroupedIterator$$pad.isDefined() && !this.self.hasNext() ? ((n2 = n - seq2.length()) > 0 ? seq2.$plus$plus(this.padding(n2), Seq$.MODULE$.canBuildFrom()) : seq2) : (seq = seq2);
            return seq.isEmpty() ? false : (this._partial ? this.deliver$1(Predef$.MODULE$.intWrapper(this.len$3(seq, intRef, volatileIntRef)).min(this.scala$collection$Iterator$GroupedIterator$$size), n3, seq, intRef, volatileIntRef) : (this.incomplete$1(n, seq, intRef, booleanRef, volatileIntRef) ? false : (this.isFirst$1(n3) ? this.deliver$1(this.len$3(seq, intRef, volatileIntRef), n3, seq, intRef, volatileIntRef) : this.deliver$1(Predef$.MODULE$.intWrapper(this.scala$collection$Iterator$GroupedIterator$$step).min(this.scala$collection$Iterator$GroupedIterator$$size), n3, seq, intRef, volatileIntRef))));
        }

        private boolean fill() {
            return this.self.hasNext() ? (this.buffer.isEmpty() ? this.go(this.scala$collection$Iterator$GroupedIterator$$size) : this.go(this.scala$collection$Iterator$GroupedIterator$$step)) : false;
        }

        @Override
        public boolean hasNext() {
            return this.filled || this.fill();
        }

        @Override
        public List<B> next() {
            if (!this.filled) {
                this.fill();
            }
            if (this.filled) {
                this.filled = false;
                return this.buffer.toList();
            }
            throw new NoSuchElementException("next on empty iterator");
        }

        private final boolean isFirst$1(int n) {
            return n == 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final int len$3(Seq seq, IntRef intRef, VolatileIntRef volatileIntRef) {
            if ((volatileIntRef.elem & 1) != 0) return intRef.elem;
            GroupedIterator groupedIterator = this;
            synchronized (groupedIterator) {
                if ((volatileIntRef.elem & 1) == 0) {
                    intRef.elem = seq.length();
                    volatileIntRef.elem |= 1;
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return intRef.elem;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean incomplete$1(int n, Seq seq, IntRef intRef, BooleanRef booleanRef, VolatileIntRef volatileIntRef) {
            if ((volatileIntRef.elem & 2) != 0) return booleanRef.elem;
            GroupedIterator groupedIterator = this;
            synchronized (groupedIterator) {
                if ((volatileIntRef.elem & 2) == 0) {
                    booleanRef.elem = this.len$3(seq, intRef, volatileIntRef) < n;
                    volatileIntRef.elem |= 2;
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return booleanRef.elem;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean deliver$1(int n, int n2, Seq seq, IntRef intRef, VolatileIntRef volatileIntRef) {
            if (n <= 0) return false;
            if (!this.isFirst$1(n2)) {
                if (this.len$3(seq, intRef, volatileIntRef) <= this.gap()) return false;
            }
            if (!this.isFirst$1(n2)) {
                this.buffer.trimStart(Predef$.MODULE$.intWrapper(this.scala$collection$Iterator$GroupedIterator$$step).min(n2));
            }
            int n3 = this.isFirst$1(n2) ? this.len$3(seq, intRef, volatileIntRef) : Predef$.MODULE$.intWrapper(n).min(this.len$3(seq, intRef, volatileIntRef) - this.gap());
            this.buffer.$plus$plus$eq((TraversableOnce)seq.takeRight(n3));
            this.filled = true;
            if (!true) return false;
            return true;
        }

        public GroupedIterator(Iterator<A> iterator2, Iterator<A> iterator3, int n, int n2) {
            this.self = iterator3;
            this.scala$collection$Iterator$GroupedIterator$$size = n;
            this.scala$collection$Iterator$GroupedIterator$$step = n2;
            if (iterator2 == null) {
                throw new NullPointerException();
            }
            this.$outer = iterator2;
            GenTraversableOnce$class.$init$(this);
            TraversableOnce$class.$init$(this);
            Iterator$class.$init$(this);
            Predef$.MODULE$.require(n >= 1 && n2 >= 1, (Function0<Object>)((Object)new Serializable(this){
                public static final long serialVersionUID;
                public final GroupedIterator $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("size=%d and step=%d, but both must be positive").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.scala$collection$Iterator$GroupedIterator$$size), BoxesRunTime.boxToInteger(this.$outer.scala$collection$Iterator$GroupedIterator$$step)}));
                }
                {
                    if (groupedIterator == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = groupedIterator;
                }
            }));
            this.buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
            this.filled = false;
            this._partial = true;
            this.scala$collection$Iterator$GroupedIterator$$pad = None$.MODULE$;
        }
    }
}

