/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.GenTraversableOnce$class;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Iterator$class;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.HashTable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassManifest;
import scala.runtime.BoxesRunTime;

public abstract class FlatHashTable$class {
    public static int capacity(FlatHashTable flatHashTable, int n) {
        return n == 0 ? 1 : HashTable$.MODULE$.powerOfTwo(n);
    }

    private static int initialCapacity(FlatHashTable flatHashTable) {
        return flatHashTable.capacity(FlatHashTable$.MODULE$.initialSize());
    }

    public static boolean containsEntry(FlatHashTable flatHashTable, Object object) {
        int n = flatHashTable.index(flatHashTable.elemHashCode(object));
        Object object2 = flatHashTable.table()[n];
        Object object3;
        Object object4;
        while (object2 != null && !((object4 = object2) == (object3 = object) ? true : (object4 == null ? false : (object4 instanceof Number ? BoxesRunTime.equalsNumObject((Number)object4, object3) : (object4 instanceof Character ? BoxesRunTime.equalsCharObject((Character)object4, object3) : object4.equals(object3)))))) {
            n = (n + 1) % flatHashTable.table().length;
            object2 = flatHashTable.table()[n];
        }
        return object2 != null;
    }

    public static boolean addEntry(FlatHashTable flatHashTable, Object object) {
        int n = flatHashTable.index(flatHashTable.elemHashCode(object));
        Object object2 = flatHashTable.table()[n];
        while (true) {
            if (object2 == null) {
                flatHashTable.table()[n] = object;
                flatHashTable.tableSize_$eq(flatHashTable.tableSize() + 1);
                flatHashTable.nnSizeMapAdd(n);
                if (flatHashTable.tableSize() >= flatHashTable.threshold()) {
                    FlatHashTable$class.growTable(flatHashTable);
                }
                return true;
            }
            Object object3 = object2;
            Object object4 = object;
            if (object3 == object4 ? true : (object3 == null ? false : (object3 instanceof Number ? BoxesRunTime.equalsNumObject((Number)object3, object4) : (object3 instanceof Character ? BoxesRunTime.equalsCharObject((Character)object3, object4) : object3.equals(object4))))) {
                return false;
            }
            n = (n + 1) % flatHashTable.table().length;
            object2 = flatHashTable.table()[n];
        }
    }

    public static Option removeEntry(FlatHashTable flatHashTable, Object object) {
        int n = flatHashTable.index(flatHashTable.elemHashCode(object));
        Object object2 = flatHashTable.table()[n];
        while (object2 != null) {
            Object object3 = object2;
            Object object4 = object;
            if (object3 == object4 ? true : (object3 == null ? false : (object3 instanceof Number ? BoxesRunTime.equalsNumObject((Number)object3, object4) : (object3 instanceof Character ? BoxesRunTime.equalsCharObject((Character)object3, object4) : object3.equals(object4))))) {
                int n2 = n;
                int n3 = (n2 + 1) % flatHashTable.table().length;
                while (true) {
                    if (flatHashTable.table()[n3] == null) {
                        flatHashTable.table()[n2] = null;
                        flatHashTable.tableSize_$eq(flatHashTable.tableSize() - 1);
                        flatHashTable.nnSizeMapRemove(n2);
                        return new Some<Object>(object2);
                    }
                    int n4 = flatHashTable.index(flatHashTable.elemHashCode(flatHashTable.table()[n3]));
                    if (n4 != n3 && FlatHashTable$class.precedes$1(flatHashTable, n4, n2)) {
                        flatHashTable.table()[n2] = flatHashTable.table()[n3];
                        n2 = n3;
                    }
                    n3 = (n3 + 1) % flatHashTable.table().length;
                }
            }
            n = (n + 1) % flatHashTable.table().length;
            object2 = flatHashTable.table()[n];
        }
        return None$.MODULE$;
    }

    public static Iterator iterator(FlatHashTable flatHashTable) {
        return new Iterator<A>(flatHashTable){
            private int i;
            private final FlatHashTable $outer;

            public Iterator<A> seq() {
                return Iterator$class.seq(this);
            }

            public boolean isEmpty() {
                return Iterator$class.isEmpty(this);
            }

            public boolean isTraversableAgain() {
                return Iterator$class.isTraversableAgain(this);
            }

            public boolean hasDefiniteSize() {
                return Iterator$class.hasDefiniteSize(this);
            }

            public Iterator<A> take(int n) {
                return Iterator$class.take(this, n);
            }

            public Iterator<A> drop(int n) {
                return Iterator$class.drop(this, n);
            }

            public Iterator<A> slice(int n, int n2) {
                return Iterator$class.slice(this, n, n2);
            }

            public <B> Iterator<B> map(Function1<A, B> function1) {
                return Iterator$class.map(this, function1);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> function0) {
                return Iterator$class.$plus$plus(this, function0);
            }

            public <B> Iterator<B> flatMap(Function1<A, GenTraversableOnce<B>> function1) {
                return Iterator$class.flatMap(this, function1);
            }

            public Iterator<A> filter(Function1<A, Object> function1) {
                return Iterator$class.filter(this, function1);
            }

            public Iterator<A> withFilter(Function1<A, Object> function1) {
                return Iterator$class.withFilter(this, function1);
            }

            public <B> Iterator<B> collect(PartialFunction<A, B> partialFunction) {
                return Iterator$class.collect(this, partialFunction);
            }

            public Iterator<A> takeWhile(Function1<A, Object> function1) {
                return Iterator$class.takeWhile(this, function1);
            }

            public Iterator<A> dropWhile(Function1<A, Object> function1) {
                return Iterator$class.dropWhile(this, function1);
            }

            public <B> Object zip(Iterator<B> iterator2) {
                return Iterator$class.zip(this, iterator2);
            }

            public <U> void foreach(Function1<A, U> function1) {
                Iterator$class.foreach(this, function1);
            }

            public boolean forall(Function1<A, Object> function1) {
                return Iterator$class.forall(this, function1);
            }

            public boolean exists(Function1<A, Object> function1) {
                return Iterator$class.exists(this, function1);
            }

            public Option<A> find(Function1<A, Object> function1) {
                return Iterator$class.find(this, function1);
            }

            public int indexWhere(Function1<A, Object> function1) {
                return Iterator$class.indexWhere(this, function1);
            }

            public BufferedIterator buffered() {
                return Iterator$class.buffered(this);
            }

            public <B> Object patch(int n, Iterator<B> iterator2, int n2) {
                return Iterator$class.patch(this, n, iterator2, n2);
            }

            public <B> void copyToArray(Object object, int n, int n2) {
                Iterator$class.copyToArray(this, object, n, n2);
            }

            public Traversable<A> toTraversable() {
                return Iterator$class.toTraversable(this);
            }

            public Iterator<A> toIterator() {
                return Iterator$class.toIterator(this);
            }

            public Stream<A> toStream() {
                return Iterator$class.toStream(this);
            }

            public String toString() {
                return Iterator$class.toString(this);
            }

            public <B> void readInto(Object object, int n, int n2) {
                Iterator$class.readInto(this, object, n, n2);
            }

            public List<A> reversed() {
                return TraversableOnce$class.reversed(this);
            }

            public int size() {
                return TraversableOnce$class.size(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce$class.nonEmpty(this);
            }

            public <B> Option<B> collectFirst(PartialFunction<A, B> partialFunction) {
                return TraversableOnce$class.collectFirst(this, partialFunction);
            }

            public <B> B $div$colon(B b, Function2<B, A, B> function2) {
                return (B)TraversableOnce$class.$div$colon(this, b, function2);
            }

            public <B> B foldLeft(B b, Function2<B, A, B> function2) {
                return (B)TraversableOnce$class.foldLeft(this, b, function2);
            }

            public <B> B foldRight(B b, Function2<A, B, B> function2) {
                return (B)TraversableOnce$class.foldRight(this, b, function2);
            }

            public <B> B reduceLeft(Function2<B, A, B> function2) {
                return (B)TraversableOnce$class.reduceLeft(this, function2);
            }

            public <B> B reduceRight(Function2<A, B, B> function2) {
                return (B)TraversableOnce$class.reduceRight(this, function2);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, A, B> function2) {
                return TraversableOnce$class.reduceLeftOption(this, function2);
            }

            public <A1> A1 fold(A1 A1, Function2<A1, A1, A1> function2) {
                return (A1)TraversableOnce$class.fold(this, A1, function2);
            }

            public <B> B sum(Numeric<B> numeric) {
                return (B)TraversableOnce$class.sum(this, numeric);
            }

            public <B> void copyToBuffer(Buffer<B> buffer) {
                TraversableOnce$class.copyToBuffer(this, buffer);
            }

            public <B> void copyToArray(Object object, int n) {
                TraversableOnce$class.copyToArray(this, object, n);
            }

            public <B> void copyToArray(Object object) {
                TraversableOnce$class.copyToArray(this, object);
            }

            public <B> Object toArray(ClassManifest<B> classManifest) {
                return TraversableOnce$class.toArray(this, classManifest);
            }

            public List<A> toList() {
                return TraversableOnce$class.toList(this);
            }

            public Iterable<A> toIterable() {
                return TraversableOnce$class.toIterable(this);
            }

            public Seq<A> toSeq() {
                return TraversableOnce$class.toSeq(this);
            }

            public <B> IndexedSeq<B> toIndexedSeq() {
                return TraversableOnce$class.toIndexedSeq(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce$class.toBuffer(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce$class.toSet(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<A, Tuple2<T, U>> less2) {
                return TraversableOnce$class.toMap(this, less2);
            }

            public String mkString(String string, String string2, String string3) {
                return TraversableOnce$class.mkString(this, string, string2, string3);
            }

            public String mkString(String string) {
                return TraversableOnce$class.mkString(this, string);
            }

            public String mkString() {
                return TraversableOnce$class.mkString(this);
            }

            public StringBuilder addString(StringBuilder stringBuilder, String string, String string2, String string3) {
                return TraversableOnce$class.addString(this, stringBuilder, string, string2, string3);
            }

            public StringBuilder addString(StringBuilder stringBuilder, String string) {
                return TraversableOnce$class.addString(this, stringBuilder, string);
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                while (this.i() < this.$outer.table().length && this.$outer.table()[this.i()] == null) {
                    this.i_$eq(this.i() + 1);
                }
                return this.i() < this.$outer.table().length;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    object = this.$outer.table()[this.i() - 1];
                } else {
                    object = Iterator$.MODULE$.empty().next();
                }
                return object;
            }
            {
                if (flatHashTable == null) {
                    throw new NullPointerException();
                }
                this.$outer = flatHashTable;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.i = 0;
            }
        };
    }

    private static void growTable(FlatHashTable flatHashTable) {
        Object[] objectArray = flatHashTable.table();
        flatHashTable.table_$eq(new Object[flatHashTable.table().length * 2]);
        flatHashTable.tableSize_$eq(0);
        flatHashTable.nnSizeMapReset(flatHashTable.table().length);
        flatHashTable.threshold_$eq(FlatHashTable$.MODULE$.newThreshold(flatHashTable._loadFactor(), flatHashTable.table().length));
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            flatHashTable.addEntry(object);
        }
    }

    public static void nnSizeMapAdd(FlatHashTable flatHashTable, int n) {
        if (flatHashTable.sizemap() != null) {
            int n2 = n >> flatHashTable.sizeMapBucketBitSize();
            int[] nArray = flatHashTable.sizemap();
            nArray[n2] = nArray[n2] + 1;
        }
    }

    public static void nnSizeMapRemove(FlatHashTable flatHashTable, int n) {
        if (flatHashTable.sizemap() != null) {
            int[] nArray = flatHashTable.sizemap();
            int n2 = n >> flatHashTable.sizeMapBucketBitSize();
            nArray[n2] = nArray[n2] - 1;
        }
    }

    public static void nnSizeMapReset(FlatHashTable flatHashTable, int n) {
        if (flatHashTable.sizemap() != null) {
            int n2 = flatHashTable.calcSizeMapSize(n);
            if (flatHashTable.sizemap().length != n2) {
                flatHashTable.sizemap_$eq(new int[n2]);
            } else {
                Arrays.fill(flatHashTable.sizemap(), 0);
            }
        }
    }

    public static final int totalSizeMapBuckets(FlatHashTable flatHashTable) {
        return (flatHashTable.table().length - 1) / flatHashTable.sizeMapBucketSize() + 1;
    }

    public static int calcSizeMapSize(FlatHashTable flatHashTable, int n) {
        return (n >> flatHashTable.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit(FlatHashTable flatHashTable, int n) {
        flatHashTable.sizemap_$eq(new int[flatHashTable.calcSizeMapSize(n)]);
    }

    public static void sizeMapInitAndRebuild(FlatHashTable flatHashTable) {
        flatHashTable.sizeMapInit(flatHashTable.table().length);
        int n = flatHashTable.totalSizeMapBuckets();
        int n2 = 0;
        Object[] objectArray = flatHashTable.table();
        int n3 = Predef$.MODULE$.intWrapper(flatHashTable.sizeMapBucketSize()).min(objectArray.length);
        for (int i = 0; i < n; ++i) {
            int n4 = 0;
            while (n2 < n3) {
                if (objectArray[n2] != null) {
                    ++n4;
                }
                ++n2;
            }
            flatHashTable.sizemap()[i] = n4;
            n3 += flatHashTable.sizeMapBucketSize();
        }
    }

    public static boolean alwaysInitSizeMap(FlatHashTable flatHashTable) {
        return false;
    }

    public static final int index(FlatHashTable flatHashTable, int n) {
        int n2 = flatHashTable.improve(n);
        int n3 = flatHashTable.table().length - 1;
        return n2 >>> 32 - Integer.bitCount(n3) & n3;
    }

    public static void clearTable(FlatHashTable flatHashTable) {
        for (int i = flatHashTable.table().length - 1; i >= 0; --i) {
            flatHashTable.table()[i] = null;
        }
        flatHashTable.tableSize_$eq(0);
        flatHashTable.nnSizeMapReset(flatHashTable.table().length);
    }

    public static void initWithContents(FlatHashTable flatHashTable, FlatHashTable.Contents contents2) {
        if (contents2 != null) {
            flatHashTable._loadFactor_$eq(contents2.loadFactor());
            flatHashTable.table_$eq(contents2.table());
            flatHashTable.tableSize_$eq(contents2.tableSize());
            flatHashTable.threshold_$eq(contents2.threshold());
            flatHashTable.sizemap_$eq(contents2.sizemap());
        }
        if (flatHashTable.alwaysInitSizeMap() && flatHashTable.sizemap() == null) {
            flatHashTable.sizeMapInitAndRebuild();
        }
    }

    private static final boolean precedes$1(FlatHashTable flatHashTable, int n, int n2) {
        int n3 = flatHashTable.table().length >> 1;
        return n <= n2 ? n2 - n < n3 : n - n2 > n3;
    }

    public static void $init$(FlatHashTable flatHashTable) {
        flatHashTable._loadFactor_$eq(FlatHashTable$.MODULE$.defaultLoadFactor());
        flatHashTable.table_$eq(new Object[FlatHashTable$class.initialCapacity(flatHashTable)]);
        flatHashTable.tableSize_$eq(0);
        flatHashTable.threshold_$eq(FlatHashTable$.MODULE$.newThreshold(flatHashTable._loadFactor(), FlatHashTable$class.initialCapacity(flatHashTable)));
        flatHashTable.sizemap_$eq(null);
    }
}

