/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.GenTraversableOnce$class;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$class;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce$class;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassManifest;
import scala.runtime.BoxesRunTime;

public abstract class HashTable$class {
    public static HashEntry findEntry(HashTable hashTable, Object object) {
        int n = hashTable.index(hashTable.elemHashCode(object));
        HashEntry hashEntry = hashTable.table()[n];
        while (hashEntry != null && !hashTable.elemEquals(hashEntry.key(), object)) {
            hashEntry = (HashEntry)hashEntry.next();
        }
        return hashEntry;
    }

    public static void addEntry(HashTable hashTable, HashEntry hashEntry) {
        int n = hashTable.index(hashTable.elemHashCode(hashEntry.key()));
        hashEntry.next_$eq(hashTable.table()[n]);
        hashTable.table()[n] = hashEntry;
        hashTable.tableSize_$eq(hashTable.tableSize() + 1);
        hashTable.nnSizeMapAdd(n);
        if (hashTable.tableSize() > hashTable.threshold()) {
            HashTable$class.resize(hashTable, 2 * hashTable.table().length);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashEntry removeEntry(HashTable hashTable, Object object) {
        int n = hashTable.index(hashTable.elemHashCode(object));
        HashEntry hashEntry = hashTable.table()[n];
        if (hashEntry == null) return null;
        if (hashTable.elemEquals(hashEntry.key(), object)) {
            hashTable.table()[n] = (HashEntry)hashEntry.next();
            hashTable.tableSize_$eq(hashTable.tableSize() - 1);
            hashTable.nnSizeMapRemove(n);
            return hashEntry;
        }
        HashEntry hashEntry2 = (HashEntry)hashEntry.next();
        while (true) {
            if (hashEntry2 == null || hashTable.elemEquals(hashEntry2.key(), object)) {
                if (hashEntry2 == null) {
                    return null;
                }
                hashEntry.next_$eq(hashEntry2.next());
                hashTable.tableSize_$eq(hashTable.tableSize() - 1);
                hashTable.nnSizeMapRemove(n);
                return hashEntry2;
            }
            hashEntry = hashEntry2;
            hashEntry2 = (HashEntry)hashEntry2.next();
        }
    }

    public static Iterator entriesIterator(HashTable hashTable) {
        return new Iterator<Entry>(hashTable){
            private final HashEntry<A, Entry>[] iterTable;
            private int idx;
            private Entry es;

            public Iterator<Entry> seq() {
                return Iterator$class.seq(this);
            }

            public boolean isEmpty() {
                return Iterator$class.isEmpty(this);
            }

            public boolean isTraversableAgain() {
                return Iterator$class.isTraversableAgain(this);
            }

            public boolean hasDefiniteSize() {
                return Iterator$class.hasDefiniteSize(this);
            }

            public Iterator<Entry> take(int n) {
                return Iterator$class.take(this, n);
            }

            public Iterator<Entry> drop(int n) {
                return Iterator$class.drop(this, n);
            }

            public Iterator<Entry> slice(int n, int n2) {
                return Iterator$class.slice(this, n, n2);
            }

            public <B> Iterator<B> map(Function1<Entry, B> function1) {
                return Iterator$class.map(this, function1);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> function0) {
                return Iterator$class.$plus$plus(this, function0);
            }

            public <B> Iterator<B> flatMap(Function1<Entry, GenTraversableOnce<B>> function1) {
                return Iterator$class.flatMap(this, function1);
            }

            public Iterator<Entry> filter(Function1<Entry, Object> function1) {
                return Iterator$class.filter(this, function1);
            }

            public Iterator<Entry> withFilter(Function1<Entry, Object> function1) {
                return Iterator$class.withFilter(this, function1);
            }

            public <B> Iterator<B> collect(PartialFunction<Entry, B> partialFunction) {
                return Iterator$class.collect(this, partialFunction);
            }

            public Iterator<Entry> takeWhile(Function1<Entry, Object> function1) {
                return Iterator$class.takeWhile(this, function1);
            }

            public Iterator<Entry> dropWhile(Function1<Entry, Object> function1) {
                return Iterator$class.dropWhile(this, function1);
            }

            public <B> Object zip(Iterator<B> iterator2) {
                return Iterator$class.zip(this, iterator2);
            }

            public <U> void foreach(Function1<Entry, U> function1) {
                Iterator$class.foreach(this, function1);
            }

            public boolean forall(Function1<Entry, Object> function1) {
                return Iterator$class.forall(this, function1);
            }

            public boolean exists(Function1<Entry, Object> function1) {
                return Iterator$class.exists(this, function1);
            }

            public Option<Entry> find(Function1<Entry, Object> function1) {
                return Iterator$class.find(this, function1);
            }

            public int indexWhere(Function1<Entry, Object> function1) {
                return Iterator$class.indexWhere(this, function1);
            }

            public BufferedIterator buffered() {
                return Iterator$class.buffered(this);
            }

            public <B> Object patch(int n, Iterator<B> iterator2, int n2) {
                return Iterator$class.patch(this, n, iterator2, n2);
            }

            public <B> void copyToArray(Object object, int n, int n2) {
                Iterator$class.copyToArray(this, object, n, n2);
            }

            public Traversable<Entry> toTraversable() {
                return Iterator$class.toTraversable(this);
            }

            public Iterator<Entry> toIterator() {
                return Iterator$class.toIterator(this);
            }

            public Stream<Entry> toStream() {
                return Iterator$class.toStream(this);
            }

            public String toString() {
                return Iterator$class.toString(this);
            }

            public <B> void readInto(Object object, int n, int n2) {
                Iterator$class.readInto(this, object, n, n2);
            }

            public List<Entry> reversed() {
                return TraversableOnce$class.reversed(this);
            }

            public int size() {
                return TraversableOnce$class.size(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce$class.nonEmpty(this);
            }

            public <B> Option<B> collectFirst(PartialFunction<Entry, B> partialFunction) {
                return TraversableOnce$class.collectFirst(this, partialFunction);
            }

            public <B> B $div$colon(B b, Function2<B, Entry, B> function2) {
                return (B)TraversableOnce$class.$div$colon(this, b, function2);
            }

            public <B> B foldLeft(B b, Function2<B, Entry, B> function2) {
                return (B)TraversableOnce$class.foldLeft(this, b, function2);
            }

            public <B> B foldRight(B b, Function2<Entry, B, B> function2) {
                return (B)TraversableOnce$class.foldRight(this, b, function2);
            }

            public <B> B reduceLeft(Function2<B, Entry, B> function2) {
                return (B)TraversableOnce$class.reduceLeft(this, function2);
            }

            public <B> B reduceRight(Function2<Entry, B, B> function2) {
                return (B)TraversableOnce$class.reduceRight(this, function2);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Entry, B> function2) {
                return TraversableOnce$class.reduceLeftOption(this, function2);
            }

            public <A1> A1 fold(A1 A1, Function2<A1, A1, A1> function2) {
                return (A1)TraversableOnce$class.fold(this, A1, function2);
            }

            public <B> B sum(Numeric<B> numeric) {
                return (B)TraversableOnce$class.sum(this, numeric);
            }

            public <B> void copyToBuffer(Buffer<B> buffer) {
                TraversableOnce$class.copyToBuffer(this, buffer);
            }

            public <B> void copyToArray(Object object, int n) {
                TraversableOnce$class.copyToArray(this, object, n);
            }

            public <B> void copyToArray(Object object) {
                TraversableOnce$class.copyToArray(this, object);
            }

            public <B> Object toArray(ClassManifest<B> classManifest) {
                return TraversableOnce$class.toArray(this, classManifest);
            }

            public List<Entry> toList() {
                return TraversableOnce$class.toList(this);
            }

            public Iterable<Entry> toIterable() {
                return TraversableOnce$class.toIterable(this);
            }

            public Seq<Entry> toSeq() {
                return TraversableOnce$class.toSeq(this);
            }

            public <B> IndexedSeq<B> toIndexedSeq() {
                return TraversableOnce$class.toIndexedSeq(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce$class.toBuffer(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce$class.toSet(this);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<Entry, Tuple2<T, U>> less2) {
                return TraversableOnce$class.toMap(this, less2);
            }

            public String mkString(String string, String string2, String string3) {
                return TraversableOnce$class.mkString(this, string, string2, string3);
            }

            public String mkString(String string) {
                return TraversableOnce$class.mkString(this, string);
            }

            public String mkString() {
                return TraversableOnce$class.mkString(this);
            }

            public StringBuilder addString(StringBuilder stringBuilder, String string, String string2, String string3) {
                return TraversableOnce$class.addString(this, stringBuilder, string, string2, string3);
            }

            public StringBuilder addString(StringBuilder stringBuilder, String string) {
                return TraversableOnce$class.addString(this, stringBuilder, string);
            }

            private HashEntry<A, Entry>[] iterTable() {
                return this.iterTable;
            }

            private int idx() {
                return this.idx;
            }

            private void idx_$eq(int n) {
                this.idx = n;
            }

            private Entry es() {
                return this.es;
            }

            private void es_$eq(Entry Entry2) {
                this.es = Entry2;
            }

            public boolean hasNext() {
                return this.es() != null;
            }

            public Entry next() {
                Entry Entry2 = this.es();
                this.es_$eq((HashEntry)this.es().next());
                this.scan();
                return Entry2;
            }

            private void scan() {
                while (this.es() == null && this.idx() > 0) {
                    this.idx_$eq(this.idx() - 1);
                    this.es_$eq(this.iterTable()[this.idx()]);
                }
            }
            {
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Iterator$class.$init$(this);
                this.iterTable = hashTable.table();
                this.idx = hashTable.table().length - 1;
                this.es = this.iterTable()[this.idx()];
                this.scan();
            }
        };
    }

    public static final void foreachEntry(HashTable hashTable, Function1 function1) {
        hashTable.entriesIterator().foreach(function1);
    }

    public static void clearTable(HashTable hashTable) {
        for (int i = hashTable.table().length - 1; i >= 0; --i) {
            hashTable.table()[i] = null;
        }
        hashTable.tableSize_$eq(0);
        hashTable.nnSizeMapReset(0);
    }

    private static void resize(HashTable hashTable, int n) {
        HashEntry<A, Entry>[] hashEntryArray = hashTable.table();
        hashTable.table_$eq(new HashEntry[n]);
        hashTable.nnSizeMapReset(hashTable.table().length);
        block0: for (int i = hashEntryArray.length - 1; i >= 0; --i) {
            HashEntry hashEntry = hashEntryArray[i];
            while (true) {
                if (hashEntry == null) {
                    continue block0;
                }
                int n2 = hashTable.index(hashTable.elemHashCode(hashEntry.key()));
                HashEntry hashEntry2 = (HashEntry)hashEntry.next();
                hashEntry.next_$eq(hashTable.table()[n2]);
                hashTable.table()[n2] = hashEntry;
                hashEntry = hashEntry2;
                hashTable.nnSizeMapAdd(n2);
            }
        }
        hashTable.threshold_$eq(HashTable$.MODULE$.newThreshold(hashTable._loadFactor(), n));
    }

    public static void nnSizeMapAdd(HashTable hashTable, int n) {
        if (hashTable.sizemap() != null) {
            int[] nArray = hashTable.sizemap();
            int n2 = n >> hashTable.sizeMapBucketBitSize();
            nArray[n2] = nArray[n2] + 1;
        }
    }

    public static void nnSizeMapRemove(HashTable hashTable, int n) {
        if (hashTable.sizemap() != null) {
            int[] nArray = hashTable.sizemap();
            int n2 = n >> hashTable.sizeMapBucketBitSize();
            nArray[n2] = nArray[n2] - 1;
        }
    }

    public static void nnSizeMapReset(HashTable hashTable, int n) {
        if (hashTable.sizemap() != null) {
            int n2 = hashTable.calcSizeMapSize(n);
            if (hashTable.sizemap().length != n2) {
                hashTable.sizemap_$eq(new int[n2]);
            } else {
                Arrays.fill(hashTable.sizemap(), 0);
            }
        }
    }

    public static final int totalSizeMapBuckets(HashTable hashTable) {
        return hashTable.sizeMapBucketSize() < hashTable.table().length ? 1 : hashTable.table().length / hashTable.sizeMapBucketSize();
    }

    public static int calcSizeMapSize(HashTable hashTable, int n) {
        return (n >> hashTable.sizeMapBucketBitSize()) + 1;
    }

    public static void sizeMapInit(HashTable hashTable, int n) {
        hashTable.sizemap_$eq(new int[hashTable.calcSizeMapSize(n)]);
    }

    public static void sizeMapInitAndRebuild(HashTable hashTable) {
        hashTable.sizeMapInit(hashTable.table().length);
        int n = 0;
        HashEntry<A, Entry>[] hashEntryArray = hashTable.table();
        int n2 = hashEntryArray.length < hashTable.sizeMapBucketSize() ? hashEntryArray.length : hashTable.sizeMapBucketSize();
        int n3 = hashTable.totalSizeMapBuckets();
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            while (n < n2) {
                for (HashEntry hashEntry = hashEntryArray[n]; hashEntry != null; hashEntry = (HashEntry)hashEntry.next()) {
                    ++n4;
                }
                ++n;
            }
            hashTable.sizemap()[i] = n4;
            n2 += hashTable.sizeMapBucketSize();
        }
    }

    public static boolean alwaysInitSizeMap(HashTable hashTable) {
        return false;
    }

    public static boolean elemEquals(HashTable hashTable, Object object, Object object2) {
        Object object3 = object;
        Object object4 = object2;
        return object3 == object4 ? true : (object3 == null ? false : (object3 instanceof Number ? BoxesRunTime.equalsNumObject((Number)object3, object4) : (object3 instanceof Character ? BoxesRunTime.equalsCharObject((Character)object3, object4) : object3.equals(object4))));
    }

    public static final int index(HashTable hashTable, int n) {
        int n2 = hashTable.table().length - 1;
        int n3 = hashTable.improve(n);
        int n4 = n3 >> 32 - Integer.bitCount(n2) & n2;
        return n4;
    }

    public static void initWithContents(HashTable hashTable, HashTable.Contents contents2) {
        if (contents2 != null) {
            hashTable._loadFactor_$eq(contents2.loadFactor());
            hashTable.table_$eq(contents2.table());
            hashTable.tableSize_$eq(contents2.tableSize());
            hashTable.threshold_$eq(contents2.threshold());
            hashTable.sizemap_$eq(contents2.sizemap());
        }
        if (hashTable.alwaysInitSizeMap() && hashTable.sizemap() == null) {
            hashTable.sizeMapInitAndRebuild();
        }
    }

    public static void $init$(HashTable hashTable) {
        hashTable._loadFactor_$eq(HashTable$.MODULE$.defaultLoadFactor());
        hashTable.table_$eq(new HashEntry[HashTable$.MODULE$.initialCapacity()]);
        hashTable.tableSize_$eq(0);
        hashTable.threshold_$eq(HashTable$.MODULE$.initialThreshold(hashTable._loadFactor()));
        hashTable.sizemap_$eq(null);
    }
}

