/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.asciigrid;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.myworldgis.io.asciigrid.AsciiGridConstants;
import org.myworldgis.util.StringUtils;

public strictfp final class AsciiGridFileReader
implements AsciiGridConstants {
    private BufferedReader _in;
    private Dimension _gridSize;
    private Envelope _gridEnvelope;
    private double _nanValue;
    private String _cachedLine;

    public AsciiGridFileReader(BufferedReader in) throws IOException {
        this._in = in;
        this._nanValue = Double.NaN;
        this._cachedLine = null;
        StringTokenizer tokenizer = new StringTokenizer(this._in.readLine());
        try {
            int columnCount = 0;
            if (!StringUtils.startsWithIgnoreCase(tokenizer.nextToken(), "NCOLS")) {
                throw new IOException("invalid column count marker on line 1");
            }
            columnCount = Integer.parseInt(tokenizer.nextToken());
            tokenizer = new StringTokenizer(this._in.readLine());
            int rowCount = 0;
            if (!StringUtils.startsWithIgnoreCase(tokenizer.nextToken(), "NROWS")) {
                throw new IOException("invalid row count marker on line 2");
            }
            rowCount = Integer.parseInt(tokenizer.nextToken());
            this._gridSize = new Dimension(columnCount, rowCount);
            tokenizer = new StringTokenizer(this._in.readLine());
            double originX = 0.0;
            if (!StringUtils.startsWithIgnoreCase(tokenizer.nextToken(), "XLLCORNER")) {
                throw new IOException("invalid corner x on line 3");
            }
            originX = Double.parseDouble(tokenizer.nextToken());
            tokenizer = new StringTokenizer(this._in.readLine());
            double originY = 0.0;
            if (!StringUtils.startsWithIgnoreCase(tokenizer.nextToken(), "YLLCORNER")) {
                throw new IOException("invalid corner y on line 4");
            }
            originY = Double.parseDouble(tokenizer.nextToken());
            tokenizer = new StringTokenizer(this._in.readLine());
            double cellSize = 0.0;
            if (!StringUtils.startsWithIgnoreCase(tokenizer.nextToken(), "CELLSIZE")) {
                throw new IOException("invalid cell size on line 5");
            }
            cellSize = Double.parseDouble(tokenizer.nextToken());
            this._gridEnvelope = new Envelope(originX, originX + cellSize * (double)columnCount, originY, originY + cellSize * (double)rowCount);
            String lastLine = this._in.readLine();
            tokenizer = new StringTokenizer(lastLine);
            if (StringUtils.startsWithIgnoreCase(tokenizer.nextToken(), "NODATA_VALUE")) {
                if (tokenizer.hasMoreTokens()) {
                    this._nanValue = Double.parseDouble(tokenizer.nextToken());
                }
            } else {
                this._cachedLine = lastLine;
            }
        }
        catch (NumberFormatException e) {
            IOException ex = new IOException("error parsing number");
            ex.initCause(e);
            throw ex;
        }
    }

    public Dimension getSize() {
        return this._gridSize;
    }

    public Envelope getEnvelope() {
        return this._gridEnvelope;
    }

    public double getNaNValue() {
        return this._nanValue;
    }

    public DataBuffer getData() throws IOException {
        int size = this._gridSize.width * this._gridSize.height;
        DataBufferDouble result = new DataBufferDouble(size);
        int index = 0;
        block2: do {
            String line;
            if (this._cachedLine != null) {
                line = this._cachedLine;
                this._cachedLine = null;
            } else {
                line = this._in.readLine();
            }
            if (line == null) break;
            StringTokenizer tokens = new StringTokenizer(line);
            while (tokens.hasMoreTokens()) {
                double value = Double.NaN;
                String token = tokens.nextToken();
                if (token.length() > 0) {
                    try {
                        Number n = VALUE_FORMAT.parse(token);
                        if (n != null && n.doubleValue() != this._nanValue) {
                            value = n.doubleValue();
                        }
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                result.setElemDouble(index++, value);
                if (index < size) continue;
                continue block2;
            }
        } while (index < size);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this._in.close();
        }
        finally {
            this._in = null;
        }
    }
}

