/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.io.InputStream;
import org.myworldgis.io.shapefile.ESRIShapeBuffer;
import org.myworldgis.io.shapefile.ESRIShapeConstants;
import org.myworldgis.util.Buffer;
import org.ngs.ngunits.UnitConverter;

public strictfp final class ESRIShapefileReader
implements ESRIShapeConstants {
    private InputStream _in;
    private ESRIShapeBuffer _buffer;
    private Envelope _envelope;
    private int _shapeType;
    private int _fileSizeBytes;

    public ESRIShapefileReader(InputStream in, UnitConverter inputConverter, GeometryFactory factory) throws IOException {
        this._in = in;
        this._buffer = new ESRIShapeBuffer(50000, inputConverter, factory);
        this._buffer.read(this._in, 0, 100);
        this._envelope = this._buffer.getBoundingBox(36);
        this._shapeType = this._buffer.getInt(32);
        this._buffer.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        this._fileSizeBytes = this._buffer.getInt(24) * 2;
        this._buffer.setByteOrder(Buffer.ByteOrder.LITTLE_ENDIAN);
    }

    public Envelope getEnvelope() {
        return this._envelope;
    }

    public int getShapeType() {
        return this._shapeType;
    }

    public int getSizeBytes() {
        return this._fileSizeBytes;
    }

    public Geometry getNextShape() throws IOException {
        int bytesRead = this._buffer.read(this._in, 0, 8);
        if (bytesRead < 8) {
            return null;
        }
        this._buffer.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        int contentByteLength = this._buffer.getInt(4) * 2;
        this._buffer.ensureCapacity(8 + contentByteLength);
        this._buffer.setByteOrder(Buffer.ByteOrder.LITTLE_ENDIAN);
        this._buffer.read(this._in, 8, contentByteLength);
        return this._buffer.getESRIRecord(0);
    }

    public void close() throws IOException {
        this._in.close();
    }
}

