/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.image.WritableRaster;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.RasterDataset;
import org.nlogo.api.AgentException;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.Patch;
import org.nlogo.api.Syntax;
import org.nlogo.api.World;
import org.nlogo.prim._reference;

public strictfp class ApplyRaster
extends GISExtension.Command {
    public String getAgentClassString() {
        return "O";
    }

    public Syntax getSyntax() {
        return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.ReferenceType()});
    }

    public void performInternal(Argument[] args, Context context) throws AgentException, ExtensionException, LogoException {
        RasterDataset dataset = RasterDataset.getDataset(args[0]);
        World world = context.getAgent().world();
        _reference patchVar = (_reference)((org.nlogo.nvm.Argument)args[1]).getReporter();
        Envelope gisEnvelope = GISExtension.getState().getTransformation().getEnvelope(world);
        Dimension gridSize = new Dimension(world.worldWidth(), world.worldHeight());
        RasterDataset resampledDataset = dataset.resample(new GridDimensions(gridSize, gisEnvelope));
        WritableRaster raster = resampledDataset.getRaster();
        int px = world.minPxcor();
        int ix = 0;
        while (px <= world.maxPxcor()) {
            int py = world.minPycor();
            int iy = raster.getHeight() - 1;
            while (py <= world.maxPycor()) {
                Patch p = world.fastGetPatchAt(px, py);
                p.setVariable(patchVar.reference.vn(), (Object)raster.getSampleDouble(ix, iy, 0));
                ++py;
                --iy;
            }
            ++px;
            ++ix;
        }
    }
}

