/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.Arrays;
import java.util.Iterator;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorDataset;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.Link;
import org.nlogo.api.LogoException;
import org.nlogo.api.Syntax;
import org.nlogo.api.World;

public strictfp final class LinkDataset
extends GISExtension.Reporter {
    public String getAgentClassString() {
        return "OTPL";
    }

    public Syntax getSyntax() {
        return Syntax.reporterSyntax((int[])new int[]{Syntax.LinksetType()}, (int)Syntax.WildcardType());
    }

    public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
        int i;
        World world = context.getAgent().world();
        AgentSet links = (AgentSet)args[0].get();
        AgentSet breed = null;
        for (Link l : links.agents()) {
            if (breed == null) {
                breed = l.getBreed();
                continue;
            }
            if (l.getBreed() == breed) continue;
            breed = world.links();
            break;
        }
        int allLinksVarCount = world.getVariablesArraySize((Link)null, world.links());
        int breedVarCount = world.getVariablesArraySize((Link)null, breed);
        String[] variableNames = new String[breedVarCount];
        for (i = 0; i < allLinksVarCount; ++i) {
            variableNames[i] = world.linksOwnNameAt(i);
        }
        for (i = allLinksVarCount; i < breedVarCount; ++i) {
            variableNames[i] = world.breedsOwnNameAt(breed, i);
        }
        VectorDataset.PropertyType[] variableTypes = new VectorDataset.PropertyType[breedVarCount];
        Arrays.fill((Object[])variableTypes, (Object)VectorDataset.PropertyType.NUMBER);
        block3: for (int i2 = 0; i2 < variableTypes.length; ++i2) {
            Iterator j = links.agents().iterator();
            while (j.hasNext()) {
                Object value = ((Agent)j.next()).getVariable(i2);
                if (value == null || value instanceof Number) continue;
                variableTypes[i2] = VectorDataset.PropertyType.STRING;
                continue block3;
            }
        }
        VectorDataset result = new VectorDataset(VectorDataset.ShapeType.LINE, variableNames, variableTypes);
        for (Link l : links.agents()) {
            Object[] data = new Object[variableNames.length];
            for (int j = 0; j < variableNames.length; ++j) {
                Object value = l.getVariable(j);
                if (value instanceof AgentSet) {
                    value = ((AgentSet)value).printName().toLowerCase();
                } else if (value != null && !(value instanceof Number) && !(value instanceof String)) {
                    value = value.toString();
                }
                data[j] = value;
            }
            Coordinate start = new Coordinate(l.end1().xcor(), l.end1().ycor());
            start = GISExtension.getState().netLogoToGIS(start, start);
            Coordinate end = new Coordinate(l.end2().xcor(), l.end2().ycor());
            end = GISExtension.getState().netLogoToGIS(end, end);
            GeometryFactory f = GISExtension.getState().factory();
            LineString ls = f.createLineString(new Coordinate[]{start, end});
            MultiLineString geom = f.createMultiLineString(new LineString[]{ls});
            result.add((Geometry)geom, data);
        }
        return result;
    }
}

