/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import org.myworldgis.io.asciigrid.AsciiGridFileReader;
import org.myworldgis.io.shapefile.DBaseFileReader;
import org.myworldgis.io.shapefile.ESRIShapefileReader;
import org.myworldgis.netlogo.CoordinateTransformation;
import org.myworldgis.netlogo.Dataset;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.RasterDataset;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionFormat;
import org.myworldgis.util.StringUtils;
import org.ngs.ngunits.converter.AbstractUnitConverter;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.File;
import org.nlogo.api.LogoException;
import org.nlogo.api.Syntax;
import org.nlogo.api.World;

public strictfp final class LoadDataset
extends GISExtension.Reporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dataset loadShapefile(String shpFilePath, Projection srcProj, Projection dstProj) throws ExtensionException, IOException {
        GeometryTransformer inverse = null;
        GeometryTransformer forward = null;
        boolean reproject = false;
        if (srcProj != null && dstProj != null && !srcProj.equals(dstProj)) {
            inverse = srcProj.getInverseTransformer();
            forward = dstProj.getForwardTransformer();
            reproject = true;
        }
        ESRIShapefileReader shp = null;
        DBaseFileReader dbf = null;
        try {
            Geometry shape;
            File shpFile = GISExtension.getState().getFile(shpFilePath);
            if (shpFile == null) {
                throw new ExtensionException("shapefile " + shpFilePath + " not found");
            }
            shp = new ESRIShapefileReader(shpFile.getInputStream(), AbstractUnitConverter.IDENTITY, GISExtension.getState().factory());
            String dbfFilePath = StringUtils.changeFileExtension(shpFilePath, "dbf");
            File dbfFile = GISExtension.getState().getFile(dbfFilePath);
            if (dbfFile == null) {
                throw new ExtensionException("dbf file " + dbfFilePath + " not found");
            }
            dbf = new DBaseFileReader(dbfFile.getInputStream());
            VectorDataset.ShapeType shapeType = null;
            switch (shp.getShapeType()) {
                case 1: 
                case 8: {
                    shapeType = VectorDataset.ShapeType.POINT;
                    break;
                }
                case 3: {
                    shapeType = VectorDataset.ShapeType.LINE;
                    break;
                }
                case 5: {
                    shapeType = VectorDataset.ShapeType.POLYGON;
                    break;
                }
                default: {
                    throw new IOException("unsupported shape type " + shp.getShapeType());
                }
            }
            String[] propertyNames = new String[dbf.getFieldCount()];
            VectorDataset.PropertyType[] propertyTypes = new VectorDataset.PropertyType[propertyNames.length];
            for (int i = 0; i < dbf.getFieldCount(); ++i) {
                propertyNames[i] = dbf.getFieldName(i);
                propertyTypes[i] = dbf.getFieldDataType(i) == Syntax.NumberType() ? VectorDataset.PropertyType.NUMBER : VectorDataset.PropertyType.STRING;
            }
            VectorDataset result = new VectorDataset(shapeType, propertyNames, propertyTypes);
            while ((shape = shp.getNextShape()) != null) {
                if (reproject) {
                    shape = forward.transform(inverse.transform(shape));
                }
                result.add(shape, dbf.getNextRecord());
            }
            VectorDataset vectorDataset = result;
            return vectorDataset;
        }
        finally {
            if (shp != null) {
                try {
                    shp.close();
                }
                catch (IOException e) {}
            }
            if (dbf != null) {
                try {
                    dbf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RasterDataset loadAsciiGrid(String ascFilePath, Projection srcProj, Projection dstProj) throws ExtensionException, IOException {
        AsciiGridFileReader asc = null;
        try {
            File ascFile = GISExtension.getState().getFile(ascFilePath);
            if (ascFile == null) {
                throw new ExtensionException("ascii file " + ascFilePath + " not found");
            }
            asc = new AsciiGridFileReader(new BufferedReader(new InputStreamReader(ascFile.getInputStream())));
            GridDimensions dimensions = new GridDimensions(asc.getSize(), asc.getEnvelope());
            DataBuffer data = asc.getData();
            BandedSampleModel sampleModel = new BandedSampleModel(data.getDataType(), dimensions.getGridWidth(), dimensions.getGridHeight(), 1);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, data, null);
            if (srcProj != null && dstProj != null && !srcProj.equals(dstProj)) {
                RasterDataset rasterDataset = new RasterDataset(raster, dimensions, srcProj, dstProj);
                return rasterDataset;
            }
            RasterDataset rasterDataset = new RasterDataset(dimensions, raster);
            return rasterDataset;
        }
        finally {
            if (asc != null) {
                try {
                    asc.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getAgentClassString() {
        return "OTPL";
    }

    public Syntax getSyntax() {
        return Syntax.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.WildcardType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reportInternal(Argument[] args, Context context) throws ExtensionException, IOException, LogoException, ParseException {
        String dataFilePath = args[0].getString();
        Projection netLogoProjection = GISExtension.getState().getProjection();
        Projection datasetProjection = null;
        File prjFile = GISExtension.getState().getFile(StringUtils.changeFileExtension(dataFilePath, "prj"));
        if (prjFile != null) {
            BufferedReader prjReader = new BufferedReader(new InputStreamReader(prjFile.getInputStream()));
            try {
                datasetProjection = ProjectionFormat.getInstance().parseProjection(prjReader);
            }
            finally {
                prjReader.close();
            }
        }
        String extension = StringUtils.getFileExtension(dataFilePath);
        Dataset result = null;
        if (extension.equalsIgnoreCase("shp")) {
            result = LoadDataset.loadShapefile(dataFilePath, datasetProjection, netLogoProjection);
        } else if (extension.equalsIgnoreCase("asc") || extension.equalsIgnoreCase("grd")) {
            result = LoadDataset.loadAsciiGrid(dataFilePath, datasetProjection, netLogoProjection);
        } else {
            throw new ExtensionException("unsupported file type " + extension);
        }
        if (!GISExtension.getState().isTransformationSet()) {
            World w = context.getAgent().world();
            GISExtension.getState().setTransformation(new CoordinateTransformation(result.getEnvelope(), new Envelope((double)w.minPxcor(), (double)w.maxPxcor(), (double)w.minPycor(), (double)w.maxPycor()), true));
        }
        return result;
    }
}

