/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.sun.media.jai.codec.ImageCodec;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.util.HttpClientManager;
import org.myworldgis.util.WMSUtils;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.Syntax;
import org.nlogo.api.World;
import org.nlogo.util.Utils;

public class LoadWMSImage
extends GISExtension.Command {
    public String getAgentClassString() {
        return "O";
    }

    public Syntax getSyntax() {
        return Syntax.commandSyntax((int[])new int[]{Syntax.StringType(), Syntax.StringType(), Syntax.StringType(), Syntax.NumberType()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInternal(Argument[] args, Context context) throws ExtensionException, IOException, LogoException {
        RenderedImage image;
        BufferedImage drawing;
        int transparency;
        block17: {
            String serverURL = args[0].getString();
            String srs = args[1].getString();
            String layers = args[2].getString();
            transparency = args[3].getIntValue();
            if (transparency < 0 || transparency > 255) {
                throw new ExtensionException("transparency must be between 0 and 255");
            }
            drawing = context.getDrawing();
            World world = context.getAgent().world();
            Envelope viewBounds = GISExtension.getState().getTransformation().getEnvelope(world);
            Dimension pixelBounds = new Dimension(drawing.getWidth(), drawing.getHeight());
            String url = WMSUtils.makeGetMapURL(serverURL, viewBounds, pixelBounds, srs, layers, WMSUtils.ImageFormat.JPEG);
            GetMethod method = new GetMethod(url);
            image = null;
            try {
                int statusCode = HttpClientManager.getInstance().execute((HttpMethod)method);
                if (statusCode != 200) {
                    throw new IOException(HttpClientManager.errorMsg(statusCode, url));
                }
                PushbackInputStream in = new PushbackInputStream(method.getResponseBodyAsStream(), 12);
                byte[] beginning = new byte[12];
                int bytesRead = in.read(beginning, 0, 12);
                in.unread(beginning, 0, bytesRead);
                if (bytesRead < 12) {
                    throw new ExtensionException(Utils.reader2String((Reader)new InputStreamReader(in)));
                }
                if ("JFIF".equals(new String(beginning, 6, 4))) {
                    image = ImageCodec.createImageDecoder((String)"JPEG", (InputStream)in, null).decodeAsRenderedImage();
                    break block17;
                }
                if ("PNG".equals(new String(beginning, 1, 3))) {
                    image = ImageCodec.createImageDecoder((String)"PNG", (InputStream)in, null).decodeAsRenderedImage();
                    break block17;
                }
                throw new ExtensionException(Utils.reader2String((Reader)new InputStreamReader(in)));
            }
            finally {
                method.releaseConnection();
            }
        }
        if (transparency > 0) {
            int alpha = 255 - transparency;
            int width = image.getWidth();
            int height = image.getHeight();
            BufferedImage tImg = new BufferedImage(width, height, 2);
            Graphics2D g = tImg.createGraphics();
            try {
                g.drawRenderedImage(image, new AffineTransform());
            }
            finally {
                g.dispose();
            }
            WritableRaster alphaRaster = tImg.getAlphaRaster();
            int[] pixel = new int[]{alpha};
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    alphaRaster.setPixel(x, y, pixel);
                }
            }
            image = tImg;
        }
        Graphics2D g = (Graphics2D)drawing.getGraphics();
        try {
            g.drawRenderedImage(image, new AffineTransform());
        }
        finally {
            g.dispose();
        }
    }
}

