/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.RasterDataset;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.Patch;
import org.nlogo.api.Syntax;
import org.nlogo.api.World;
import org.nlogo.prim._reference;

public strictfp final class PatchDataset
extends GISExtension.Reporter {
    public String getAgentClassString() {
        return "O";
    }

    public Syntax getSyntax() {
        return Syntax.reporterSyntax((int[])new int[]{Syntax.ReferenceType()}, (int)Syntax.WildcardType());
    }

    public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
        _reference patchVar = (_reference)((org.nlogo.nvm.Argument)args[0]).getReporter();
        World world = context.getAgent().world();
        int width = world.worldWidth();
        int height = world.worldHeight();
        Envelope envelope = GISExtension.getState().getTransformation().getEnvelope(world);
        GridDimensions dimensions = new GridDimensions(new Dimension(width, height), envelope);
        DataBufferDouble data = new DataBufferDouble(width * height);
        BandedSampleModel sampleModel = new BandedSampleModel(data.getDataType(), width, height, 1);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, data, null);
        int px = world.minPxcor();
        int ix = 0;
        while (px <= world.maxPxcor()) {
            int py = world.minPycor();
            int iy = raster.getHeight() - 1;
            while (py <= world.maxPycor()) {
                Patch p = world.fastGetPatchAt(px, py);
                Object value = p.getVariable(patchVar.reference.vn());
                if (value instanceof Number) {
                    raster.setSample(ix, iy, 0, ((Number)value).doubleValue());
                } else {
                    raster.setSample(ix, iy, 0, Double.NaN);
                }
                ++py;
                --iy;
            }
            ++px;
            ++ix;
        }
        return new RasterDataset(dimensions, raster);
    }
}

