/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.text.ParseException;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import org.myworldgis.netlogo.Dataset;
import org.myworldgis.netlogo.EnvelopeLogoListFormat;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.projection.Projection;
import org.myworldgis.util.RasterUtils;
import org.myworldgis.util.ValueColorModel;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.Syntax;

public class RasterDataset
extends Dataset {
    private GridDimensions _dimensions;
    private WritableRaster _raster;
    private Interpolation _interpolation;
    private double[][] _interpArray;

    static RasterDataset getDataset(Argument arg) throws ExtensionException, LogoException {
        Object obj = arg.get();
        if (obj instanceof RasterDataset) {
            return (RasterDataset)obj;
        }
        throw new ExtensionException("not a RasterDataset: " + obj);
    }

    static RenderedImage createRendering(RenderedOp op, ColorModel cm) {
        WritableRaster wr = op.copyData();
        TiledImage ti = new TiledImage(wr.getMinX(), wr.getMinY(), wr.getWidth(), wr.getHeight(), 0, 0, cm.createCompatibleSampleModel(wr.getWidth(), wr.getHeight()), cm);
        ti.setData((Raster)wr);
        return ti;
    }

    public RasterDataset(GridDimensions dimensions, WritableRaster raster) {
        super("RASTER");
        this._dimensions = dimensions;
        this._raster = raster;
        this._interpolation = Interpolation.getInstance((int)0);
        this._interpArray = new double[this._interpolation.getHeight()][this._interpolation.getWidth()];
        GISExtension.getState().datasetLoadNotify();
    }

    public RasterDataset(WritableRaster raster, GridDimensions srcDimensions, Projection srcProj, Projection dstProj) {
        super("RASTER");
        GeometryFactory factory = GISExtension.getState().factory();
        GeometryTransformer srcToGeog = srcProj.getInverseTransformer();
        GeometryTransformer geogToDst = dstProj.getForwardTransformer();
        int minCol = Integer.MAX_VALUE;
        int maxCol = -1;
        int minRow = Integer.MAX_VALUE;
        int maxRow = -1;
        Envelope newEnvelope = new Envelope();
        for (int col = 0; col <= srcDimensions.getGridWidth(); col += 2) {
            for (int row = 0; row <= srcDimensions.getGridHeight(); row += 2) {
                Point src = factory.createPoint(new Coordinate(srcDimensions.getColumnLeft(col), srcDimensions.getRowBottom(row)));
                Point dest = (Point)geogToDst.transform(srcToGeog.transform((Geometry)src));
                if (dest.isEmpty()) continue;
                if (col < minCol) {
                    minCol = col;
                }
                if (col > maxCol) {
                    maxCol = col;
                }
                if (row < minRow) {
                    minRow = row;
                }
                if (row > maxRow) {
                    maxRow = row;
                }
                newEnvelope.expandToInclude(dest.getCoordinate());
            }
        }
        double scale = StrictMath.min((double)(maxCol - minCol) / newEnvelope.getWidth(), (double)(maxRow - minRow) / newEnvelope.getHeight());
        this._dimensions = new GridDimensions(new Dimension((int)(scale * newEnvelope.getWidth()), (int)(scale * newEnvelope.getHeight())), newEnvelope);
        ValueColorModel srcCM = new ValueColorModel(raster);
        BufferedImage img = new BufferedImage(srcCM, raster, false, null);
        RenderedImage dstImage = RasterUtils.reproject(img, srcDimensions, srcProj, this._dimensions, dstProj, factory, new double[]{Double.NaN});
        this._raster = (WritableRaster)dstImage.getData();
        this._interpolation = Interpolation.getInstance((int)0);
        this._interpArray = new double[this._interpolation.getHeight()][this._interpolation.getWidth()];
        GISExtension.getState().datasetLoadNotify();
    }

    public GridDimensions getDimensions() {
        return this._dimensions;
    }

    public WritableRaster getRaster() {
        return this._raster;
    }

    public Interpolation getInterpolation() {
        return this._interpolation;
    }

    public void setInterpolation(int interpolationType) {
        this._interpolation = Interpolation.getInstance((int)interpolationType);
        this._interpArray = new double[this._interpolation.getHeight()][this._interpolation.getWidth()];
    }

    public double getValue(Coordinate gisSpLocation) {
        Coordinate gridSpLocation = this._dimensions.gisToGrid(gisSpLocation, null);
        if (Double.isNaN(gridSpLocation.x) || Double.isNaN(gridSpLocation.y)) {
            return Double.NaN;
        }
        int rx = (int)StrictMath.floor(gridSpLocation.x);
        int ry = (int)StrictMath.floor(gridSpLocation.y);
        float xfrac = (float)(gridSpLocation.x - (double)rx);
        float yfrac = (float)(gridSpLocation.y - (double)ry);
        for (int iy = 0; iy < this._interpArray.length; ++iy) {
            int ix;
            int sy = ry + iy - this._interpolation.getTopPadding();
            if (sy >= 0 && sy < this._dimensions.getGridHeight()) {
                sy = this._dimensions.getGridHeight() - sy - 1;
                for (ix = 0; ix < this._interpArray[iy].length; ++ix) {
                    int sx = rx + ix - this._interpolation.getLeftPadding();
                    this._interpArray[iy][ix] = sx >= 0 && sx < this._dimensions.getGridWidth() ? this._raster.getSampleDouble(sx, sy, 0) : Double.NaN;
                }
                continue;
            }
            for (ix = 0; ix < this._interpArray[iy].length; ++ix) {
                this._interpArray[iy][ix] = Double.NaN;
            }
        }
        return this._interpolation.interpolate(this._interpArray, xfrac, yfrac);
    }

    public double getValue(Envelope gisSpEnvelope) {
        int maxX;
        int minX;
        int maxY;
        int minY;
        Coordinate gisBL = new Coordinate(gisSpEnvelope.getMinX(), gisSpEnvelope.getMinY());
        Coordinate gridBL = this._dimensions.gisToGrid(gisBL, gisBL);
        Coordinate gisTR = new Coordinate(gisSpEnvelope.getMaxX(), gisSpEnvelope.getMaxY());
        Coordinate gridTR = this._dimensions.gisToGrid(gisTR, gisTR);
        if (Double.isNaN(gridBL.y) && Double.isNaN(gridTR.y)) {
            return GISExtension.MISSING_VALUE;
        }
        if (Double.isNaN(gridBL.y)) {
            minY = 0;
            maxY = (int)StrictMath.ceil(gridTR.y);
        } else if (Double.isNaN(gridTR.y)) {
            minY = (int)StrictMath.floor(gridBL.y);
            maxY = this._dimensions.getGridHeight();
        } else {
            minY = (int)StrictMath.floor(gridBL.y);
            maxY = (int)StrictMath.ceil(gridTR.y);
        }
        if (Double.isNaN(gridBL.x) && Double.isNaN(gridTR.x)) {
            return GISExtension.MISSING_VALUE;
        }
        if (Double.isNaN(gridBL.x)) {
            minX = 0;
            maxX = (int)StrictMath.ceil(gridTR.x);
        } else if (Double.isNaN(gridTR.x)) {
            minX = (int)StrictMath.floor(gridBL.x);
            maxX = this._dimensions.getGridWidth();
        } else {
            minX = (int)StrictMath.floor(gridBL.x);
            maxX = (int)StrictMath.ceil(gridTR.x);
        }
        double sum = 0.0;
        int count = 0;
        for (int y = minY; y < maxY; ++y) {
            for (int x = minX; x < maxX; ++x) {
                sum += this._raster.getSampleDouble(x, this._dimensions.getGridHeight() - y - 1, 0);
                ++count;
            }
        }
        if (count > 0) {
            return sum / (double)count;
        }
        return GISExtension.MISSING_VALUE;
    }

    public RasterDataset resample(GridDimensions toDimensions) {
        if (toDimensions.equals(this._dimensions)) {
            return this;
        }
        double targetLeft = (toDimensions.getLeft() - this._dimensions.getLeft()) / this._dimensions.getCellWidth();
        double targetRight = (toDimensions.getRight() - this._dimensions.getLeft()) / this._dimensions.getCellWidth();
        double targetBottom = (toDimensions.getBottom() - this._dimensions.getBottom()) / this._dimensions.getCellHeight();
        double targetTop = (toDimensions.getTop() - this._dimensions.getBottom()) / this._dimensions.getCellHeight();
        ValueColorModel srcCM = new ValueColorModel(this._raster);
        RenderedImage srcImg = new BufferedImage(srcCM, this._raster, false, null);
        Insets border = new Insets(0, 0, 0, 0);
        BorderExtenderConstant borderExtender = new BorderExtenderConstant(new double[]{Double.NaN});
        if (targetLeft < 0.0) {
            border.left = -((int)StrictMath.floor(targetLeft));
        }
        if (targetRight > (double)this._dimensions.getGridWidth()) {
            border.right = (int)StrictMath.ceil(targetRight) - this._dimensions.getGridWidth();
        }
        if (targetBottom < 0.0) {
            border.bottom = -((int)StrictMath.floor(targetBottom));
        }
        if (targetTop > (double)this._dimensions.getGridHeight()) {
            border.top = (int)StrictMath.ceil(targetTop) - this._dimensions.getGridHeight();
        }
        if (border.left > 0 || border.right > 0 || border.bottom > 0 || border.top > 0) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(srcImg);
            pb.add((Object)border.left);
            pb.add((Object)border.right);
            pb.add((Object)border.top);
            pb.add((Object)border.bottom);
            pb.add(borderExtender);
            srcImg = RasterDataset.createRendering(JAI.create((String)"border", (ParameterBlock)pb), srcCM);
        }
        double flippedTopY = (double)(this._dimensions.getGridHeight() + border.top + border.bottom) - targetTop;
        if (targetLeft > 0.0 || targetRight < (double)this._dimensions.getGridWidth() || targetBottom > 0.0 || targetTop < (double)this._dimensions.getGridHeight()) {
            float left = Math.max((float)targetLeft, 0.0f);
            float bottom = Math.max((float)flippedTopY, 0.0f);
            float right = Math.min((float)(targetRight - targetLeft), (float)(this._dimensions.getGridWidth() - 1));
            float top = Math.min((float)(targetTop - targetBottom), (float)(this._dimensions.getGridHeight() - 1));
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(srcImg);
            pb.add(Float.valueOf(left));
            pb.add(Float.valueOf(bottom));
            pb.add(Float.valueOf(right));
            pb.add(Float.valueOf(top));
            pb.add(borderExtender);
            srcImg = RasterDataset.createRendering(JAI.create((String)"crop", (ParameterBlock)pb), srcCM);
        }
        double scaleX = (double)toDimensions.getGridWidth() / (double)srcImg.getWidth();
        double scaleY = (double)toDimensions.getGridHeight() / (double)srcImg.getHeight();
        double transX = (this._dimensions.getLeft() - toDimensions.getLeft()) / toDimensions.getCellWidth();
        double transY = (this._dimensions.getTop() - toDimensions.getBottom()) / toDimensions.getCellHeight();
        transY = (double)toDimensions.getGridHeight() - transY;
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(srcImg);
        pb.add(Float.valueOf((float)scaleX));
        pb.add(Float.valueOf((float)scaleY));
        pb.add(Float.valueOf((float)transX));
        pb.add(Float.valueOf((float)transY));
        pb.add(this._interpolation);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender);
        RenderedOp dstImg = JAI.create((String)"scale", (ParameterBlock)pb, (RenderingHints)hints);
        WritableRaster wr = ((ColorModel)srcCM).createCompatibleWritableRaster(dstImg.getWidth(), dstImg.getHeight());
        dstImg.copyData(wr);
        return new RasterDataset(toDimensions, wr);
    }

    public RasterDataset convolve(KernelJAI kernel) {
        ValueColorModel srcCM = new ValueColorModel(this._raster);
        BufferedImage srcImg = new BufferedImage(srcCM, this._raster, false, null);
        BorderExtenderConstant borderExtender = new BorderExtenderConstant(new double[]{Double.NaN});
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(srcImg);
        pb.add(kernel);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender);
        RenderedOp dstImg = JAI.create((String)"convolve", (ParameterBlock)pb, (RenderingHints)hints);
        WritableRaster wr = ((ColorModel)srcCM).createCompatibleWritableRaster(dstImg.getWidth(), dstImg.getHeight());
        dstImg.copyData(wr);
        return new RasterDataset(this._dimensions, wr);
    }

    public Envelope getEnvelope() {
        return this._dimensions.getEnvelope();
    }

    public String dump(boolean readable, boolean exporting, boolean reference) {
        return "";
    }

    public String getNLTypeName() {
        return "RasterDataset";
    }

    public boolean recursivelyEqual(Object obj) {
        if (obj instanceof VectorDataset) {
            RasterDataset rd = (RasterDataset)obj;
            return rd == this;
        }
        return false;
    }

    public strictfp static final class SetInterpolation
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType()});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void performInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object obj = args[0].get();
            if (!(obj instanceof RasterDataset)) throw new ExtensionException("not a RasterDataset: " + obj);
            RasterDataset dataset = (RasterDataset)obj;
            String newInterpolation = args[1].getString();
            if (newInterpolation.equalsIgnoreCase("NEAREST_NEIGHBOR")) {
                dataset.setInterpolation(0);
                return;
            } else if (newInterpolation.equalsIgnoreCase("BILINEAR")) {
                dataset.setInterpolation(1);
                return;
            } else if (newInterpolation.equalsIgnoreCase("BICUBIC")) {
                dataset.setInterpolation(2);
                return;
            } else {
                if (!newInterpolation.equalsIgnoreCase("BICUBIC_2")) throw new ExtensionException("Unknown interpolation type: " + Dump.logoObject((Object)newInterpolation));
                dataset.setInterpolation(3);
            }
        }
    }

    public strictfp static final class GetInterpolation
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.StringType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            Interpolation interp = RasterDataset.getDataset(args[0]).getInterpolation();
            if (interp instanceof InterpolationNearest) {
                return "NEAREST_NEIGHBOR";
            }
            if (interp instanceof InterpolationBilinear) {
                return "BILINEAR";
            }
            if (interp instanceof InterpolationBicubic) {
                return "BICUBIC";
            }
            if (interp instanceof InterpolationBicubic2) {
                return "BICUBIC_2";
            }
            throw new ExtensionException("Unknown interpolation type: " + Dump.logoObject((Object)interp));
        }
    }

    public strictfp static final class GetMaximum
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            DataBuffer buffer = RasterDataset.getDataset(args[0]).getRaster().getDataBuffer();
            double result = -1.7976931348623157E308;
            for (int i = 0; i < buffer.getSize(); ++i) {
                double d = buffer.getElemDouble(i);
                if (!(d > result) || Double.isNaN(d)) continue;
                result = d;
            }
            return result;
        }
    }

    public strictfp static final class GetMinimum
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            DataBuffer buffer = RasterDataset.getDataset(args[0]).getRaster().getDataBuffer();
            double result = Double.MAX_VALUE;
            for (int i = 0; i < buffer.getSize(); ++i) {
                double d = buffer.getElemDouble(i);
                if (!(d < result) || Double.isNaN(d)) continue;
                result = d;
            }
            return result;
        }
    }

    public strictfp static final class SetValue
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType()});
        }

        public void performInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            RasterDataset dataset = RasterDataset.getDataset(args[0]);
            int col = args[1].getIntValue();
            int row = args[2].getIntValue();
            double value = args[3].getDoubleValue();
            dataset.getRaster().setSample(col, row, 0, value);
        }
    }

    public strictfp static final class GetValue
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.NumberType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            RasterDataset dataset = RasterDataset.getDataset(args[0]);
            int col = args[1].getIntValue();
            int row = args[2].getIntValue();
            return dataset.getRaster().getSampleDouble(col, row, 0);
        }
    }

    public strictfp static final class GetWidth
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            return (double)RasterDataset.getDataset(args[0]).getDimensions().getGridWidth();
        }
    }

    public strictfp static final class GetHeight
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            return (double)RasterDataset.getDataset(args[0]).getDimensions().getGridHeight();
        }
    }

    public strictfp static final class New
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.NumberType(), Syntax.NumberType(), Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException, ParseException {
            int width = args[0].getIntValue();
            int height = args[1].getIntValue();
            Envelope envelope = EnvelopeLogoListFormat.getInstance().parse(args[2].getList());
            GridDimensions dimensions = new GridDimensions(new Dimension(width, height), envelope);
            DataBufferDouble data = new DataBufferDouble(width * height);
            BandedSampleModel sampleModel = new BandedSampleModel(data.getDataType(), width, height, 1);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, data, null);
            return new RasterDataset(dimensions, raster);
        }
    }
}

