/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.text.ParseException;
import java.util.Iterator;
import javax.media.jai.KernelJAI;
import org.myworldgis.netlogo.EnvelopeLogoListFormat;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.RasterDataset;
import org.myworldgis.netlogo.Vertex;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.Patch;
import org.nlogo.api.Syntax;
import org.nlogo.api.Turtle;
import org.nlogo.api.World;

public strictfp abstract class RasterDatasetMath {

    public strictfp static final class Convolve
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.ListType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            RasterDataset dataset = RasterDataset.getDataset(args[0]);
            int kernelRows = args[1].getIntValue();
            int kernelColumns = args[2].getIntValue();
            LogoList matrixElements = args[3].getList();
            if (matrixElements.size() != kernelRows * kernelColumns) {
                throw new ExtensionException("Convolution matrix is " + kernelRows + " by " + kernelColumns + ", so it must have exactly " + kernelRows * kernelColumns + " elements (currently has " + matrixElements.size() + ")");
            }
            float[] data = new float[matrixElements.size()];
            int row = kernelRows - 1;
            int col = 0;
            Iterator iterator = matrixElements.iterator();
            while (iterator.hasNext()) {
                data[row * kernelColumns + col] = ((Number)iterator.next()).floatValue();
                if (++col < kernelColumns) continue;
                col = 0;
                --row;
            }
            int kernelCenterRow = kernelRows - args[4].getIntValue() - 1;
            int kernelCenterColumn = args[5].getIntValue();
            KernelJAI kernel = new KernelJAI(kernelColumns, kernelRows, kernelCenterColumn, kernelCenterRow, data);
            return dataset.convolve(kernel);
        }
    }

    public strictfp static final class GetWorldEnvelope
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.ListType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            RasterDataset dataset = RasterDataset.getDataset(args[0]);
            int leftCol = args[1].getIntValue();
            int topRow = dataset.getDimensions().getGridHeight() - args[2].getIntValue() - 1;
            World world = context.getAgent().world();
            int width = world.maxPxcor() - world.minPxcor();
            int height = world.maxPycor() - world.minPycor();
            Envelope envelope = new Envelope(dataset.getDimensions().getColumnLeft(leftCol), dataset.getDimensions().getColumnRight(leftCol + width), dataset.getDimensions().getRowBottom(topRow - height), dataset.getDimensions().getRowTop(topRow));
            return EnvelopeLogoListFormat.getInstance().format(envelope);
        }
    }

    public strictfp static final class Resample
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.ListType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException, ParseException {
            RasterDataset dataset = RasterDataset.getDataset(args[0]);
            Envelope envelope = EnvelopeLogoListFormat.getInstance().parse(args[1].getList());
            int width = args[2].getIntValue();
            int height = args[3].getIntValue();
            return dataset.resample(new GridDimensions(new Dimension(width, height), envelope));
        }
    }

    public strictfp static final class GetSample
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            RasterDataset dataset = RasterDataset.getDataset(args[0]);
            Object arg1 = args[1].get();
            if (arg1 instanceof LogoList) {
                LogoList list = (LogoList)arg1;
                if (list.size() == 2) {
                    Coordinate loc = new Coordinate(((Number)list.get(0)).doubleValue(), ((Number)list.get(1)).doubleValue());
                    loc = GISExtension.getState().netLogoToGIS(loc, loc);
                    return dataset.getValue(loc);
                }
                if (list.size() == 4) {
                    return dataset.getValue(new Envelope(((Number)list.get(0)).doubleValue(), ((Number)list.get(1)).doubleValue(), ((Number)list.get(2)).doubleValue(), ((Number)list.get(3)).doubleValue()));
                }
                throw new ExtensionException("list argument must have 2 elements (for a point), or 4 elements (for an envelope)");
            }
            if (arg1 instanceof Patch) {
                Patch patch = (Patch)arg1;
                Coordinate bl = GISExtension.getState().netLogoToGIS(new Coordinate((double)patch.pxcor() - 0.5, (double)patch.pycor() - 0.5), null);
                Coordinate tr = GISExtension.getState().netLogoToGIS(new Coordinate((double)patch.pxcor() + 0.5, (double)patch.pycor() + 0.5), null);
                return dataset.getValue(new Envelope(tr, bl));
            }
            if (arg1 instanceof Turtle) {
                Turtle turtle = (Turtle)arg1;
                Coordinate loc = new Coordinate(turtle.xcor(), turtle.ycor());
                loc = GISExtension.getState().netLogoToGIS(loc, loc);
                return dataset.getValue(loc);
            }
            if (arg1 instanceof Vertex) {
                Vertex vertex = (Vertex)arg1;
                return dataset.getValue(vertex.getCoordinate());
            }
            throw new ExtensionException("not a list, patch, turtle, or Vertex: " + arg1);
        }
    }
}

