/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Iterator;
import org.myworldgis.io.asciigrid.AsciiGridFileWriter;
import org.myworldgis.io.shapefile.DBaseBuffer;
import org.myworldgis.io.shapefile.DBaseFieldDescriptor;
import org.myworldgis.io.shapefile.DBaseFileWriter;
import org.myworldgis.io.shapefile.ESRIShapeIndexRecord;
import org.myworldgis.io.shapefile.ESRIShapeIndexWriter;
import org.myworldgis.io.shapefile.ESRIShapefileWriter;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.RasterDataset;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.VectorFeature;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionFormat;
import org.myworldgis.util.StringUtils;
import org.ngs.ngunits.converter.AbstractUnitConverter;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.Syntax;

public strictfp final class StoreDataset
extends GISExtension.Command {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String storeAsciiGrid(RasterDataset dataset, String file) throws IOException {
        String ascFile = StringUtils.changeFileExtension(file, "asc");
        AsciiGridFileWriter asc = new AsciiGridFileWriter(new FileWriter(new File(ascFile)));
        try {
            GridDimensions dimensions = dataset.getDimensions();
            asc.writeGridInfo(dimensions.getGridSize(), dimensions.getEnvelope(), Double.NaN);
            asc.writeGridData(dataset.getRaster().getDataBuffer());
        }
        finally {
            asc.close();
        }
        return ascFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String storeShapefile(VectorDataset dataset, String file) throws IOException {
        String shpFile = StringUtils.changeFileExtension(file, "shp");
        String shxFile = StringUtils.changeFileExtension(file, "shx");
        String dbfFile = StringUtils.changeFileExtension(file, "dbf");
        ESRIShapefileWriter shp = new ESRIShapefileWriter(new RandomAccessFile(shpFile, "rw"), dataset.getEnvelope(), StoreDataset.esriShapeType(dataset), AbstractUnitConverter.IDENTITY, GISExtension.getState().factory());
        ESRIShapeIndexWriter shx = new ESRIShapeIndexWriter(new RandomAccessFile(shxFile, "rw"), dataset.getEnvelope(), StoreDataset.esriShapeType(dataset), AbstractUnitConverter.IDENTITY, GISExtension.getState().factory());
        DBaseFileWriter dbf = new DBaseFileWriter(new RandomAccessFile(dbfFile, "rw"), StoreDataset.dBaseFieldDescriptors(dataset));
        try {
            int recordIndex = 0;
            VectorDataset.Property[] props = dataset.getProperties();
            for (VectorFeature f : dataset.getFeatures()) {
                ESRIShapeIndexRecord indexRecord = shp.writeShape(recordIndex, f.getGeometry());
                shx.writeIndexRecord(indexRecord);
                Object[] data = new Object[props.length];
                for (int j = 0; j < props.length; ++j) {
                    data[j] = f.getProperty(props[j].getName());
                }
                dbf.writeRecord(data);
            }
        }
        finally {
            if (shp != null) {
                shp.close();
            }
            if (shx != null) {
                shx.close();
            }
            if (dbf != null) {
                dbf.close();
            }
        }
        return shpFile;
    }

    public static int esriShapeType(VectorDataset dataset) {
        switch (dataset.getShapeType()) {
            case POINT: {
                Iterator<VectorFeature> i = dataset.getFeatures().iterator();
                while (i.hasNext()) {
                    if (i.next().getGeometry().getNumPoints() == 1) continue;
                    return 8;
                }
                return 1;
            }
            case LINE: {
                return 3;
            }
            case POLYGON: {
                return 5;
            }
        }
        return 0;
    }

    private static DBaseFieldDescriptor[] dBaseFieldDescriptors(VectorDataset dataset) {
        VectorDataset.Property[] props = dataset.getProperties();
        String[] fieldNames = new String[props.length];
        char[] fieldTypes = new char[props.length];
        block8: for (int i = 0; i < props.length; ++i) {
            fieldNames[i] = props[i].getName();
            switch (props[i].getType()) {
                case STRING: {
                    fieldTypes[i] = 67;
                    continue block8;
                }
                case NUMBER: {
                    fieldTypes[i] = 78;
                    continue block8;
                }
                default: {
                    throw new RuntimeException("this can't happen");
                }
            }
        }
        fieldNames = DBaseFieldDescriptor.makeLegalFieldNames(fieldNames);
        int[] fieldLengths = new int[props.length];
        Arrays.fill(fieldLengths, 0);
        int[] fieldDecimals = new int[props.length];
        Arrays.fill(fieldDecimals, 0);
        for (VectorFeature f : dataset.getFeatures()) {
            block10: for (int j = 0; j < props.length; ++j) {
                Object value = f.getProperty(props[j].getName());
                if (value == null) continue;
                switch (props[j].getType()) {
                    case STRING: {
                        int byteLength = DBaseBuffer.getBytes(value.toString()).length;
                        fieldLengths[j] = Math.max(fieldLengths[j], byteLength);
                        fieldDecimals[j] = 0;
                        continue block10;
                    }
                    case NUMBER: {
                        String valueStr = DBaseBuffer.DECIMAL_FORMAT.format((Number)value);
                        fieldLengths[j] = Math.max(fieldLengths[j], valueStr.length());
                        int decIndex = valueStr.indexOf(46);
                        if (decIndex < 0) continue block10;
                        fieldDecimals[j] = Math.max(fieldDecimals[j], valueStr.length() - decIndex - 1);
                    }
                }
            }
        }
        DBaseFieldDescriptor[] result = new DBaseFieldDescriptor[fieldNames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new DBaseFieldDescriptor(fieldTypes[i], fieldNames[i], fieldLengths[i], fieldDecimals[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProjection(Projection projection, String prjFile) throws IOException {
        FileWriter prj = new FileWriter(new File(prjFile));
        try {
            prj.write(ProjectionFormat.getInstance().format(projection));
        }
        finally {
            prj.close();
        }
    }

    public String getAgentClassString() {
        return "OTPL";
    }

    public Syntax getSyntax() {
        return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType()});
    }

    public void performInternal(Argument[] args, Context context) throws ExtensionException, IOException, LogoException {
        Object arg0 = args[0].get();
        String fileName = args[1].getString();
        String dataFile = context.attachCurrentDirectory(fileName);
        if (arg0 instanceof RasterDataset) {
            dataFile = StoreDataset.storeAsciiGrid((RasterDataset)arg0, dataFile);
        } else if (arg0 instanceof VectorDataset) {
            dataFile = StoreDataset.storeShapefile((VectorDataset)arg0, dataFile);
        } else {
            throw new ExtensionException("not a dataset " + arg0);
        }
        String prjFile = StringUtils.changeFileExtension(dataFile, "prj");
        if (GISExtension.getState().getProjection() != null) {
            StoreDataset.storeProjection(GISExtension.getState().getProjection(), prjFile);
        }
    }
}

