/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Arrays;
import java.util.Iterator;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorDataset;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.Syntax;
import org.nlogo.api.Turtle;
import org.nlogo.api.World;

public strictfp final class TurtleDataset
extends GISExtension.Reporter {
    public String getAgentClassString() {
        return "OTPL";
    }

    public Syntax getSyntax() {
        return Syntax.reporterSyntax((int[])new int[]{Syntax.TurtlesetType()}, (int)Syntax.WildcardType());
    }

    public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
        int i;
        World world = context.getAgent().world();
        AgentSet turtles = args[0].getAgentSet();
        AgentSet breed = null;
        for (Turtle t : turtles.agents()) {
            if (breed == null) {
                breed = t.getBreed();
                continue;
            }
            if (t.getBreed() == breed) continue;
            breed = world.turtles();
            break;
        }
        int allTurtlesVarCount = world.getVariablesArraySize((Turtle)null, world.turtles());
        int breedVarCount = world.getVariablesArraySize((Turtle)null, breed);
        String[] variableNames = new String[breedVarCount];
        for (i = 0; i < allTurtlesVarCount; ++i) {
            variableNames[i] = world.turtlesOwnNameAt(i);
        }
        for (i = allTurtlesVarCount; i < breedVarCount; ++i) {
            variableNames[i] = world.breedsOwnNameAt(breed, i);
        }
        VectorDataset.PropertyType[] variableTypes = new VectorDataset.PropertyType[breedVarCount];
        Arrays.fill((Object[])variableTypes, (Object)VectorDataset.PropertyType.NUMBER);
        block3: for (int i2 = 0; i2 < variableTypes.length; ++i2) {
            Iterator j = turtles.agents().iterator();
            while (j.hasNext()) {
                Object value = ((Turtle)j.next()).getVariable(i2);
                if (value == null || value instanceof Number) continue;
                variableTypes[i2] = VectorDataset.PropertyType.STRING;
                continue block3;
            }
        }
        VectorDataset result = new VectorDataset(VectorDataset.ShapeType.POINT, variableNames, variableTypes);
        for (Turtle t : turtles.agents()) {
            Object[] data = new Object[variableNames.length];
            for (int j = 0; j < variableNames.length; ++j) {
                Object value = t.getVariable(j);
                if (value instanceof AgentSet) {
                    value = ((AgentSet)value).printName().toLowerCase();
                } else if (value != null && !(value instanceof Number) && !(value instanceof String)) {
                    value = value.toString();
                }
                data[j] = value;
            }
            Coordinate loc = new Coordinate(t.xcor(), t.ycor());
            loc = GISExtension.getState().netLogoToGIS(loc, loc);
            Point geom = GISExtension.getState().factory().createPoint(loc);
            result.add((Geometry)geom, data);
        }
        return result;
    }
}

