/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.algorithm.CentroidArea;
import com.vividsolutions.jts.algorithm.CentroidLine;
import com.vividsolutions.jts.algorithm.CentroidPoint;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.HashMap;
import java.util.Map;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.Vertex;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionObject;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.Nobody$;
import org.nlogo.api.Syntax;

public strictfp final class VectorFeature
implements ExtensionObject {
    private VectorDataset.ShapeType _shapeType;
    private Geometry _geometry;
    private Map<String, Object> _properties;

    static VectorFeature getFeature(Argument arg) throws ExtensionException, LogoException {
        Object obj = arg.get();
        if (obj instanceof VectorFeature) {
            return (VectorFeature)obj;
        }
        throw new ExtensionException("not a VectorFeature: " + obj);
    }

    public VectorFeature(VectorDataset.ShapeType shapeType, Geometry geometry, VectorDataset.Property[] properties, Object[] propertyValues) {
        this._shapeType = shapeType;
        this._geometry = geometry;
        this._properties = new HashMap<String, Object>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            this._properties.put(properties[i].getName(), propertyValues[i]);
        }
    }

    public VectorDataset.ShapeType getShapeType() {
        return this._shapeType;
    }

    public Envelope getEnvelope() {
        return this._geometry.getEnvelopeInternal();
    }

    public Geometry getGeometry() {
        return this._geometry;
    }

    public boolean hasProperty(String name) {
        return this._properties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this._properties.get(name.toUpperCase());
    }

    public String dump(boolean readable, boolean exporting, boolean reference) {
        StringBuffer buffer = new StringBuffer();
        for (String propertyName : this._properties.keySet()) {
            buffer.append("[\"");
            buffer.append(propertyName);
            buffer.append("\":\"");
            buffer.append(this._properties.get(propertyName));
            buffer.append("\"]");
        }
        return buffer.toString();
    }

    public String getExtensionName() {
        return "gis";
    }

    public String getNLTypeName() {
        return "VectorFeature";
    }

    public boolean recursivelyEqual(Object obj) {
        if (obj instanceof VectorFeature) {
            VectorFeature vf = (VectorFeature)obj;
            return vf == this;
        }
        return false;
    }

    public strictfp static final class GetCentroid
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorFeature feature = VectorFeature.getFeature(args[0]);
            switch (feature.getShapeType()) {
                case POINT: {
                    CentroidPoint cp = new CentroidPoint();
                    cp.add(feature.getGeometry());
                    return new Vertex(cp.getCentroid());
                }
                case LINE: {
                    CentroidLine cl = new CentroidLine();
                    cl.add(feature.getGeometry());
                    return new Vertex(cl.getCentroid());
                }
                case POLYGON: {
                    CentroidArea ca = new CentroidArea();
                    ca.add(feature.getGeometry());
                    return new Vertex(ca.getCentroid());
                }
            }
            throw new ExtensionException("invalid shape type");
        }
    }

    public strictfp static final class GetVertexLists
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            VectorFeature feature = VectorFeature.getFeature(args[0]);
            final LogoListBuilder result = new LogoListBuilder();
            feature.getGeometry().apply(new GeometryComponentFilter(){

                public void filter(Geometry geom) {
                    if (geom instanceof Point) {
                        LogoListBuilder list = new LogoListBuilder();
                        list.add((Object)new Vertex(((Point)geom).getCoordinate()));
                        result.add((Object)list.toLogoList());
                    } else if (geom instanceof LineString) {
                        LineString ls = (LineString)geom;
                        LogoListBuilder list = new LogoListBuilder();
                        for (int i = 0; i < ls.getNumPoints(); ++i) {
                            list.add((Object)new Vertex(ls.getCoordinateN(i)));
                        }
                        result.add((Object)list.toLogoList());
                    }
                }
            });
            return result.toLogoList();
        }
    }

    public strictfp static final class GetProperty
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.StringType()}, (int)Syntax.ReadableType());
        }

        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            String key;
            VectorFeature feature = VectorFeature.getFeature(args[0]);
            if (feature.hasProperty(key = args[1].getString().toUpperCase())) {
                Object result = feature.getProperty(key);
                if (result == null) {
                    return Nobody$.MODULE$;
                }
                return result;
            }
            throw new ExtensionException("feature does not have property '" + key + "'");
        }
    }
}

