/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo.gui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.MouseInputAdapter;
import org.myworldgis.io.shapefile.ESRIShapefileReader;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionFormat;

public strictfp final class GISDataView
extends JComponent {
    static final long serialVersionUID = 1L;
    static final Stroke STROKE = new BasicStroke(0.001f, 2, 2);
    static final GeometryFactory FACTORY = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING));
    private List<Shape> _shapes;
    private ProjectedSpaceToPixelSpaceTransform _transform;
    private Projection _proj;

    public static void main(String[] args) {
        try {
            GISDataView dataView = new GISDataView();
            Projection proj = ProjectionFormat.getInstance().parseProjection(new BufferedReader(new FileReader("c:/java/gis/data/Lambert_Conformal_Conic.prj")));
            dataView.setProjection(proj);
            GeometryTransformer xform = proj.getForwardTransformer();
            Envelope env = new Envelope();
            GeometryFactory factory = null;
            factory = GISExtension.getState() != null ? GISExtension.getState().factory() : FACTORY;
            ESRIShapefileReader shp = new ESRIShapefileReader(new FileInputStream(new File("data/countries.shp")), Projection.DEGREES_TO_RADIANS, factory);
            while (true) {
                try {
                    Geometry geom;
                    while ((geom = shp.getNextShape()) != null) {
                        Geometry xGeom = xform.transform(geom);
                        env.expandToInclude(xGeom.getEnvelopeInternal());
                        dataView.addGeometry(xGeom);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            dataView.zoomToEnvelope(env);
            JFrame window = new JFrame("GIS Data View");
            window.setDefaultCloseOperation(3);
            window.getContentPane().add(dataView);
            window.pack();
            window.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addToPath(LineString line, GeneralPath p) {
        Coordinate c = line.getCoordinateN(0);
        p.moveTo((float)c.x, (float)c.y);
        for (int i = 1; i < line.getNumPoints(); ++i) {
            c = line.getCoordinateN(i);
            p.lineTo((float)c.x, (float)c.y);
        }
    }

    public GISDataView() {
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(300, 300));
        this.setBackground(Color.WHITE);
        this._shapes = new ArrayList<Shape>();
        this._transform = new ProjectedSpaceToPixelSpaceTransform(new Point2D.Float(0.0f, 0.0f), 0.6, new Point2D.Float(150.0f, 150.0f));
        this._proj = null;
        DragListener dragListener = new DragListener();
        this.addMouseListener(dragListener);
        this.addMouseMotionListener(dragListener);
        this.addMouseWheelListener(new ZoomListener());
        this.setSize(this.getPreferredSize());
    }

    public void zoomToEnvelope(Envelope env) {
        double yScale;
        double cx = env.getMinX() + (env.getMaxX() - env.getMinX()) / 2.0;
        double cy = env.getMinY() + (env.getMaxY() - env.getMinY()) / 2.0;
        this._transform.setProjectedCenter(new Point2D.Double(Double.isNaN(cx) ? 0.0 : cx, Double.isNaN(cy) ? 0.0 : cy));
        double xScale = (double)this.getWidth() / env.getWidth();
        if (xScale == 0.0) {
            xScale = Double.MAX_VALUE;
        }
        if ((yScale = (double)this.getHeight() / env.getHeight()) == 0.0) {
            yScale = Double.MAX_VALUE;
        }
        this._transform.setScale(StrictMath.min(xScale, yScale));
    }

    public void addGeometry(Geometry geom) {
        if (geom instanceof Point) {
            Coordinate c = ((Point)geom).getCoordinate();
            this._shapes.add(new Ellipse2D.Double(c.x - 0.01, c.y - 0.01, 0.02, 0.02));
            this._shapes.add(new Ellipse2D.Double(c.x - 1000.0, c.y - 1000.0, 2000.0, 2000.0));
            this._shapes.add(new Ellipse2D.Double(c.x - 10000.0, c.y - 10000.0, 20000.0, 20000.0));
            this._shapes.add(new Ellipse2D.Double(c.x - 100000.0, c.y - 100000.0, 200000.0, 200000.0));
        } else if (geom instanceof LineString) {
            GeneralPath p = new GeneralPath(0);
            GISDataView.addToPath((LineString)geom, p);
            this._shapes.add(p);
        } else if (geom instanceof Polygon) {
            GeneralPath p = new GeneralPath(1);
            Polygon poly = (Polygon)geom;
            GISDataView.addToPath(poly.getExteriorRing(), p);
            for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                GISDataView.addToPath(poly.getInteriorRingN(i), p);
            }
            this._shapes.add(p);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.addGeometry(gc.getGeometryN(i));
            }
        }
    }

    public Projection getProjection() {
        return this._proj;
    }

    public void setProjection(Projection proj) {
        this._proj = proj;
    }

    public void reshape(int x, int y, int newWidth, int newHeight) {
        super.reshape(x, y, newWidth > 0 ? newWidth : 1, newHeight > 0 ? newHeight : 1);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        this._transform.setPixelCenter(new Point2D.Float((float)insets.left + (float)(size.width - (insets.left + insets.right)) / 2.0f, (float)insets.top + (float)(size.height - (insets.top + insets.bottom)) / 2.0f));
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.BLACK);
        g2d.setStroke(STROKE);
        g2d.setTransform(this._transform);
        for (int i = 0; i < this._shapes.size(); ++i) {
            g2d.draw(this._shapes.get(i));
        }
    }

    private strictfp class ZoomListener
    implements MouseWheelListener {
        private ZoomListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent evt) {
            if (evt.getUnitsToScroll() > 0) {
                GISDataView.this._transform.setScale(GISDataView.this._transform.getScale() * 0.875);
            } else {
                GISDataView.this._transform.setScale(GISDataView.this._transform.getScale() * 1.142857);
            }
            GISDataView.this.repaint();
        }
    }

    private strictfp class DragListener
    extends MouseInputAdapter {
        private java.awt.Point _last;

        private DragListener() {
        }

        public void mousePressed(MouseEvent evt) {
            this._last = evt.getPoint();
        }

        public void mouseReleased(MouseEvent evt) {
            this._last = null;
        }

        public void mouseDragged(MouseEvent evt) {
            if (this._last != null) {
                int dx = evt.getX() - this._last.x;
                int dy = evt.getY() - this._last.y;
                Point2D oldGISCenter = GISDataView.this._transform.getProjectedCenter();
                double newX = oldGISCenter.getX() - (double)dx / GISDataView.this._transform.getScale();
                double newY = oldGISCenter.getY() + (double)dy / GISDataView.this._transform.getScale();
                GISDataView.this._transform.setProjectedCenter(new Point2D.Double(newX, newY));
                this._last = evt.getPoint();
                GISDataView.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent evt) {
            if (GISDataView.this._proj != null) {
                try {
                    Point2D p = GISDataView.this._transform.inverseTransform(evt.getPoint(), null);
                    System.out.println(GISDataView.this._proj.getInverseTransformer().transform((Geometry)FACTORY.createPoint(new Coordinate(p.getX(), p.getY()))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private strictfp static class ProjectedSpaceToPixelSpaceTransform
    extends AffineTransform {
        static final long serialVersionUID = 1L;
        private Point2D _gisCenter;
        private double _scale;
        private Point2D _pixelCenter;

        public ProjectedSpaceToPixelSpaceTransform(Point2D gisCenter, double scale, Point2D pixelCenter) {
            this._gisCenter = gisCenter;
            this._scale = scale;
            this._pixelCenter = pixelCenter;
            this.recomputeTransform();
        }

        public Point2D getProjectedCenter() {
            return (Point2D)this._gisCenter.clone();
        }

        public void setProjectedCenter(Point2D newCenter) {
            this._gisCenter.setLocation(newCenter.getX(), newCenter.getY());
            this.recomputeTransform();
        }

        public double getScale() {
            return this._scale;
        }

        public void setScale(double newScale) {
            if (newScale != this._scale) {
                this._scale = newScale;
                this.recomputeTransform();
            }
        }

        public Point2D getPixelCenter() {
            return (Point2D)this._pixelCenter.clone();
        }

        public void setPixelCenter(Point2D newCenter) {
            this._pixelCenter.setLocation(newCenter.getX(), newCenter.getY());
            this.recomputeTransform();
        }

        private void recomputeTransform() {
            this.setToTranslation(this._pixelCenter.getX(), this._pixelCenter.getY());
            this.scale(this._scale, -this._scale);
            this.translate(-this._gisCenter.getX(), -this._gisCenter.getY());
        }
    }
}

