/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import java.util.ArrayList;
import java.util.LinkedList;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.Projection;
import org.myworldgis.util.JTSUtils;

public strictfp abstract class AbstractProjection
implements Projection {
    protected String _name = "";
    protected Projection.LineType _lineType = Projection.LineType.STRAIGHT;
    protected Ellipsoid _ellipsoid;
    protected double _a;
    protected double _e2;
    protected double _phi0;
    protected double _lambda0;

    public AbstractProjection(Ellipsoid ellipsoid, Coordinate center) {
        this(ellipsoid, center.x, center.y);
    }

    public AbstractProjection(Ellipsoid ellipsoid, double lambda0, double phi0) {
        this._ellipsoid = ellipsoid;
        this._a = this._ellipsoid.radius;
        this._e2 = ellipsoid.eccsq;
        this._phi0 = phi0;
        this._lambda0 = lambda0;
    }

    public abstract Point process(Point var1);

    public abstract MultiPolygon process(Polygon var1);

    public abstract MultiLineString process(LineString var1);

    protected abstract Coordinate forwardPoint(double var1, double var3, Coordinate var5);

    protected abstract Coordinate inversePoint(double var1, double var3, Coordinate var5);

    protected abstract void computeParameters();

    public String toString() {
        return this._name;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            AbstractProjection proj = (AbstractProjection)obj;
            return proj._ellipsoid.equals(this._ellipsoid) && StrictMath.abs(proj._phi0 - this._phi0) < 1.567855942887398E-7 && StrictMath.abs(proj._lambda0 - this._lambda0) < 1.567855942887398E-7;
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            InternalError err = new InternalError("this should never happen");
            err.initCause(e);
            throw err;
        }
    }

    public Projection.LineType getLineType() {
        return this._lineType;
    }

    public void setLineType(Projection.LineType newLineType) {
        if (newLineType != this._lineType) {
            this._lineType = newLineType;
        }
    }

    public Ellipsoid getEllipsoid() {
        return this._ellipsoid;
    }

    public void setEllipsoid(Ellipsoid newEllipsoid) {
        Ellipsoid oldEllipsoid = this._ellipsoid;
        if (newEllipsoid != oldEllipsoid) {
            this._ellipsoid = newEllipsoid;
            this._a = this._ellipsoid.radius;
            this._e2 = this._ellipsoid.eccsq;
            this.computeParameters();
        }
    }

    public Coordinate getCenter() {
        return new Coordinate(this._lambda0, this._phi0);
    }

    public void setCenter(Coordinate newCenter) {
        if (!Double.isNaN(newCenter.x) && !Double.isNaN(newCenter.y)) {
            this._phi0 = newCenter.y;
            this._lambda0 = newCenter.x;
            this.computeParameters();
        }
    }

    public double getCenterEasting() {
        return 0.0;
    }

    public double getCenterNorthing() {
        return 0.0;
    }

    public boolean isRhumbRectangular() {
        return false;
    }

    public GeometryTransformer getForwardTransformer() {
        return new ForwardTransformer((AbstractProjection)this.clone());
    }

    public GeometryTransformer getInverseTransformer() {
        return new InverseTransformer((AbstractProjection)this.clone());
    }

    private strictfp static class InverseTransformer
    extends GeometryTransformer {
        private final AbstractProjection _proj;

        public InverseTransformer(AbstractProjection proj) {
            this._proj = proj;
        }

        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            LinkedList<Coordinate> newCoords = new LinkedList<Coordinate>();
            for (int i = 0; i < coords.size(); ++i) {
                Coordinate c = this._proj.inversePoint(coords.getX(i), coords.getY(i), new Coordinate());
                if (!(!Double.isNaN(c.x) && !Double.isNaN(c.y) && StrictMath.abs(c.x) <= Math.PI) && !(StrictMath.abs(c.y) <= 1.5707963267948966)) continue;
                newCoords.add(c);
            }
            return this.createCoordinateSequence(newCoords.toArray(new Coordinate[newCoords.size()]));
        }

        protected Geometry transformLinearRing(LinearRing geom, Geometry parent) {
            CoordinateSequence seq = this.transformCoordinates(geom.getCoordinateSequence(), (Geometry)geom);
            int seqSize = seq.size();
            if (seqSize > 0 && seqSize < 4) {
                return this.factory.createLineString(seq);
            }
            if (seqSize > 2 && !seq.getCoordinate(0).equals2D(seq.getCoordinate(seqSize - 1))) {
                Coordinate[] newArray = new Coordinate[seqSize + 1];
                for (int i = 0; i < seqSize; ++i) {
                    newArray[i] = seq.getCoordinate(i);
                }
                newArray[seqSize] = seq.getCoordinate(0);
                seq = this.createCoordinateSequence(newArray);
            }
            return this.factory.createLinearRing(seq);
        }
    }

    private strictfp static class ForwardTransformer
    extends GeometryTransformer {
        private final AbstractProjection _proj;
        private final CoordinateFilter _filter;

        public ForwardTransformer(AbstractProjection proj) {
            this._proj = proj;
            this._filter = new CoordinateFilter(){
                private Coordinate temp = new Coordinate();

                public void filter(Coordinate coord) {
                    this.temp = ForwardTransformer.this._proj.forwardPoint(coord.x, coord.y, this.temp);
                    coord.setCoordinate(this.temp);
                }
            };
        }

        protected Geometry transformPoint(Point geom, Geometry parent) {
            geom = this._proj.process(geom);
            geom.apply(this._filter);
            geom.geometryChanged();
            return geom;
        }

        protected Geometry transformLineString(LineString geom, Geometry parent) {
            MultiLineString result = this._proj.process(geom);
            result.apply(this._filter);
            result.geometryChanged();
            return result;
        }

        protected Geometry transformMultiLineString(MultiLineString geom, Geometry parent) {
            ArrayList<LineString> lines = new ArrayList<LineString>();
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                MultiLineString mls = this._proj.process((LineString)geom.getGeometryN(i));
                mls.apply(this._filter);
                mls.geometryChanged();
                for (int j = 0; j < mls.getNumGeometries(); ++j) {
                    lines.add((LineString)mls.getGeometryN(j));
                }
            }
            return this.factory.createMultiLineString(GeometryFactory.toLineStringArray(lines));
        }

        protected Geometry transformPolygon(Polygon geom, Geometry parent) {
            MultiPolygon result = this._proj.process(geom);
            result.apply(this._filter);
            result.geometryChanged();
            return JTSUtils.repair((Geometry)result);
        }

        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                MultiPolygon mp = this._proj.process((Polygon)geom.getGeometryN(i));
                mp.apply(this._filter);
                mp.geometryChanged();
                for (int j = 0; j < mp.getNumGeometries(); ++j) {
                    polygons.add(JTSUtils.repair((Polygon)mp.getGeometryN(j)));
                }
            }
            return this.factory.createMultiPolygon(GeometryFactory.toPolygonArray(polygons));
        }
    }
}

