/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Conic;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class AlbersEqualAreaConic
extends Conic {
    public static final String WKT_NAME = "Albers_Conic_Equal_Area";
    public static final String CENTER_LON_PROPERTY = "longitude_of_center";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_center";
    private double _e;
    private double _n;
    private double _C;
    private double _rho0;
    private double _subBeta;
    private double[] _subPhi;

    private final double getQ(double phi) {
        double sinPhi = StrictMath.sin(phi);
        return (1.0 - this._e2) * (sinPhi / (1.0 - this._e2 * sinPhi * sinPhi) - 1.0 / (2.0 * this._e) * StrictMath.log((1.0 - this._e * sinPhi) / (1.0 + this._e * sinPhi)));
    }

    public AlbersEqualAreaConic(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing, double phi1, double phi2) {
        super(ellipsoid, center, units, falseEasting, falseNorthing, phi1, phi2);
        this._name = WKT_NAME;
        this._subPhi = new double[3];
        this.computeParameters();
    }

    public AlbersEqualAreaConic(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._subPhi = new double[3];
        this.computeParameters();
    }

    @Override
    protected Coordinate forwardPointRaw(double lon, double lat, Coordinate storage) {
        double q = this.getQ(lat);
        double theta = this._n * GeometryUtils.wrap_longitude(lon - this._lambda0);
        double rho = this._a * StrictMath.sqrt(this._C - this._n * q) / this._n;
        storage.x = rho * StrictMath.sin(theta);
        storage.y = this._rho0 - rho * StrictMath.cos(theta);
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double rho0minusY = this._rho0 - y;
        double rho = StrictMath.sqrt(x * x + rho0minusY * rho0minusY);
        double theta = this._n < 0.0 ? StrictMath.atan2(-x, -rho0minusY) : StrictMath.atan2(x, rho0minusY);
        double q = (this._C - rho * rho * (this._n * this._n) / (this._a * this._a)) / this._n;
        double beta = StrictMath.asin(q / this._subBeta);
        storage.y = beta + this._subPhi[0] * StrictMath.sin(2.0 * beta) + this._subPhi[1] * StrictMath.sin(4.0 * beta) + this._subPhi[2] * StrictMath.sin(6.0 * beta);
        double thetaOverN = theta / this._n;
        storage.x = StrictMath.abs(thetaOverN) > Math.PI ? Double.NaN : GeometryUtils.wrap_longitude(this._lambda0 + thetaOverN);
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._e = StrictMath.sqrt(this._e2);
        double m1 = StrictMath.cos(this._phi1) / StrictMath.sqrt(1.0 - this._e2 * StrictMath.sin(this._phi1) * StrictMath.sin(this._phi1));
        double m2 = StrictMath.cos(this._phi2) / StrictMath.sqrt(1.0 - this._e2 * StrictMath.sin(this._phi2) * StrictMath.sin(this._phi2));
        double q0 = this.getQ(this._phi0);
        double q1 = this.getQ(this._phi1);
        double q2 = this.getQ(this._phi2);
        this._n = (m1 * m1 - m2 * m2) / (q2 - q1);
        this._C = m1 * m1 + this._n * q1;
        this._rho0 = this._a * StrictMath.sqrt(this._C - this._n * q0) / this._n;
        this._subBeta = 1.0 - (1.0 - this._e2) / (2.0 * this._e) * StrictMath.log((1.0 - this._e) / (1.0 + this._e));
        this._subPhi[0] = this._e2 / 3.0 + 31.0 * this._e2 * this._e2 / 180.0 + 517.0 * this._e2 * this._e2 * this._e2 / 5040.0;
        this._subPhi[1] = 23.0 * this._e2 * this._e2 / 360.0 + 251.0 * this._e2 * this._e2 * this._e2 / 3780.0;
        this._subPhi[2] = 761.0 * this._e2 * this._e2 * this._e2 / 45360.0;
        super.computeParameters();
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        return result;
    }

    @Override
    public Object clone() {
        AlbersEqualAreaConic clone = (AlbersEqualAreaConic)super.clone();
        clone._subPhi = (double[])this._subPhi.clone();
        return clone;
    }
}

