/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Azimuthal;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class AzimuthalEquidistant
extends Azimuthal {
    public static final String WKT_NAME = "Azimuthal_Equidistant";
    public static final String CENTER_LON_PROPERTY = "longitude_of_center";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_center";

    public AzimuthalEquidistant(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this.computeParameters();
    }

    public AzimuthalEquidistant(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this.computeParameters();
    }

    @Override
    protected double getMaxC() {
        return 2.356194490192345;
    }

    @Override
    protected Coordinate forwardPointRaw(double lambda, double phi, Coordinate storage) {
        double cosC = this._sinPhi0 * StrictMath.sin(phi) + this._cosPhi0 * StrictMath.cos(phi) * StrictMath.cos(GeometryUtils.wrap_longitude(lambda - this._lambda0));
        if (cosC == 1.0) {
            storage.x = 0.0;
            storage.y = 0.0;
        } else {
            double c = StrictMath.acos(cosC);
            double kPrime = c / StrictMath.sin(c);
            storage.x = this._a * kPrime * StrictMath.cos(phi) * StrictMath.sin(GeometryUtils.wrap_longitude(lambda - this._lambda0));
            storage.y = this._a * kPrime * (this._cosPhi0 * StrictMath.sin(phi) - this._sinPhi0 * StrictMath.cos(phi) * StrictMath.cos(GeometryUtils.wrap_longitude(lambda - this._lambda0)));
        }
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double rho = StrictMath.sqrt(x * x + y * y);
        if (rho == 0.0) {
            storage.y = this._phi0;
            storage.x = this._lambda0;
        } else {
            double c = rho / this._a;
            storage.y = StrictMath.asin(StrictMath.cos(c) * this._sinPhi0 + y * StrictMath.sin(c) * this._cosPhi0 / rho);
            storage.x = this._lambda0 + StrictMath.atan2(x * StrictMath.sin(c), rho * this._cosPhi0 * StrictMath.cos(c) - y * this._sinPhi0 * StrictMath.sin(c));
        }
        return storage;
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        return result;
    }
}

