/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.text.ParseException;
import org.myworldgis.projection.AbstractProjectedProjection;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.Mercator;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.projection.ProjectionUtils;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class Cylindrical
extends AbstractProjectedProjection {
    public Cylindrical(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
    }

    public Cylindrical(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
    }

    @Override
    public Point process(Point point) {
        return point;
    }

    @Override
    public MultiPolygon process(Polygon poly) {
        if (this._lineType == Projection.LineType.RHUMB && !(this instanceof Mercator)) {
            poly = ProjectionUtils.createRhumbPoly(poly);
        } else if (this._lineType == Projection.LineType.GREATCIRCLE) {
            poly = ProjectionUtils.createGreatCirclePoly(poly);
        }
        return ProjectionUtils.wrap(poly, this._lambda0);
    }

    @Override
    public MultiLineString process(LineString line) {
        if (this._lineType == Projection.LineType.RHUMB && !(this instanceof Mercator)) {
            line = ProjectionUtils.createRhumbLine(line);
        } else if (this._lineType == Projection.LineType.GREATCIRCLE) {
            line = ProjectionUtils.createGreatCircleLine(line);
        }
        return ProjectionUtils.wrap(line, this._lambda0);
    }

    @Override
    protected void computeParameters() {
    }
}

