/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Conic;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class LambertConformalConic
extends Conic {
    public static final String WKT_NAME = "Lambert_Conformal_Conic_2SP";
    public static final String CENTER_LON_PROPERTY = "central_meridian";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_origin";
    private double _e;
    private double _n;
    private double _inverseN;
    private double _F;
    private double _rho0;
    private double[] _subPhi;

    public LambertConformalConic(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing, double phi1, double phi2) {
        super(ellipsoid, center, units, falseEasting, falseNorthing, phi1, phi2);
        this._name = WKT_NAME;
        this._subPhi = new double[4];
        this.computeParameters();
    }

    public LambertConformalConic(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._subPhi = new double[4];
        this.computeParameters();
    }

    private double getT(double phi) {
        double sinPhi = StrictMath.sin(phi);
        return StrictMath.sqrt((1.0 - sinPhi) / (1.0 + sinPhi) * StrictMath.pow((1.0 + this._e * sinPhi) / (1.0 - this._e * sinPhi), this._e));
    }

    @Override
    protected Coordinate forwardPointRaw(double lon, double lat, Coordinate storage) {
        double rho = this._a * this._F * StrictMath.pow(this.getT(lat), this._n);
        double theta = this._n * GeometryUtils.wrap_longitude(lon - this._lambda0);
        storage.x = rho * StrictMath.sin(theta);
        storage.y = this._rho0 - rho * StrictMath.cos(theta);
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double theta;
        double rho0minusY = this._rho0 - y;
        double rho = StrictMath.sqrt(x * x + rho0minusY * rho0minusY) * (double)GeometryUtils.sign(this._n);
        double d = theta = this._n < 0.0 ? StrictMath.atan2(-x, -rho0minusY) : StrictMath.atan2(x, rho0minusY);
        if (rho == 0.0) {
            storage.y = 1.5707963267948966 * (double)GeometryUtils.sign(this._n);
        } else {
            double t = StrictMath.pow(rho / (this._a * this._F), this._inverseN);
            double chi = 1.5707963267948966 - 2.0 * StrictMath.atan(t);
            storage.y = chi + this._subPhi[0] * StrictMath.sin(2.0 * chi) + this._subPhi[1] * StrictMath.sin(4.0 * chi) + this._subPhi[2] * StrictMath.sin(6.0 * chi) + this._subPhi[3] * StrictMath.sin(8.0 * chi);
        }
        double thetaOverN = theta / this._n;
        storage.x = StrictMath.abs(thetaOverN) > Math.PI ? Double.NaN : GeometryUtils.wrap_longitude(this._lambda0 + thetaOverN);
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._e = StrictMath.sqrt(this._e2);
        double t0 = this.getT(this._phi0);
        double t1 = this.getT(this._phi1);
        double sinPhi1 = StrictMath.sin(this._phi1);
        double m1 = StrictMath.cos(this._phi1) / StrictMath.sqrt(1.0 - this._e2 * sinPhi1 * sinPhi1);
        if (this._phi1 == this._phi2) {
            this._n = sinPhi1;
        } else {
            double t2 = this.getT(this._phi2);
            double sinPhi2 = StrictMath.sin(this._phi2);
            double m2 = StrictMath.cos(this._phi2) / StrictMath.sqrt(1.0 - this._e2 * sinPhi2 * sinPhi2);
            this._n = (StrictMath.log(m1) - StrictMath.log(m2)) / (StrictMath.log(t1) - StrictMath.log(t2));
        }
        this._inverseN = 1.0 / this._n;
        this._F = m1 / (this._n * StrictMath.pow(t1, this._n));
        this._rho0 = this._a * this._F * StrictMath.pow(t0, this._n);
        this._subPhi[0] = this._e2 / 2.0 + 5.0 * this._e2 * this._e2 / 24.0 + this._e2 * this._e2 * this._e2 / 12.0 + 13.0 * this._e2 * this._e2 * this._e2 * this._e2 / 360.0;
        this._subPhi[1] = 7.0 * this._e2 * this._e2 / 48.0 + 29.0 * this._e2 * this._e2 * this._e2 / 240.0 + 811.0 * this._e2 * this._e2 * this._e2 * this._e2 / 11520.0;
        this._subPhi[2] = 7.0 * this._e2 * this._e2 * this._e2 / 120.0 + 81.0 * this._e2 * this._e2 * this._e2 * this._e2 / 1120.0;
        this._subPhi[3] = 4279.0 * this._e2 * this._e2 * this._e2 * this._e2 / 161280.0;
        super.computeParameters();
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        return result;
    }

    @Override
    public Object clone() {
        LambertConformalConic clone = (LambertConformalConic)super.clone();
        clone._subPhi = (double[])this._subPhi.clone();
        return clone;
    }
}

