/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.ngs.ngunits.NonSI;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.quantity.Length;

public interface Projection
extends Cloneable {
    public static final UnitConverter DEGREES_TO_RADIANS = NonSI.DEGREE_ANGLE.getConverterTo(SI.RADIAN);
    public static final UnitConverter RADIANS_TO_DEGREES = SI.RADIAN.getConverterTo(NonSI.DEGREE_ANGLE);
    public static final Ellipsoid DEFAULT_ELLIPSOID = Ellipsoid.WGS_84;
    public static final Coordinate DEFAULT_CENTER = new Coordinate(0.0, 0.0);
    public static final Unit<Length> DEFAULT_UNITS = SI.METRE;

    public LineType getLineType();

    public void setLineType(LineType var1);

    public Ellipsoid getEllipsoid();

    public void setEllipsoid(Ellipsoid var1);

    public Coordinate getCenter();

    public void setCenter(Coordinate var1);

    public double getCenterEasting();

    public double getCenterNorthing();

    public boolean isRhumbRectangular();

    public GeometryTransformer getForwardTransformer();

    public GeometryTransformer getInverseTransformer();

    public ProjectionParameters getParameters();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineType {
        STRAIGHT,
        RHUMB,
        GREATCIRCLE;

    }
}

