/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Iterator;
import org.myworldgis.projection.AlbersEqualAreaConic;
import org.myworldgis.projection.AzimuthalEqualArea;
import org.myworldgis.projection.AzimuthalEquidistant;
import org.myworldgis.projection.CylindricalEqualArea;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.EquidistantConic;
import org.myworldgis.projection.Geographic;
import org.myworldgis.projection.Gnomonic;
import org.myworldgis.projection.LambertConformalConic;
import org.myworldgis.projection.Mercator;
import org.myworldgis.projection.Miller;
import org.myworldgis.projection.ObliqueMercator;
import org.myworldgis.projection.Orthographic;
import org.myworldgis.projection.Polyconic;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.projection.Robinson;
import org.myworldgis.projection.Stereographic;
import org.myworldgis.projection.TransverseMercator;
import org.myworldgis.wkt.WKTElement;
import org.myworldgis.wkt.WKTFormat;
import org.ngs.ngunits.NonSI;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class ProjectionFormat
extends Format {
    static final long serialVersionUID = 1L;
    private static final ProjectionFormat _instance = new ProjectionFormat();

    public static ProjectionFormat getInstance() {
        return _instance;
    }

    public static void main(String[] args) {
        try {
            Projection proj = _instance.parseProjection("GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]]", new ParsePosition(0));
            System.out.println(_instance.format(proj));
            System.out.println(_instance.parseObject(_instance.format(proj)));
            proj = _instance.parseProjection("PROJCS[\"World_Equidistant_Conic\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]],PROJECTION[\"Equidistant_Conic\"],PARAMETER[\"False_Easting\",0],PARAMETER[\"False_Northing\",0],PARAMETER[\"Central_Meridian\",0],PARAMETER[\"Standard_Parallel_1\",60],PARAMETER[\"Standard_Parallel_2\",60],PARAMETER[\"Latitude_Of_Origin\",0],UNIT[\"Meter\",1]]", new ParsePosition(0));
            System.out.println(_instance.format(proj));
            System.out.println(_instance.parseObject(_instance.format(proj)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String format(Projection proj) {
        return WKTFormat.getInstance().formatWKT(this.toWKT(proj));
    }

    public WKTElement toWKT(Projection proj) {
        if (proj instanceof Geographic) {
            WKTElement geogcs = new WKTElement("GEOGCS");
            geogcs.addContent(proj.toString());
            geogcs.addContent(this.makeDatumElement(proj.getEllipsoid()));
            geogcs.addContent(this.makePrimeMeridianElement(proj.getCenter().x));
            geogcs.addContent(this.makeAngularUnitsElement(((Geographic)proj).getUnits()));
            return geogcs;
        }
        ProjectionParameters params = proj.getParameters();
        WKTElement projcs = new WKTElement("PROJCS");
        projcs.addContent(proj.toString());
        projcs.addContent(new WKTElement("GEOGCS", "GCS_" + proj.getEllipsoid().toString(), this.makeDatumElement(proj.getEllipsoid()), this.makePrimeMeridianElement(0.0), this.makeAngularUnitsElement(params.getAngularUnits())));
        projcs.addContent(new WKTElement("PROJECTION", proj.toString()));
        Iterator<String> names = params.propertyNameIterator();
        while (names.hasNext()) {
            String parameterName = names.next();
            projcs.addContent(new WKTElement("PARAMETER", parameterName, params.getParameter(parameterName)));
        }
        projcs.addContent(this.makeLinearUnitsElement(params.getLinearUnits()));
        return projcs;
    }

    private WKTElement makeDatumElement(Ellipsoid ellipsoid) {
        return new WKTElement("DATUM", "D_" + ellipsoid.toString(), new WKTElement("SPHEROID", ellipsoid.toString(), ellipsoid.radius, ellipsoid.getInverseFlattening()));
    }

    private WKTElement makePrimeMeridianElement(double longitude) {
        return new WKTElement("PRIMEM", longitude == 0.0 ? "Greenwich" : "Custom", Projection.RADIANS_TO_DEGREES.convert(longitude));
    }

    private WKTElement makeAngularUnitsElement(Unit<Angle> units) {
        return new WKTElement("UNIT", units.toString(), units.getConverterTo(SI.RADIAN).convert(1.0));
    }

    private WKTElement makeLinearUnitsElement(Unit<Length> units) {
        return new WKTElement("UNIT", units.toString(), units.getConverterTo(SI.METRE).convert(1.0));
    }

    public Projection parseProjection(BufferedReader in) throws IOException, ParseException {
        StringBuffer wkt = new StringBuffer();
        String line = null;
        while ((line = in.readLine()) != null) {
            wkt.append(line);
        }
        return this.parseProjection(wkt.toString());
    }

    public Projection parseProjection(String text) throws ParseException {
        return this.parseProjection(text, new ParsePosition(0));
    }

    public Projection parseProjection(String text, ParsePosition pos) throws ParseException {
        return this.parseProjection(WKTFormat.getInstance().parseWKT(text, pos));
    }

    public Projection parseProjection(WKTElement wkt) throws ParseException {
        if (wkt.getKeyword().equals("GEOGCS")) {
            return this.parseGeographic(wkt);
        }
        if (wkt.getKeyword().equals("PROJCS")) {
            return this.parseProjected(wkt);
        }
        throw new ParseException("only GEOGCS and PROJCS are supported", 0);
    }

    private Geographic parseGeographic(WKTElement element) throws ParseException {
        WKTElement datumElt = element.nextElement("DATUM", true);
        WKTElement spheriodElt = datumElt.nextElement("SPHEROID", true);
        Ellipsoid ellipsoid = new Ellipsoid(spheriodElt.nextString(false), spheriodElt.nextNumber(true).doubleValue(), (Unit<Length>)SI.METRE, spheriodElt.nextNumber(true).doubleValue());
        WKTElement primeMElement = element.nextElement("PRIMEM", true);
        WKTElement unitsElement = element.nextElement("UNIT", true);
        Unit units = SI.RADIAN;
        double conversion = unitsElement.nextNumber(true).doubleValue();
        if (conversion != 1.0) {
            units = units.multiply(conversion);
        }
        UnitConverter centerConverter = NonSI.DEGREE_ANGLE.getConverterTo(units);
        Coordinate center = new Coordinate(centerConverter.convert(primeMElement.nextNumber(true).doubleValue()), 0.0);
        return new Geographic(ellipsoid, center, (Unit<Angle>)units);
    }

    private Projection parseProjected(WKTElement element) throws ParseException {
        WKTElement gcsElement = element.nextElement("GEOGCS", true);
        WKTElement angularUnitsElement = gcsElement.nextElement("UNIT", true);
        Unit angularUnits = SI.RADIAN;
        double angularConversion = angularUnitsElement.nextNumber(true).doubleValue();
        if (angularConversion != 1.0) {
            angularUnits = angularUnits.multiply(angularConversion);
        }
        WKTElement datumElt = gcsElement.nextElement("DATUM", true);
        WKTElement spheriodElt = datumElt.nextElement("SPHEROID", true);
        Ellipsoid ellipsoid = new Ellipsoid(spheriodElt.nextString(false), spheriodElt.nextNumber(true).doubleValue(), (Unit<Length>)SI.METRE, spheriodElt.nextNumber(true).doubleValue());
        WKTElement projectedUnitsElement = element.nextElement("UNIT", true);
        Unit linearUnits = SI.METRE;
        double linearConversion = projectedUnitsElement.nextNumber(true).doubleValue();
        if (linearConversion != 1.0) {
            linearUnits = linearUnits.multiply(linearConversion);
        }
        ProjectionParameters parameters = new ProjectionParameters((Unit<Angle>)angularUnits, (Unit<Length>)linearUnits);
        WKTElement paramElement = null;
        while ((paramElement = element.nextElement("PARAMETER", false)) != null) {
            parameters.addParameter(paramElement.nextString(true), paramElement.nextNumber(true));
        }
        WKTElement projectionElt = element.nextElement("PROJECTION", true);
        String projectionName = projectionElt.nextString(true);
        if (projectionName.equals("Albers_Conic_Equal_Area")) {
            return new AlbersEqualAreaConic(ellipsoid, parameters);
        }
        if (projectionName.equals("Lambert_Azimuthal_Equal_Area")) {
            return new AzimuthalEqualArea(ellipsoid, parameters);
        }
        if (projectionName.equals("Azimuthal_Equidistant")) {
            return new AzimuthalEquidistant(ellipsoid, parameters);
        }
        if (projectionName.equals("Cylindrical_Equal_Area")) {
            return new CylindricalEqualArea(ellipsoid, parameters);
        }
        if (projectionName.equals("Equidistant_Conic")) {
            return new EquidistantConic(ellipsoid, parameters);
        }
        if (projectionName.equals("Gnomonic")) {
            return new Gnomonic(ellipsoid, parameters);
        }
        if (projectionName.equals("Lambert_Conformal_Conic_2SP")) {
            return new LambertConformalConic(ellipsoid, parameters);
        }
        if (projectionName.equals("Mercator_1SP")) {
            return new Mercator(ellipsoid, parameters);
        }
        if (projectionName.equals("Miller_Cylindrical")) {
            return new Miller(ellipsoid, parameters);
        }
        if (projectionName.equals("Oblique_Mercator") || projectionName.equals("hotine_oblique_mercator")) {
            return new ObliqueMercator(ellipsoid, parameters);
        }
        if (projectionName.equals("Orthographic")) {
            return new Orthographic(ellipsoid, parameters);
        }
        if (projectionName.equals("Polyconic")) {
            return new Polyconic(ellipsoid, parameters);
        }
        if (projectionName.equals("Robinson")) {
            return new Robinson(ellipsoid, parameters);
        }
        if (projectionName.equals("Stereographic")) {
            return new Stereographic(ellipsoid, parameters);
        }
        if (projectionName.equals("Transverse_Mercator")) {
            return new TransverseMercator(ellipsoid, parameters);
        }
        throw new ParseException("unsupported projection '" + projectionName + "'", 0);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer buf, FieldPosition pos) {
        buf.append(this.format((Projection)obj));
        return buf;
    }

    @Override
    public Object parseObject(String str, ParsePosition pos) {
        try {
            return this.parseProjection(str, pos);
        }
        catch (ParseException e) {
            pos.setIndex(0);
            pos.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }
}

