/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class ProjectionParameters {
    private final Map<String, Number> _parameters = new HashMap<String, Number>();
    private final Unit<Angle> _angularUnits;
    private final UnitConverter _toRadians;
    private final Unit<Length> _linearUnits;
    private final UnitConverter _toMeters;

    public ProjectionParameters(Unit<Angle> angularUnits, Unit<Length> linearUnits) {
        this._angularUnits = angularUnits;
        this._toRadians = this._angularUnits.getConverterTo(SI.RADIAN);
        this._linearUnits = linearUnits;
        this._toMeters = this._linearUnits.getConverterTo(SI.METRE);
    }

    public Unit<Angle> getAngularUnits() {
        return this._angularUnits;
    }

    public Unit<Length> getLinearUnits() {
        return this._linearUnits;
    }

    public Iterator<String> propertyNameIterator() {
        return this._parameters.keySet().iterator();
    }

    public void addParameter(String name, Number value) {
        this._parameters.put(name.toLowerCase(), value);
    }

    public Number getParameter(String name) {
        return this._parameters.get(name.toLowerCase());
    }

    public void addAngularParameter(String name, double angle, Unit<Angle> units) {
        UnitConverter converter = units.getConverterTo(this._angularUnits);
        this._parameters.put(name.toLowerCase(), converter.convert(angle));
    }

    public void addLinearParameter(String name, double length, Unit<Length> units) {
        UnitConverter converter = units.getConverterTo(this._linearUnits);
        this._parameters.put(name.toLowerCase(), converter.convert(length));
    }

    public void addDimensionlessParameter(String name, double k) {
        this._parameters.put(name.toLowerCase(), k);
    }

    public double getAngularParameter(String name) throws ParseException {
        Number value = this._parameters.get(name.toLowerCase());
        if (value != null) {
            return this._toRadians.convert(value.doubleValue());
        }
        throw new ParseException("missing required parameter '" + name + "'", 0);
    }

    public double getCenterLongitude() throws ParseException {
        Number value = this._parameters.get("longitude_of_center");
        if (value != null) {
            return this._toRadians.convert(value.doubleValue());
        }
        value = this._parameters.get("central_meridian");
        if (value != null) {
            return this._toRadians.convert(value.doubleValue());
        }
        throw new ParseException("unable to find parameter for center longitude", 0);
    }

    public double getCenterLatitude() throws ParseException {
        Number value = this._parameters.get("latitude_of_center");
        if (value != null) {
            return this._toRadians.convert(value.doubleValue());
        }
        value = this._parameters.get("latitude_of_origin");
        if (value != null) {
            return this._toRadians.convert(value.doubleValue());
        }
        value = this._parameters.get("standard_parallel_1");
        if (value != null) {
            return this._toRadians.convert(value.doubleValue());
        }
        throw new ParseException("unable to find parameter for center latitude", 0);
    }

    public double getLinearParameter(String name) throws ParseException {
        Number value = this._parameters.get(name.toLowerCase());
        if (value != null) {
            return this._toMeters.convert(value.doubleValue());
        }
        throw new ParseException("missing required parameter '" + name + "'", 0);
    }

    public double getDimensionlessParameter(String name) throws ParseException {
        Number value = this._parameters.get(name.toLowerCase());
        if (value != null) {
            return value.doubleValue();
        }
        throw new ParseException("missing required parameter '" + name + "'", 0);
    }
}

