/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Cylindrical;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class Robinson
extends Cylindrical {
    public static final String WKT_NAME = "Robinson";
    public static final String CENTER_LON_PROPERTY = "longitude_of_center";
    private static final double EPSLN = 1.0E-6;
    private static final double[] pr = new double[]{0.0, -0.062, 0.0, 0.062, 0.124, 0.186, 0.248, 0.31, 0.372, 0.434, 0.4958, 0.5571, 0.6176, 0.6769, 0.7346, 0.7903, 0.8435, 0.8936, 0.9394, 0.9761, 1.0};
    private static final double[] xlr = new double[]{0.0, 0.9986, 1.0, 0.9986, 0.9954, 0.99, 0.9822, 0.973, 0.96, 0.9427, 0.9216, 0.8962, 0.8679, 0.835, 0.7986, 0.7597, 0.7186, 0.6732, 0.6213, 0.5722, 0.5322};

    private static ProjectionParameters addCenterLon(ProjectionParameters params) {
        params.addParameter("latitude_of_center", 0.0);
        return params;
    }

    public Robinson(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this.computeParameters();
    }

    public Robinson(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, Robinson.addCenterLon(parameters));
        this._name = WKT_NAME;
        this.computeParameters();
    }

    @Override
    public boolean isRhumbRectangular() {
        return false;
    }

    @Override
    protected Coordinate forwardPointRaw(double lon, double lat, Coordinate storage) {
        double dlon = GeometryUtils.wrap_longitude(lon - this._lambda0);
        double p2 = StrictMath.abs(lat / 5.0 / 0.01745329252);
        int ip1 = StrictMath.min((int)StrictMath.floor(p2 - 1.0E-6), 17);
        storage.x = this._a * (xlr[ip1 + 2] + (p2 -= (double)ip1) * (xlr[ip1 + 3] - xlr[ip1 + 1]) / 2.0 + p2 * p2 * (xlr[ip1 + 3] - 2.0 * xlr[ip1 + 2] + xlr[ip1 + 1]) / 2.0) * dlon;
        storage.y = (double)GeometryUtils.sign(lat) * this._a * (pr[ip1 + 2] + p2 * (pr[ip1 + 3] - pr[ip1 + 1]) / 2.0 + p2 * p2 * (pr[ip1 + 3] - 2.0 * pr[ip1 + 2] + pr[ip1 + 1]) / 2.0) * 1.5707963267948966;
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        int ip1;
        double p2;
        double phid;
        block5: {
            double yy = 2.0 * y / Math.PI / this._a;
            phid = yy * 90.0;
            p2 = StrictMath.abs(phid / 5.0);
            ip1 = (int)StrictMath.floor(p2 - 1.0E-6);
            if (ip1 >= 18) {
                storage.x = Double.NaN;
                storage.y = Double.NaN;
                return storage;
            }
            if (ip1 == 0) {
                ip1 = 1;
            }
            int i = 0;
            do {
                double y1;
                double c;
                double u = pr[ip1 + 3] - pr[ip1 + 1];
                double v = pr[ip1 + 3] - 2.0 * pr[ip1 + 2] + pr[ip1 + 1];
                double t = 2.0 * (StrictMath.abs(yy) - pr[ip1 + 2]) / u;
                p2 = t * (1.0 - (c = v / u) * t * (1.0 - 2.0 * c * t));
                if (!(p2 >= 0.0) && ip1 != 1) continue;
                phid = (double)GeometryUtils.sign(y) * (p2 + (double)ip1) * 5.0;
                do {
                    if ((ip1 = (int)((p2 = StrictMath.abs(phid / 5.0)) - 1.0E-6)) >= 18) {
                        storage.x = Double.NaN;
                        storage.y = Double.NaN;
                        return storage;
                    }
                    y1 = (double)GeometryUtils.sign(y) * this._a * (pr[ip1 + 2] + (p2 -= (double)ip1) * (pr[ip1 + 3] - pr[ip1 + 1]) / 2.0 + p2 * p2 * (pr[ip1 + 3] - 2.0 * pr[ip1 + 2] + pr[ip1 + 1]) / 2.0) * 1.5707963267948966;
                    phid += -180.0 * (y1 - y) / Math.PI / this._a;
                    if (++i <= 75) continue;
                    throw new ArithmeticException("too many iterations in inverse");
                } while (StrictMath.abs(y1 - y) > 1.0E-5);
                break block5;
            } while (--ip1 >= 0);
            throw new ArithmeticException("too many iterations in inverse");
        }
        storage.y = phid * 0.01745329252;
        storage.x = GeometryUtils.wrap_longitude(this._lambda0 + x / this._a / (xlr[ip1 + 2] + p2 * (xlr[ip1 + 3] - xlr[ip1 + 1]) / 2.0 + p2 * p2 * (xlr[ip1 + 3] - 2.0 * xlr[ip1 + 2] + xlr[ip1 + 1]) / 2.0));
        return storage;
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        return result;
    }

    static {
        int i = 0;
        while (i < 21) {
            int n = i++;
            xlr[n] = xlr[n] * 0.9858;
        }
    }
}

