/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public strictfp class Buffer {
    private static final transient byte PAD_BYTE = 32;
    private byte[] _bytes;
    private int _size = 0;
    private ByteOrder _byteOrder;

    private static final short getBEShort(byte[] b, int off) {
        return (short)((b[off + 0] & 0xFF) << 8 | b[off + 1] & 0xFF);
    }

    private static final int putBEShort(byte[] b, int off, short val) {
        b[off + 0] = (byte)(val >> 8 & 0xFF);
        b[off + 1] = (byte)(val & 0xFF);
        return 2;
    }

    private static final int getBEInt(byte[] b, int off) {
        return (b[off + 0] & 0xFF) << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    private static final int putBEInt(byte[] b, int off, int val) {
        b[off + 0] = (byte)(val >> 24 & 0xFF);
        b[off + 1] = (byte)(val >> 16 & 0xFF);
        b[off + 2] = (byte)(val >> 8 & 0xFF);
        b[off + 3] = (byte)(val & 0xFF);
        return 4;
    }

    private static final long getBELong(byte[] b, int off) {
        return ((long)b[off + 0] & 0xFFL) << 56 | ((long)b[off + 1] & 0xFFL) << 48 | ((long)b[off + 2] & 0xFFL) << 40 | ((long)b[off + 3] & 0xFFL) << 32 | ((long)b[off + 4] & 0xFFL) << 24 | ((long)b[off + 5] & 0xFFL) << 16 | ((long)b[off + 6] & 0xFFL) << 8 | (long)b[off + 7] & 0xFFL;
    }

    private static final int putBELong(byte[] b, int off, long val) {
        b[off + 0] = (byte)(val >> 56 & 0xFFL);
        b[off + 1] = (byte)(val >> 48 & 0xFFL);
        b[off + 2] = (byte)(val >> 40 & 0xFFL);
        b[off + 3] = (byte)(val >> 32 & 0xFFL);
        b[off + 4] = (byte)(val >> 24 & 0xFFL);
        b[off + 5] = (byte)(val >> 16 & 0xFFL);
        b[off + 6] = (byte)(val >> 8 & 0xFFL);
        b[off + 7] = (byte)(val & 0xFFL);
        return 8;
    }

    private static final short getLEShort(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) << 8 | b[off + 0] & 0xFF);
    }

    private static final int putLEShort(byte[] b, int off, short val) {
        b[off + 0] = (byte)(val & 0xFF);
        b[off + 1] = (byte)(val >> 8 & 0xFF);
        return 2;
    }

    private static final int getLEInt(byte[] b, int off) {
        return (b[off + 3] & 0xFF) << 24 | (b[off + 2] & 0xFF) << 16 | (b[off + 1] & 0xFF) << 8 | b[off + 0] & 0xFF;
    }

    private static final int putLEInt(byte[] b, int off, int val) {
        b[off + 0] = (byte)(val & 0xFF);
        b[off + 1] = (byte)(val >> 8 & 0xFF);
        b[off + 2] = (byte)(val >> 16 & 0xFF);
        b[off + 3] = (byte)(val >> 24 & 0xFF);
        return 4;
    }

    private static final long getLELong(byte[] b, int off) {
        return (long)b[off + 0] & 0xFFL | ((long)b[off + 1] & 0xFFL) << 8 | ((long)b[off + 2] & 0xFFL) << 16 | ((long)b[off + 3] & 0xFFL) << 24 | ((long)b[off + 4] & 0xFFL) << 32 | ((long)b[off + 5] & 0xFFL) << 40 | ((long)b[off + 6] & 0xFFL) << 48 | ((long)b[off + 7] & 0xFFL) << 56;
    }

    private static final int putLELong(byte[] b, int off, long val) {
        b[off + 0] = (byte)(val & 0xFFL);
        b[off + 1] = (byte)(val >> 8 & 0xFFL);
        b[off + 2] = (byte)(val >> 16 & 0xFFL);
        b[off + 3] = (byte)(val >> 24 & 0xFFL);
        b[off + 4] = (byte)(val >> 32 & 0xFFL);
        b[off + 5] = (byte)(val >> 40 & 0xFFL);
        b[off + 6] = (byte)(val >> 48 & 0xFFL);
        b[off + 7] = (byte)(val >> 56 & 0xFFL);
        return 8;
    }

    private static final short fromUnsigned(byte b) {
        return b < 0 ? (short)(b + 256) : (short)b;
    }

    private static final int fromUnsigned(short s) {
        return s < 0 ? s + 65536 : s;
    }

    private static final long fromUnsigned(int i) {
        return i < 0 ? (long)i + 0x100000000L : (long)i;
    }

    private static final byte toUnsigned(short s) {
        return s > 127 ? (byte)(s - 256) : (byte)s;
    }

    private static final short toUnsigned(int i) {
        return i > Short.MAX_VALUE ? (short)(i - 65536) : (short)i;
    }

    private static final int toUnsigned(long l) {
        return l > Integer.MAX_VALUE ? (int)(l - 0x100000000L) : (int)l;
    }

    private static final boolean isUTF(byte[] b, int off, int len) {
        boolean isUTF = false;
        int sequenceLength = -1;
        for (int i = 0; i < len; ++i) {
            short c = Buffer.fromUnsigned(b[off + i]);
            if (c < 128) {
                if (!isUTF || sequenceLength < 0) continue;
                return false;
            }
            if (c < 192) {
                if (isUTF && sequenceLength >= 0) {
                    if (--sequenceLength < 0) {
                        return false;
                    }
                    if (sequenceLength != 0) continue;
                    return true;
                }
                return false;
            }
            if (c >= 194 && c < 245) {
                if (isUTF && sequenceLength >= 0) {
                    return false;
                }
                isUTF = true;
                if (c < 224) {
                    sequenceLength = 1;
                    continue;
                }
                if (c < 240) {
                    sequenceLength = 2;
                    continue;
                }
                sequenceLength = 3;
                continue;
            }
            return false;
        }
        return isUTF && sequenceLength < 0;
    }

    private static final String getString(byte[] b, int off, int len) {
        String charset = Buffer.isUTF(b, off, len) ? "UTF-8" : "ISO-8859-1";
        try {
            return new String(b, off, len, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(b, off, len);
        }
    }

    private static final String getTrimmedString(byte[] b, int off, int len) {
        int begin;
        int end = off + (len - 1);
        for (begin = off; begin < end && Buffer.fromUnsigned(b[begin]) <= 32; ++begin) {
        }
        while (end >= begin && Buffer.fromUnsigned(b[end]) <= 32) {
            --end;
        }
        return Buffer.getString(b, begin, end - begin + 1);
    }

    public static final byte[] getBytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }

    public Buffer(int maxSize) {
        this(maxSize, ByteOrder.BIG_ENDIAN);
    }

    public Buffer(int maxSize, ByteOrder byteOrder) {
        this._bytes = new byte[maxSize];
        this._size = 0;
        this._byteOrder = byteOrder;
    }

    public int read(RandomAccessFile in, int offset, int byteCount) throws IOException {
        if (this._bytes.length + offset < byteCount) {
            byte[] newBytes = new byte[byteCount + offset];
            System.arraycopy(this._bytes, 0, newBytes, 0, this._bytes.length);
            this._bytes = newBytes;
        }
        this._size = in.read(this._bytes, offset, byteCount);
        return this._size;
    }

    public int read(InputStream in, int offset, int byteCount) throws IOException {
        if (offset + byteCount > this._bytes.length) {
            byte[] newBytes = new byte[byteCount + offset];
            System.arraycopy(this._bytes, 0, newBytes, 0, this._bytes.length);
            this._bytes = newBytes;
        }
        this._size = in.read(this._bytes, offset, byteCount);
        return this._size;
    }

    public void write(RandomAccessFile out, int offset, int byteCount) throws IOException {
        out.write(this._bytes, offset, byteCount);
    }

    public void write(OutputStream out, int offset, int byteCount) throws IOException {
        out.write(this._bytes, offset, byteCount);
    }

    public void clear() {
        Arrays.fill(this._bytes, (byte)0);
        this._size = 0;
    }

    public void clear(int offset, int size) {
        Arrays.fill(this._bytes, offset, StrictMath.min(offset + size, this._bytes.length), (byte)0);
    }

    public int getSize() {
        return this._size;
    }

    public int getMaxSize() {
        return this._bytes.length;
    }

    public void ensureCapacity(int newMaxSize) {
        if (newMaxSize > this._bytes.length) {
            byte[] newBytes = new byte[newMaxSize];
            System.arraycopy(this._bytes, 0, newBytes, 0, this._bytes.length);
            this._bytes = newBytes;
        }
    }

    public ByteOrder getByteOrder() {
        return this._byteOrder;
    }

    public void setByteOrder(ByteOrder newOrder) {
        this._byteOrder = newOrder;
    }

    public final String getCString(int offset, int maxLen) {
        int len = maxLen;
        for (int i = 0; i < len; ++i) {
            if (this._bytes[offset + i] != 0) continue;
            len = i;
        }
        return Buffer.getTrimmedString(this._bytes, offset, len);
    }

    public final int putCString(int offset, int len, String str) {
        byte[] stringBytes = Buffer.getBytes(str);
        System.arraycopy(stringBytes, 0, this._bytes, offset, StrictMath.min(stringBytes.length, len));
        int padBytes = len - stringBytes.length;
        for (int i = 0; i < padBytes; ++i) {
            this._bytes[offset + stringBytes.length + i] = 0;
        }
        return len;
    }

    public final String getJustifiedString(int offset, int len) {
        return Buffer.getTrimmedString(this._bytes, offset, len);
    }

    public final int putJustifiedString(int offset, int len, String str, int just) {
        int i;
        byte[] stringBytes = Buffer.getBytes(str);
        int totalPadChars = len - stringBytes.length;
        int leftPadChars = 0;
        int rightPadChars = 0;
        if (totalPadChars > 0) {
            switch (just) {
                case 2: {
                    rightPadChars = totalPadChars;
                    break;
                }
                case 0: {
                    leftPadChars = (int)StrictMath.floor((double)totalPadChars / 2.0);
                    rightPadChars = (int)StrictMath.ceil((double)totalPadChars / 2.0);
                    break;
                }
                case 4: {
                    leftPadChars = totalPadChars;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown justification: " + just);
                }
            }
        }
        for (i = 0; i < leftPadChars; ++i) {
            this._bytes[offset + i] = 32;
        }
        System.arraycopy(stringBytes, 0, this._bytes, offset + leftPadChars, StrictMath.min(stringBytes.length, len));
        for (i = 0; i < rightPadChars; ++i) {
            this._bytes[offset + leftPadChars + stringBytes.length + i] = 32;
        }
        return len;
    }

    public final String getPascalString(int offset) {
        return Buffer.getTrimmedString(this._bytes, offset + 1, this.getUnsignedByte(offset));
    }

    public final int putPascalString(int offset, String str) {
        byte[] stringBytes = Buffer.getBytes(str);
        int length = StrictMath.min(stringBytes.length, 255);
        this.putUnsignedByte(offset, (short)length);
        for (int i = 0; i < length; ++i) {
            this._bytes[offset + 1 + i] = stringBytes[i];
        }
        return length + 1;
    }

    public final char getChar(int offset) {
        return Buffer.getString(this._bytes, offset, 1).charAt(0);
    }

    public final int putChar(int offset, char val) {
        this._bytes[offset] = Buffer.getBytes(new String(new char[]{val}))[0];
        return 1;
    }

    public final byte getByte(int offset) {
        return this._bytes[offset];
    }

    public final int putByte(int offset, byte val) {
        this._bytes[offset] = val;
        return 1;
    }

    public final short getUnsignedByte(int offset) {
        return Buffer.fromUnsigned(this._bytes[offset]);
    }

    public final int putUnsignedByte(int offset, short val) {
        return this.putByte(offset, Buffer.toUnsigned(val));
    }

    public final short getShort(int offset) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Buffer.getBEShort(this._bytes, offset) : Buffer.getLEShort(this._bytes, offset);
    }

    public final int putShort(int offset, short val) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Buffer.putBEShort(this._bytes, offset, val) : Buffer.putLEShort(this._bytes, offset, val);
    }

    public final int getUnsignedShort(int offset) {
        return Buffer.fromUnsigned(this.getShort(offset));
    }

    public final int putUnsignedShort(int offset, int val) {
        return this.putShort(offset, Buffer.toUnsigned(val));
    }

    public final int getInt(int offset) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Buffer.getBEInt(this._bytes, offset) : Buffer.getLEInt(this._bytes, offset);
    }

    public final int putInt(int offset, int val) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Buffer.putBEInt(this._bytes, offset, val) : Buffer.putLEInt(this._bytes, offset, val);
    }

    public final long getUnsignedInt(int offset) {
        return Buffer.fromUnsigned(this.getInt(offset));
    }

    public final int putUnsignedInt(int offset, long val) {
        return this.putInt(offset, Buffer.toUnsigned(val));
    }

    public final long getLong(int offset) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Buffer.getBELong(this._bytes, offset) : Buffer.getLELong(this._bytes, offset);
    }

    public final int putLong(int offset, long val) {
        return this._byteOrder == ByteOrder.BIG_ENDIAN ? Buffer.putBELong(this._bytes, offset, val) : Buffer.putLELong(this._bytes, offset, val);
    }

    public final float getFloat(int offset) {
        return Float.intBitsToFloat(this.getInt(offset));
    }

    public final int putFloat(int offset, float val) {
        return this.putInt(offset, Float.floatToIntBits(val));
    }

    public final double getDouble(int offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    public final int putDouble(int offset, double val) {
        return this.putLong(offset, Double.doubleToLongBits(val));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public strictfp static enum ByteOrder {
        BIG_ENDIAN,
        LITTLE_ENDIAN;

    }
}

